/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime.eval;

import com.thebeastshop.bgel.ast.ASTIndexExpression;
import com.thebeastshop.bgel.ast.ASTNode;
import com.thebeastshop.bgel.exception.BgelAccessException;
import com.thebeastshop.bgel.exception.BgelCastException;
import com.thebeastshop.bgel.exception.BgelEvalException;
import com.thebeastshop.bgel.exception.BgelNullException;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import com.thebeastshop.bgel.runtime.wrapper.NumberWrapper;
import com.thebeastshop.bgel.runtime.wrapper.Wrapper;
import com.thebeastshop.bgel.utils.AccessUtils;
import com.thebeastshop.bgel.utils.MetaHelper;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class IndexEvaluator {
    public Object evaluate(BgelRuntimeContext context, ASTIndexExpression indexExpression, Object left, Object index) {
        if (left == null) {
            throw new BgelNullException(context, indexExpression);
        }
        Class<?> clazz = left.getClass();
        if (!clazz.isArray()) {
            left = MetaHelper.wrap(left);
        }
        Class<?> indexClazz = index.getClass();
        Integer intIndex = null;
        if (index instanceof NumberWrapper) {
            intIndex = ((NumberWrapper)index).intValue();
        }
        if (clazz.isArray() || List.class.isAssignableFrom(clazz)) {
            if (intIndex == null) {
                throw new BgelCastException(context, (ASTNode)indexExpression, indexClazz, Integer.class);
            }
            if (clazz.isArray()) {
                return MetaHelper.wrap(Array.get(left, intIndex));
            }
            if (List.class.isAssignableFrom(clazz)) {
                return MetaHelper.wrap(((List)((Wrapper)left).getOriginalObject()).get(intIndex));
            }
        }
        try {
            return AccessUtils.accessObject(left, index.toString());
        }
        catch (IllegalAccessException e) {
            throw new BgelEvalException(context, indexExpression.getIndex(), e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BgelEvalException(context, indexExpression.getIndex(), e.getMessage(), (Throwable)e);
        }
        catch (BgelAccessException e) {
            throw new BgelEvalException(context, indexExpression.getIndex(), e.getMessage());
        }
    }
}

