/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime.eval;

import com.thebeastshop.bgel.ast.ASTBinaryExpression;
import com.thebeastshop.bgel.exception.BgelEvalException;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import com.thebeastshop.bgel.utils.MetaHelper;
import org.antlr.v4.runtime.Token;

public class CompareEvaluator {
    public Boolean evaluate(BgelRuntimeContext context, ASTBinaryExpression node, Object left, Object right) {
        left = MetaHelper.wrap(left);
        right = MetaHelper.wrap(right);
        Class<?> leftClass = left.getClass();
        Class<?> rightClass = right.getClass();
        Token op = node.getOperation();
        if (!(left instanceof Comparable)) {
            throw new BgelEvalException(context, node, "operator " + op.getText() + " do not support for type " + leftClass);
        }
        if (!(right instanceof Comparable)) {
            throw new BgelEvalException(context, node, "operator " + op.getText() + " do not support for type " + rightClass);
        }
        try {
            Comparable leftCom = (Comparable)((Object)MetaHelper.wrap(left));
            Comparable rightCom = (Comparable)((Object)MetaHelper.wrap(right));
            switch (op.getType()) {
                case 9: {
                    return leftCom.compareTo(rightCom) > 0;
                }
                case 13: {
                    return leftCom.compareTo(rightCom) >= 0;
                }
                case 10: {
                    return leftCom.compareTo(rightCom) < 0;
                }
                case 14: {
                    return leftCom.compareTo(rightCom) <= 0;
                }
                case 15: {
                    return leftCom.compareTo(rightCom) == 0;
                }
                case 16: {
                    return leftCom.compareTo(rightCom) != 0;
                }
            }
        }
        catch (ClassCastException ex) {
            throw new BgelEvalException(context, node, "Can not use comparison operator '" + op.getText() + "' between " + leftClass.getName() + " and " + rightClass.getName());
        }
        throw new BgelEvalException(context, node, "operator " + op.getText() + " do not support for type " + leftClass + " and " + rightClass);
    }
}

