/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime;

import com.thebeastshop.bgel.runtime.MetaClass;
import com.thebeastshop.bgel.runtime.MetaClassFactory;
import com.thebeastshop.bgel.runtime.wrapper.Wrapper;
import com.thebeastshop.bgel.utils.MetaHelper;

public class MethodParameterTypes {
    private final Class[] types;
    private boolean isVarArgs = false;

    public MethodParameterTypes(Class[] paramTypes) {
        this.types = new Class[paramTypes.length];
        for (int i = 0; i < this.types.length; ++i) {
            Class clazz;
            this.types[i] = clazz = paramTypes[i];
        }
    }

    public boolean isValidArguments(Object[] args) {
        int len = this.types.length;
        if (len > args.length) {
            return false;
        }
        if (len < args.length && !this.isVarArgs) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            Class paramType = this.types[i];
            paramType = MetaHelper.autoboxType(paramType);
            Object arg = args[i];
            Class argType = arg.getClass();
            if (arg instanceof Wrapper) {
                argType = ((Wrapper)arg).getOriginalClass();
            }
            if (Number.class.isAssignableFrom(paramType) && Number.class.isAssignableFrom(argType) || paramType.isAssignableFrom(argType)) continue;
            return false;
        }
        return true;
    }

    public long calculateDistanceWithArguments(Object[] args) {
        int distance = 0;
        int len = this.types.length;
        for (int i = 0; i < len; ++i) {
            Class paramType = this.types[i];
            Object arg = args[i];
            arg = MetaHelper.unwrap(arg);
            Class<?> argType = arg.getClass();
            long d = this.calculateDistanceWithType(paramType, argType);
            distance = (int)((long)distance + d);
        }
        return distance;
    }

    public long calculateDistanceWithType(Class paramType, Class argType) {
        MetaClass paramMetaClass = MetaClassFactory.getMetaClass(paramType);
        return paramMetaClass.getTypeDistance(argType);
    }

    public Class[] getTypes() {
        return this.types;
    }

    public int getTypeCount() {
        return this.types.length;
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    public void setVarArgs(boolean varArgs) {
        this.isVarArgs = varArgs;
    }

    public boolean equalsTypes(Class[] argTypes) {
        if (this.types.length != argTypes.length) {
            return false;
        }
        for (int i = 0; i < this.types.length; ++i) {
            Class paramType = this.types[i];
            Class argType = argTypes[i];
            if (paramType == argType) continue;
            return false;
        }
        return true;
    }
}

