/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.compile;

import com.thebeastshop.bgel.antlr.BgelLexer;
import com.thebeastshop.bgel.antlr.BgelParser;
import com.thebeastshop.bgel.ast.ASTNode;
import com.thebeastshop.bgel.ast.ASTTransformVisitor;
import com.thebeastshop.bgel.compile.BgelCompileConfiguration;
import com.thebeastshop.bgel.compile.BgelCompiledResult;
import com.thebeastshop.bgel.compile.BgelErrorListener;
import com.thebeastshop.bgel.compile.BgelSource;
import com.thebeastshop.bgel.exception.BgelException;
import java.io.IOException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class BgelCompiler {
    private final BgelSource source;
    private BgelCompileConfiguration compileConfiguration;

    public BgelCompiler(BgelSource source) {
        this(source, null);
    }

    public BgelCompiler(BgelSource source, BgelCompileConfiguration compileConfiguration) {
        this.source = source;
        this.compileConfiguration = compileConfiguration;
    }

    public BgelCompiledResult compile() {
        ASTNode node = this.compileToAST();
        return new BgelCompiledResult(this.source, node);
    }

    private ASTNode compileToAST() {
        ANTLRInputStream charStream = null;
        try {
            charStream = new ANTLRInputStream(this.source.getInputStream());
        }
        catch (IOException e) {
            throw new BgelException("Failed to initialize input stream: ", e);
        }
        return this.compileToAST((CharStream)charStream);
    }

    private ASTNode compileToAST(CharStream inputStream) {
        BgelErrorListener errorListener = new BgelErrorListener(this.source, this.compileConfiguration.getMaxParseErrorNumber());
        BgelLexer lexer = new BgelLexer(inputStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        BgelParser parser = new BgelParser((TokenStream)tokenStream);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        BgelParser.CompilationUnitContext compilationUnitContext = parser.compilationUnit();
        ASTTransformVisitor transformVisitor = new ASTTransformVisitor(this.compileConfiguration);
        errorListener.interruptIfHasError();
        return (ASTNode)transformVisitor.visitCompilationUnit(compilationUnitContext);
    }
}

