package com.thebeastshop.scm.vo.recommend;

import java.math.BigDecimal;

import pers.richard.ormybatis.domain.core.AbstractDomain;

/**
 * 推荐调用接口传参VO 
 * @author donghui
 */
public class RecommendParamVO extends AbstractDomain {
	private Type type;//推荐类型
	private Integer limitSize;//记录数
	private String chnCode; //渠道
	private Integer memberLevel;
	private Integer accessWay;
	private BigDecimal discount;//会员折扣
	private BigDecimal bdDiscount;//生日折扣
	private String productCode;//为商品详细推荐时,需要商品code

	private String userId;
	private String imei;
	private String ip;
	private String sceneId;

	public RecommendParamVO(){}
	
	
	/** 推荐类型 */
	public enum Type{
		SHOPPING_CART,// 购物车推荐
		ADD_ON_ITEM,// 免邮凑单推荐
		PROD_DETAIL;//商品详细推荐"
	}


	public Type getType() {
		return type;
	}


	public void setType(Type type) {
		this.type = type;
	}


	public Integer getLimitSize() {
		return limitSize;
	}


	public void setLimitSize(Integer limitSize) {
		this.limitSize = limitSize;
	}


	public String getChnCode() {
		return chnCode;
	}


	public void setChnCode(String chnCode) {
		this.chnCode = chnCode;
	}


	public Integer getMemberLevel() {
		return memberLevel;
	}


	public void setMemberLevel(Integer memberLevel) {
		this.memberLevel = memberLevel;
	}


	public Integer getAccessWay() {
		return accessWay;
	}


	public void setAccessWay(Integer accessWay) {
		this.accessWay = accessWay;
	}


	public BigDecimal getDiscount() {
		return discount;
	}


	public void setDiscount(BigDecimal discount) {
		this.discount = discount;
	}


	public String getProductCode() {
		return productCode;
	}


	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}
	public BigDecimal getBdDiscount() {
		return bdDiscount;
	}

	public void setBdDiscount(BigDecimal bdDiscount) {
		this.bdDiscount = bdDiscount;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getImei() {
		return imei;
	}

	public void setImei(String imei) {
		this.imei = imei;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public String getSceneId() {
		return sceneId;
	}

	public void setSceneId(String sceneId) {
		this.sceneId = sceneId;
	}
}