package com.thebeastshop.scm.vo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.joda.time.DateTime;

import pers.richard.ormybatis.domain.core.AbstractDomain;

public class SkuEsVO extends AbstractDomain {
	private Integer skuId;
    private String skuCode;
    private String skuName;
    private String skuNameCN;

    /**  SKU类型（创建后不可修改），1原材料2半成品3成品  */
    private Integer skuType;

    /** 是否自产（创建后不可修改），0否1是 */
    private Integer isMadeBySelf;

    private Integer isImported;

    /** 定制SKU编码，null表示不是定制产品 */
    private String skuCustomMadeCode;

    /** 组合SKU配方，null表示不是配方产品  */
    private String combinedSkuRecipeCode;

    /** 是否来单制作（高单价的组合配方SKU），0否1是  */
    private Integer isJit;

    private String ean13;

    /**  条形码 */
    private String barcode;

    /** 是否可采购，0否1是 */
    private Integer canPurchase;

    /**  成本价  */
    private BigDecimal costPrice;

	/** 售价 */
    private BigDecimal salesPrice;

    /** 品类  */
    private Integer categoryId;
    private String categoryName;

    /** 品牌   */
    private Integer brandId;
    private String brandName;
    private String brandNameCN;
    private Integer brandCountryId;
    private String brandCountryName;

    /** 产地   */
    private String placeOfOrigin;

    /** 供应商  */
    private Integer supplierId;
    private String supplierName;
    private String supplierNameCN;

    private String skuCategoryName;

    /** 是否可以备注  */
    private Integer canRemark;

    /**  积分抵扣规则，0不可抵扣1部分抵扣2全部抵扣 */
    private Integer pointDeductRule;

    /**  积分抵扣使用积分  */
    private BigDecimal pointDeductPoint = BigDecimal.ZERO;

    /** 积分抵扣后金额  */
    private BigDecimal pointDuductPrice = BigDecimal.ZERO;

    /**  跨境购标注 0普通 1跨境购   */
    private Integer crossBorderFlag;
	private String weight;
	private String taxNo;
	private String clearanceWay;//通关方式 0：未知，1：BC，2：个人
	private String updateTime = new DateTime().toString("yyyy-MM-dd HH:mm:ss");

	/**
     * 前台类目
     * map key:{id:[int],parentId:[int], name, code, fullName,isLeaf[int],sort1[int],sort2[int]}
     */
    private List<Map> frontCategoryList = new ArrayList<Map>();

	private Integer isMonthSend;

	private Integer monthSendDeliveryRule;

	private Integer canCustomizeSalesPrice;

	public SkuEsVO() {}

	public Integer getSkuId() {return skuId;}
	public void setSkuId(Integer skuId) {this.skuId = skuId;}

	public String getSkuCode() {return skuCode;}
	public void setSkuCode(String skuCode) {this.skuCode = skuCode;}

	public String getSkuName() {return skuName;}
	public void setSkuName(String skuName) {this.skuName = skuName;}

	public String getSkuNameCN() {return skuNameCN;}
	public void setSkuNameCN(String skuNameCN) {this.skuNameCN = skuNameCN;}

	public Integer getSkuType() {return skuType;}
	public void setSkuType(Integer skuType) {this.skuType = skuType;}

	public Integer getIsMadeBySelf() {return isMadeBySelf;}
	public void setIsMadeBySelf(Integer isMadeBySelf) {this.isMadeBySelf = isMadeBySelf;}

	public Integer getIsImported() {return isImported;}
	public void setIsImported(Integer isImported) {this.isImported = isImported;}

	public String getSkuCustomMadeCode() {return skuCustomMadeCode;}
	public void setSkuCustomMadeCode(String skuCustomMadeCode) {this.skuCustomMadeCode = skuCustomMadeCode;}

	public String getCombinedSkuRecipeCode() {return combinedSkuRecipeCode;}
	public void setCombinedSkuRecipeCode(String combinedSkuRecipeCode) {this.combinedSkuRecipeCode = combinedSkuRecipeCode;}

	public Integer getIsJit() {return isJit;}
	public void setIsJit(Integer isJit) {this.isJit = isJit;}

	public String getEan13() {return ean13;}
	public void setEan13(String ean13) {this.ean13 = ean13;}

	public String getBarcode() {return barcode;}
	public void setBarcode(String barcode) {this.barcode = barcode;}

	public Integer getCanPurchase() {return canPurchase;}
	public void setCanPurchase(Integer canPurchase) {this.canPurchase = canPurchase;}

	public BigDecimal getCostPrice() {return costPrice;}
	public void setCostPrice(BigDecimal costPrice) {this.costPrice = costPrice;}

	public BigDecimal getSalesPrice() {return salesPrice;}
	public void setSalesPrice(BigDecimal salesPrice) {this.salesPrice = salesPrice;}

	public Integer getCategoryId() {return categoryId;}
	public void setCategoryId(Integer categoryId) {this.categoryId = categoryId;}

	public String getCategoryName() {return categoryName;}
	public void setCategoryName(String categoryName) {this.categoryName = categoryName;}

	public Integer getBrandId() {return brandId;}
	public void setBrandId(Integer brandId) {this.brandId = brandId;}

	public String getBrandName() {return brandName;}
	public void setBrandName(String brandName) {this.brandName = brandName;}

	public String getBrandNameCN() {return brandNameCN;}
	public void setBrandNameCN(String brandNameCN) {this.brandNameCN = brandNameCN;}

	public Integer getBrandCountryId() {return brandCountryId;}
	public void setBrandCountryId(Integer brandCountryId) {this.brandCountryId = brandCountryId;}

	public String getBrandCountryName() {return brandCountryName;}
	public void setBrandCountryName(String brandCountryName) {this.brandCountryName = brandCountryName;}

	public String getPlaceOfOrigin() {return placeOfOrigin;}
	public void setPlaceOfOrigin(String placeOfOrigin) {this.placeOfOrigin = placeOfOrigin;}

	public Integer getSupplierId() {return supplierId;}
	public void setSupplierId(Integer supplierId) {this.supplierId = supplierId;}

	public String getSupplierName() {return supplierName;}
	public void setSupplierName(String supplierName) {this.supplierName = supplierName;}

	public String getSupplierNameCN() {return supplierNameCN;}
	public void setSupplierNameCN(String supplierNameCN) {this.supplierNameCN = supplierNameCN;}

	public String getSkuCategoryName() {return skuCategoryName;}
	public void setSkuCategoryName(String skuCategoryName) {this.skuCategoryName = skuCategoryName;}

	public Integer getCanRemark() {return canRemark;}
	public void setCanRemark(Integer canRemark) {this.canRemark = canRemark;}

	public Integer getPointDeductRule() {return pointDeductRule;}
	public void setPointDeductRule(Integer pointDeductRule) {this.pointDeductRule = pointDeductRule;}

	public BigDecimal getPointDeductPoint() {return pointDeductPoint;}
	public void setPointDeductPoint(BigDecimal pointDeductPoint) {this.pointDeductPoint = pointDeductPoint;}

	public BigDecimal getPointDuductPrice() {return pointDuductPrice;}
	public void setPointDuductPrice(BigDecimal pointDuductPrice) {this.pointDuductPrice = pointDuductPrice;}

	public Integer getCrossBorderFlag() {return crossBorderFlag;}
	public void setCrossBorderFlag(Integer crossBorderFlag) {this.crossBorderFlag = crossBorderFlag;}

	public String getWeight() {return weight;}
	public void setWeight(String weight) {this.weight = weight;}

	public String getTaxNo() {return taxNo;}
	public void setTaxNo(String taxNo) {this.taxNo = taxNo;}

	public String getUpdateTime() {return updateTime;}
	public void setUpdateTime(String updateTime) {this.updateTime = updateTime;}

	public List<Map> getFrontCategoryList() {return frontCategoryList;}
	public void setFrontCategoryList(List<Map> frontCategoryList) {this.frontCategoryList = frontCategoryList;}

	public String getClearanceWay() {return clearanceWay;}
	public void setClearanceWay(String clearanceWay) {this.clearanceWay = clearanceWay;}

	public Integer getIsMonthSend() {
		return isMonthSend;
	}

	public void setIsMonthSend(Integer isMonthSend) {
		this.isMonthSend = isMonthSend;
	}

	public Integer getMonthSendDeliveryRule() {
		return monthSendDeliveryRule;
	}

	public void setMonthSendDeliveryRule(Integer monthSendDeliveryRule) {
		this.monthSendDeliveryRule = monthSendDeliveryRule;
	}

	public Integer getCanCustomizeSalesPrice() {
		return canCustomizeSalesPrice;
	}

	public void setCanCustomizeSalesPrice(Integer canCustomizeSalesPrice) {
		this.canCustomizeSalesPrice = canCustomizeSalesPrice;
	}
}
