package com.thebeastshop.scm.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.time.DateFormatUtils;

import com.thebeastshop.scm.po.Member;
import com.thebeastshop.scm.po.SessionType;
import com.thebeastshop.scm.po.UserSign;

import pers.richard.ormybatis.domain.core.AbstractDomain;

public class MemberVO extends AbstractDomain{
	private Integer id;
	private Integer oid;
	private String code;
	private Integer memberStatus;
	private Integer memberLevel;
	private Integer startupLevel;
	private String nickName;
	private Integer gender;
	private String phone;
	private String mobile;
	private String email;
	private Integer registerSource;
	private Date registerTime;
	private Date birthday;
	private Integer districtId;
	private String address;
	private String zipCode;
	private Integer title;
	private String avatarUrl;
	private String job;
	private Integer constellation;
	private Integer degree;
	private String accountWechat;
	private String accountWeibo;
	private Date lastLoginTime;
	private String mergeTo;
	private String remark;
	private String Province;
	private String District;
	private Date lastLevelUpdateTime;
	private BigDecimal lastLevelUpdateConsumption;
	private String verifiedMobile;
	private String mobileCode;
	private Integer birthdayDiscountYear;
	
	private Integer greatestMemberLevel;				// 会员等级=max(member_level,startup_level)
	private BigDecimal totalConsumptionAmount;			// 消费总金额（所有订单金额总和）
    private BigDecimal availablePoint;					// 有效积分,未过期
    private BigDecimal historyPoint;					// 已过期的积分
    private Date lastConsumeTime;						// 会员最后消费时间
    private List<Map<String,Object>> couponSample;		// 会员所拥有的优惠券模板名称,是否已经
    private List<UserSign> userSignList;				// 用户标签
    private Boolean needResendBirthdayMessage;			// 是否需要重发生日短信
    private List<SessionType> sessionTypeList;			// 会话类型

	public Integer getId() {
		return id;
	}
	public void setId(Integer id) {
		this.id = id;
	}
	public Integer getOid() {
		return oid;
	}

	public void setOid(Integer oid) {
		this.oid = oid;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public Integer getMemberStatus() {
		return memberStatus;
	}

	public void setMemberStatus(Integer memberStatus) {
		this.memberStatus = memberStatus;
	}

	public Integer getMemberLevel() {
		return memberLevel;
	}

	public void setMemberLevel(Integer memberLevel) {
		this.memberLevel = memberLevel;
	}

	public Integer getStartupLevel() {
		return startupLevel;
	}

	public void setStartupLevel(Integer startupLevel) {
		this.startupLevel = startupLevel;
	}

	public String getNickName() {
		return nickName;
	}

	public void setNickName(String nickName) {
		this.nickName = nickName;
	}

	public Integer getGender() {
		return gender;
	}

	public void setGender(Integer gender) {
		this.gender = gender;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public Integer getRegisterSource() {
		return registerSource;
	}

	public void setRegisterSource(Integer registerSource) {
		this.registerSource = registerSource;
	}

	public Date getRegisterTime() {
		return registerTime;
	}

	public void setRegisterTime(Date registerTime) {
		this.registerTime = registerTime;
	}

	public Date getBirthday() {
		return birthday;
	}

	public void setBirthday(Date birthday) {
		this.birthday = birthday;
	}

	public Integer getDistrictId() {
		return districtId;
	}

	public void setDistrictId(Integer districtId) {
		this.districtId = districtId;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getZipCode() {
		return zipCode;
	}

	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}

	public Integer getTitle() {
		return title;
	}

	public void setTitle(Integer title) {
		this.title = title;
	}

	public String getAvatarUrl() {
		return avatarUrl;
	}

	public void setAvatarUrl(String avatarUrl) {
		this.avatarUrl = avatarUrl;
	}

	public String getJob() {
		return job;
	}

	public void setJob(String job) {
		this.job = job;
	}

	public Integer getConstellation() {
		return constellation;
	}

	public void setConstellation(Integer constellation) {
		this.constellation = constellation;
	}

	public Integer getDegree() {
		return degree;
	}

	public void setDegree(Integer degree) {
		this.degree = degree;
	}

	public String getAccountWechat() {
		return accountWechat;
	}

	public void setAccountWechat(String accountWechat) {
		this.accountWechat = accountWechat;
	}

	public String getAccountWeibo() {
		return accountWeibo;
	}

	public void setAccountWeibo(String accountWeibo) {
		this.accountWeibo = accountWeibo;
	}

	public Date getLastLoginTime() {
		return lastLoginTime;
	}

	public void setLastLoginTime(Date lastLoginTime) {
		this.lastLoginTime = lastLoginTime;
	}

	public String getMergeTo() {
		return mergeTo;
	}

	public void setMergeTo(String mergeTo) {
		this.mergeTo = mergeTo;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getProvince() {
		return Province;
	}

	public void setProvince(String province) {
		Province = province;
	}

	public String getDistrict() {
		return District;
	}

	public void setDistrict(String district) {
		District = district;
	}

	public Date getLastLevelUpdateTime() {
		return lastLevelUpdateTime;
	}

	public void setLastLevelUpdateTime(Date lastLevelUpdateTime) {
		this.lastLevelUpdateTime = lastLevelUpdateTime;
	}

	public BigDecimal getLastLevelUpdateConsumption() {
		return lastLevelUpdateConsumption;
	}

	public void setLastLevelUpdateConsumption(BigDecimal lastLevelUpdateConsumption) {
		this.lastLevelUpdateConsumption = lastLevelUpdateConsumption;
	}

	public String getVerifiedMobile() {
		return verifiedMobile;
	}

	public void setVerifiedMobile(String verifiedMobile) {
		this.verifiedMobile = verifiedMobile;
	}

	public String getMobileCode() {
		return mobileCode;
	}

	public void setMobileCode(String mobileCode) {
		this.mobileCode = mobileCode;
	}

	public Integer getBirthdayDiscountYear() {
		return birthdayDiscountYear;
	}

	public void setBirthdayDiscountYear(Integer birthdayDiscountYear) {
		this.birthdayDiscountYear = birthdayDiscountYear;
	}

	public Integer getGreatestMemberLevel() {
		return greatestMemberLevel;
	}

	public void setGreatestMemberLevel(Integer greatestMemberLevel) {
		this.greatestMemberLevel = greatestMemberLevel;
	}

	public BigDecimal getTotalConsumptionAmount() {
		return totalConsumptionAmount;
	}

	public void setTotalConsumptionAmount(BigDecimal totalConsumptionAmount) {
		this.totalConsumptionAmount = totalConsumptionAmount;
	}

	public BigDecimal getAvailablePoint() {
		return availablePoint;
	}

	public void setAvailablePoint(BigDecimal availablePoint) {
		this.availablePoint = availablePoint;
	}

	public BigDecimal getHistoryPoint() {
		return historyPoint;
	}

	public void setHistoryPoint(BigDecimal historyPoint) {
		this.historyPoint = historyPoint;
	}

	public Date getLastConsumeTime() {
		return lastConsumeTime;
	}
	public void setLastConsumeTime(Date lastConsumeTime) {
		this.lastConsumeTime = lastConsumeTime;
	}
	public List<Map<String, Object>> getCouponSample() {
		return couponSample;
	}
	public void setCouponSample(List<Map<String, Object>> couponSample) {
		this.couponSample = couponSample;
	}
	public List<UserSign> getUserSignList() {
		return userSignList;
	}
	public void setUserSignList(List<UserSign> userSignList) {
		this.userSignList = userSignList;
	}
	public Boolean getNeedResendBirthdayMessage() {
		return needResendBirthdayMessage;
	}
	public void setNeedResendBirthdayMessage(Boolean needResendBirthdayMessage) {
		this.needResendBirthdayMessage = needResendBirthdayMessage;
	}

	public List<SessionType> getSessionTypeList() {
		return sessionTypeList;
	}
	public void setSessionTypeList(List<SessionType> sessionTypeList) {
		this.sessionTypeList = sessionTypeList;
	}
	/**
     * 会员等级
     *
     * @return
     */
    public String getMemberLevelName() {

    	return greatestMemberLevel == null ? "" :
            greatestMemberLevel.equals(Member.MEMBER_LEVEL_VIP) ? "蚂蚁" :
                    greatestMemberLevel.equals(Member.MEMBER_LEVEL_VVIP) ? "小猫" :
                            greatestMemberLevel.equals(Member.MEMBER_LEVEL_3VIP) ? "老虎" :
                                    greatestMemberLevel.equals(Member.MEMBER_LEVEL_4VIP) ? "大象" :
                                            greatestMemberLevel.equals(Member.MEMBER_LEVEL_NORMAL) ? "注册会员" : "";
    }

    // 是否已用过生日折扣（birthdayDiscountYear与当前年份做比较）
 	public Boolean getIsUserbirthdayDiscount(){
 		if(birthdayDiscountYear != null){
 			Integer now = Integer.parseInt(DateFormatUtils.format(System.currentTimeMillis(), "yyyy"));

 			return  birthdayDiscountYear >= now;
 		}
 
 		return false;
 	}
}