package com.thebeastshop.scm.es;

import com.thebeastshop.scm.po.CampaignSectionProduct;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-07-17
 */
public class PsCampaignSectionProductVO extends PsBaseVO {

    private Long id;

    private Long productId;

    private BigDecimal productPrice;

    private Integer productCount;

    private Integer limitCount;

    private Integer sort;

    public PsCampaignSectionProductVO() {
    }

    public PsCampaignSectionProductVO(CampaignSectionProduct sectionProduct) {
        id = sectionProduct.getId().longValue();
        productId = sectionProduct.getAdditionalProductId();
        productCount = sectionProduct.getAdditionalProductCount();
        productPrice = sectionProduct.getAdditionalProductPrice();
        limitCount = sectionProduct.getLimitCount();
        sort = sectionProduct.getSort();
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = new HashMap<>();
        map.put("id", id);
        map.put("productId", productId);
        if (productPrice != null) {
            map.put("productPrice", productPrice);
        }
        if (productCount != null) {
            map.put("productCount", productCount);
        }
        if (limitCount != null) {
            map.put("limitCount", limitCount);
        }
        if (sort != null) {
            map.put("sort", sort);
        }
        return map;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public BigDecimal getProductPrice() {
        return productPrice;
    }

    public void setProductPrice(BigDecimal productPrice) {
        this.productPrice = productPrice;
    }

    public Integer getProductCount() {
        return productCount;
    }

    public void setProductCount(Integer productCount) {
        this.productCount = productCount;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }
}
