package com.thebeastshop.scm.po;

import java.math.BigDecimal;
import java.util.Date;

import pers.richard.ormybatis.domain.po.IdPo;

public class Sku extends IdPo {
	private Integer brandId;
	private Integer categoryId;
	private Integer oldSupplierId;
	private Integer defaultSupplierId;
	private String merchantCode;
	private String code;
	private Date createTime;
	private Integer skuType;
	private Integer isMadeBySelf;
	private Integer isImported;
	private Integer skuStatus;
	private String name;
	private String nameCn;
	private String skuCustomMadeCode;
	private String combinedSkuRecipeCode;
	private Integer isJit;
	private String ean13;
	private String barcode;
	private Integer canPurchase;
	private BigDecimal costPrice;
	private BigDecimal oldSalesPrice;
	private BigDecimal salesPrice;
	private Integer moq;
	private String placeOfOrigin;
	private String material;
	private String specification;
	private String size;
	private Integer pictureFileId;
	private String remark;
	private String purchaseRemark;
	private Integer pointDeductRule;
	private BigDecimal pointDeductPoint;
	private BigDecimal pointDuductPrice;
	private String skuCategoryName;
	private Integer canRemark;
	private Integer canCustomizeSalesPrice;
	private Integer serviceLevel;
	private Date saleStartDate;
	private Date saleEndDate;
	private Integer buyerId;
	private Integer isSaled;
	private String executingStandard;
	private Integer crossBorderFlag;
	private Integer shelfLife;
	private String suggestPackage;
	private String weight;
	private String taxNo;
	private Integer numIid;
	private Integer storageType;
	private String skuImg;
	private String nameSale;
	private String supplierProductCode;
	private Integer whetherConsignment;
	private Integer deliveryPeriod;
	private Integer preBoxNum;
	private Integer whetherVipDisdount;
	private BigDecimal oldCostPrice;
	private String goodsBarcode;
	private String goodsHscode;
	private String goodsUnitcode;
	private String goodsOriginCountryCode;
	private String clearanceWay;//通关方式 0：未知，1：BC，2：个人
	
	/** 通关方式 */
	public enum ClearanceWay{
		UNKNOWN(0),//未知
		BC(1),//BC
		PERSION(2);//个人
		
		public Integer value;
		private ClearanceWay(Integer value){
			this.value = value;
		}
	}
	
	public enum SkuStatus{
		DRAFT(0,"待提交"),
		WAITING_VERIFY(1,"待品类经理审批"),
		WAITING_FINANCE_VERIFY(3, "价格待财务审核"),
		REJECT(2, "已驳回"),
		ABLE(9, "可用");
		
		public Integer value;
		public String cn;
		private SkuStatus(Integer value, String cn){
			this.value = value;
			this.cn = cn;
		}
	}
	
	public Sku(){}
	public final static String
		F_BRAND_ID = "brand_id",
		F_CATEGORY_ID = "category_id",
		F_OLD_SUPPLIER_ID = "old_supplier_id",
		F_DEFAULT_SUPPLIER_ID = "default_supplier_id",
		F_MERCHANT_CODE = "merchant_code",
		F_CODE = "code",
		F_CREATE_TIME = "create_time",
		F_SKU_TYPE = "sku_type",
		F_IS_MADE_BY_SELF = "is_made_by_self",
		F_IS_IMPORTED = "is_imported",
		F_SKU_STATUS = "sku_status",
		F_NAME = "name",
		F_NAME_CN = "name_cn",
		F_SKU_CUSTOM_MADE_CODE = "sku_custom_made_code",
		F_COMBINED_SKU_RECIPE_CODE = "combined_sku_recipe_code",
		F_IS_JIT = "is_jit",
		F_EAN13 = "ean13",
		F_BARCODE = "barcode",
		F_CAN_PURCHASE = "can_purchase",
		F_COST_PRICE = "cost_price",
		F_OLD_SALES_PRICE = "old_sales_price",
		F_SALES_PRICE = "sales_price",
		F_MOQ = "moq",
		F_PLACE_OF_ORIGIN = "place_of_origin",
		F_MATERIAL = "material",
		F_SPECIFICATION = "specification",
		F_SIZE = "size",
		F_PICTURE_FILE_ID = "picture_file_id",
		F_REMARK = "remark",
		F_PURCHASE_REMARK = "purchase_remark",
		F_POINT_DEDUCT_RULE = "point_deduct_rule",
		F_POINT_DEDUCT_POINT = "point_deduct_point",
		F_POINT_DUDUCT_PRICE = "point_duduct_price",
		F_SKU_CATEGORY_NAME = "sku_category_name",
		F_CAN_REMARK = "can_remark",
		F_CAN_CUSTOMIZE_SALES_PRICE = "can_customize_sales_price",
		F_SERVICE_LEVEL = "service_level",
		F_SALE_START_DATE = "sale_start_date",
		F_SALE_END_DATE = "sale_end_date",
		F_BUYER_ID = "buyer_id",
		F_IS_SALED = "is_saled",
		F_EXECUTING_STANDARD = "executing_standard",
		F_CROSS_BORDER_FLAG = "cross_border_flag",
		F_SHELF_LIFE = "shelf_life",
		F_SUGGEST_PACKAGE = "suggest_package",
		F_WEIGHT = "weight",
		F_TAX_NO = "tax_no",
		F_NUM_IID = "num_iid",
		F_STORAGE_TYPE = "storage_type",
		F_SKU_IMG = "sku_img",
		F_NAME_SALE = "name_sale",
		F_SUPPLIER_PRODUCT_CODE = "supplier_product_code",
		F_WHETHER_CONSIGNMENT = "whether_consignment",
		F_DELIVERY_PERIOD = "delivery_period",
		F_PRE_BOX_NUM = "pre_box_num",
		F_WHETHER_VIP_DISDOUNT = "whether_vip_disdount",
		F_OLD_COST_PRICE = "old_cost_price",
		F_GOODS_BARCODE = "goods_barcode",
		F_GOODS_HSCODE = "goods_hscode",
		F_GOODS_UNITCODE = "goods_unitcode",
		F_GOODS_ORIGIN_COUNTRY_CODE = "goods_origin_country_code",
		F_CLEARANCEWAY = "clearance_way";

	public Integer getBrandId() {return brandId;}
	public void setBrandId(Integer brandId) {this.brandId = brandId;}

	public Integer getCategoryId() {return categoryId;}
	public void setCategoryId(Integer categoryId) {this.categoryId = categoryId;}

	public Integer getOldSupplierId() {return oldSupplierId;}
	public void setOldSupplierId(Integer oldSupplierId) {this.oldSupplierId = oldSupplierId;}

	public Integer getDefaultSupplierId() {return defaultSupplierId;}
	public void setDefaultSupplierId(Integer defaultSupplierId) {this.defaultSupplierId = defaultSupplierId;}

	public String getMerchantCode() {return merchantCode;}
	public void setMerchantCode(String merchantCode) {this.merchantCode = merchantCode;}

	public String getCode() {return code;}
	public void setCode(String code) {this.code = code;}

	public Date getCreateTime() {return createTime;}
	public void setCreateTime(Date createTime) {this.createTime = createTime;}

	public Integer getSkuType() {return skuType;}
	public void setSkuType(Integer skuType) {this.skuType = skuType;}

	public Integer getIsMadeBySelf() {return isMadeBySelf;}
	public void setIsMadeBySelf(Integer isMadeBySelf) {this.isMadeBySelf = isMadeBySelf;}

	public Integer getIsImported() {return isImported;}
	public void setIsImported(Integer isImported) {this.isImported = isImported;}

	public Integer getSkuStatus() {return skuStatus;}
	public void setSkuStatus(Integer skuStatus) {this.skuStatus = skuStatus;}

	public String getName() {return name;}
	public void setName(String name) {this.name = name;}

	public String getNameCn() {return nameCn;}
	public void setNameCn(String nameCn) {this.nameCn = nameCn;}

	public String getSkuCustomMadeCode() {return skuCustomMadeCode;}
	public void setSkuCustomMadeCode(String skuCustomMadeCode) {this.skuCustomMadeCode = skuCustomMadeCode;}

	public String getCombinedSkuRecipeCode() {return combinedSkuRecipeCode;}
	public void setCombinedSkuRecipeCode(String combinedSkuRecipeCode) {this.combinedSkuRecipeCode = combinedSkuRecipeCode;}

	public Integer getIsJit() {return isJit;}
	public void setIsJit(Integer isJit) {this.isJit = isJit;}

	public String getEan13() {return ean13;}
	public void setEan13(String ean13) {this.ean13 = ean13;}

	public String getBarcode() {return barcode;}
	public void setBarcode(String barcode) {this.barcode = barcode;}

	public Integer getCanPurchase() {return canPurchase;}
	public void setCanPurchase(Integer canPurchase) {this.canPurchase = canPurchase;}

	public BigDecimal getCostPrice() {return costPrice;}
	public void setCostPrice(BigDecimal costPrice) {this.costPrice = costPrice;}

	public BigDecimal getOldSalesPrice() {return oldSalesPrice;}
	public void setOldSalesPrice(BigDecimal oldSalesPrice) {this.oldSalesPrice = oldSalesPrice;}

	public BigDecimal getSalesPrice() {return salesPrice;}
	public void setSalesPrice(BigDecimal salesPrice) {this.salesPrice = salesPrice;}

	public Integer getMoq() {return moq;}
	public void setMoq(Integer moq) {this.moq = moq;}

	public String getPlaceOfOrigin() {return placeOfOrigin;}
	public void setPlaceOfOrigin(String placeOfOrigin) {this.placeOfOrigin = placeOfOrigin;}

	public String getMaterial() {return material;}
	public void setMaterial(String material) {this.material = material;}

	public String getSpecification() {return specification;}
	public void setSpecification(String specification) {this.specification = specification;}

	public String getSize() {return size;}
	public void setSize(String size) {this.size = size;}

	public Integer getPictureFileId() {return pictureFileId;}
	public void setPictureFileId(Integer pictureFileId) {this.pictureFileId = pictureFileId;}

	public String getRemark() {return remark;}
	public void setRemark(String remark) {this.remark = remark;}

	public String getPurchaseRemark() {return purchaseRemark;}
	public void setPurchaseRemark(String purchaseRemark) {this.purchaseRemark = purchaseRemark;}

	public Integer getPointDeductRule() {return pointDeductRule;}
	public void setPointDeductRule(Integer pointDeductRule) {this.pointDeductRule = pointDeductRule;}

	public BigDecimal getPointDeductPoint() {return pointDeductPoint;}
	public void setPointDeductPoint(BigDecimal pointDeductPoint) {this.pointDeductPoint = pointDeductPoint;}

	public BigDecimal getPointDuductPrice() {return pointDuductPrice;}
	public void setPointDuductPrice(BigDecimal pointDuductPrice) {this.pointDuductPrice = pointDuductPrice;}

	public String getSkuCategoryName() {return skuCategoryName;}
	public void setSkuCategoryName(String skuCategoryName) {this.skuCategoryName = skuCategoryName;}

	public Integer getCanRemark() {return canRemark;}
	public void setCanRemark(Integer canRemark) {this.canRemark = canRemark;}

	public Integer getCanCustomizeSalesPrice() {return canCustomizeSalesPrice;}
	public void setCanCustomizeSalesPrice(Integer canCustomizeSalesPrice) {this.canCustomizeSalesPrice = canCustomizeSalesPrice;}

	public Integer getServiceLevel() {return serviceLevel;}
	public void setServiceLevel(Integer serviceLevel) {this.serviceLevel = serviceLevel;}

	public Date getSaleStartDate() {return saleStartDate;}
	public void setSaleStartDate(Date saleStartDate) {this.saleStartDate = saleStartDate;}

	public Date getSaleEndDate() {return saleEndDate;}
	public void setSaleEndDate(Date saleEndDate) {this.saleEndDate = saleEndDate;}

	public Integer getBuyerId() {return buyerId;}
	public void setBuyerId(Integer buyerId) {this.buyerId = buyerId;}

	public Integer getIsSaled() {return isSaled;}
	public void setIsSaled(Integer isSaled) {this.isSaled = isSaled;}

	public String getExecutingStandard() {return executingStandard;}
	public void setExecutingStandard(String executingStandard) {this.executingStandard = executingStandard;}

	public Integer getCrossBorderFlag() {return crossBorderFlag;}
	public void setCrossBorderFlag(Integer crossBorderFlag) {this.crossBorderFlag = crossBorderFlag;}

	public Integer getShelfLife() {return shelfLife;}
	public void setShelfLife(Integer shelfLife) {this.shelfLife = shelfLife;}

	public String getSuggestPackage() {return suggestPackage;}
	public void setSuggestPackage(String suggestPackage) {this.suggestPackage = suggestPackage;}

	public String getWeight() {return weight;}
	public void setWeight(String weight) {this.weight = weight;}

	public String getTaxNo() {return taxNo;}
	public void setTaxNo(String taxNo) {this.taxNo = taxNo;}

	public Integer getNumIid() {return numIid;}
	public void setNumIid(Integer numIid) {this.numIid = numIid;}

	public Integer getStorageType() {return storageType;}
	public void setStorageType(Integer storageType) {this.storageType = storageType;}

	public String getSkuImg() {return skuImg;}
	public void setSkuImg(String skuImg) {this.skuImg = skuImg;}

	public String getNameSale() {return nameSale;}
	public void setNameSale(String nameSale) {this.nameSale = nameSale;}

	public String getSupplierProductCode() {return supplierProductCode;}
	public void setSupplierProductCode(String supplierProductCode) {this.supplierProductCode = supplierProductCode;}

	public Integer getWhetherConsignment() {return whetherConsignment;}
	public void setWhetherConsignment(Integer whetherConsignment) {this.whetherConsignment = whetherConsignment;}

	public Integer getDeliveryPeriod() {return deliveryPeriod;}
	public void setDeliveryPeriod(Integer deliveryPeriod) {this.deliveryPeriod = deliveryPeriod;}

	public Integer getPreBoxNum() {return preBoxNum;}
	public void setPreBoxNum(Integer preBoxNum) {this.preBoxNum = preBoxNum;}

	public Integer getWhetherVipDisdount() {return whetherVipDisdount;}
	public void setWhetherVipDisdount(Integer whetherVipDisdount) {this.whetherVipDisdount = whetherVipDisdount;}

	public BigDecimal getOldCostPrice() {return oldCostPrice;}
	public void setOldCostPrice(BigDecimal oldCostPrice) {this.oldCostPrice = oldCostPrice;}

	public String getGoodsBarcode() {return goodsBarcode;}
	public void setGoodsBarcode(String goodsBarcode) {this.goodsBarcode = goodsBarcode;}

	public String getGoodsHscode() {return goodsHscode;}
	public void setGoodsHscode(String goodsHscode) {this.goodsHscode = goodsHscode;}

	public String getGoodsUnitcode() {return goodsUnitcode;}
	public void setGoodsUnitcode(String goodsUnitcode) {this.goodsUnitcode = goodsUnitcode;}

	public String getGoodsOriginCountryCode() {return goodsOriginCountryCode;}
	public void setGoodsOriginCountryCode(String goodsOriginCountryCode) {this.goodsOriginCountryCode = goodsOriginCountryCode;}
	
	public String getClearanceWay() {return clearanceWay;}
	public void setClearanceWay(String clearanceWay) {this.clearanceWay = clearanceWay;}
}