/*
 * Decompiled with CFR 0.152.
 */
package pers.richard.ormybatis.util;

import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.MapUtils;

public class ReflectUtil {
    public static Field getFieldByFieldName(Object obj, String fieldName) {
        Class<?> superClass = obj.getClass();
        while (superClass != Object.class) {
            try {
                return superClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                superClass = superClass.getSuperclass();
            }
        }
        return null;
    }

    public static Object getValueByFieldName(Object obj, String fieldName) throws Exception {
        Field field = ReflectUtil.getFieldByFieldName(obj, fieldName);
        Object value = null;
        if (field != null) {
            if (field.isAccessible()) {
                value = field.get(obj);
            } else {
                field.setAccessible(true);
                value = field.get(obj);
                field.setAccessible(false);
            }
        }
        return value;
    }

    public static void setValueByFieldName(Object obj, String fieldName, Object value) throws Exception {
        Field field = obj.getClass().getDeclaredField(fieldName);
        if (field.isAccessible()) {
            field.set(obj, value);
        } else {
            field.setAccessible(true);
            field.set(obj, value);
            field.setAccessible(false);
        }
    }

    public static Object getBeanPropertyValue(Object bean, String propertyName) {
        Object value = new Object();
        try {
            if (bean instanceof Map) {
                Map map = (Map)bean;
                value = MapUtils.getObject((Map)map, (Object)propertyName, (Object)"");
            } else {
                value = PropertyUtils.getSimpleProperty((Object)bean, (String)propertyName);
            }
        }
        catch (Exception e) {
            return null;
        }
        return value;
    }

    public static void setBeanPropertyValue(Object bean, String propertyName, Object propertyValue) {
        try {
            if (bean instanceof Map) {
                Map map = (Map)bean;
                map.put(propertyName, propertyValue);
            } else {
                PropertyUtils.setSimpleProperty((Object)bean, (String)propertyName, (Object)propertyValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

