/*
 * Decompiled with CFR 0.152.
 */
package pers.richard.ormybatis.dao;

import com.google.common.base.CaseFormat;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.annotation.AnnotationUtils;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.bean.mapping.DeleteMappingParamBean;
import pers.richard.ormybatis.bean.mapping.InsertBatchMappingParamBean;
import pers.richard.ormybatis.bean.mapping.InsertMappingParamBean;
import pers.richard.ormybatis.bean.mapping.SelectFieldMappingParamBean;
import pers.richard.ormybatis.bean.mapping.SelectMappingParamBean;
import pers.richard.ormybatis.bean.mapping.UpdateMappingParamBean;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.domain.core.AbstractDomain;
import pers.richard.ormybatis.domain.paging.PagingParam;
import pers.richard.ormybatis.domain.paging.PagingResult;
import pers.richard.ormybatis.domain.po.IdPo;
import pers.richard.ormybatis.util.ObjUtils;
import pers.richard.ormybatis.util.ReflectUtil;

public class BaseDao<T extends IdPo>
extends SqlSessionTemplate
implements InitializingBean {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String BASE_SQL_NAMESPACE = "ormybatis";
    protected String primaryKeyName = "id";
    protected String tableName = this.getTableName();
    protected String namespace = this.getNamespace();

    public BaseDao(SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public PagingResult<T> paging(Integer page, Integer size, Map<String, Object> paramMap) {
        return this.paging(page, size, new WhereBuilder().eq(paramMap));
    }

    public PagingResult<T> paging(Integer page, Integer size, WhereBuilder whereBuilder) {
        PagingResult pagingResult = new PagingResult();
        pagingResult.setPage(page);
        pagingResult.setSize(size);
        int limitIndex = (page - 1) * size;
        whereBuilder.limit(limitIndex, size);
        Integer count = this.count(whereBuilder);
        if (count > 0) {
            List<T> record = this.selectList(whereBuilder);
            pagingResult.setRecord(record);
            pagingResult.setCount(count);
        }
        return pagingResult;
    }

    public <E> PagingResult<E> paging(String statement, PagingParam pagingParam) {
        Integer totalCount = (Integer)this.selectOne(String.valueOf(statement) + "Count", pagingParam);
        if (totalCount == 0) {
            return new PagingResult();
        }
        if (pagingParam == null) {
            pagingParam = new PagingParam();
        }
        List<E> record = this.selectList(statement, pagingParam);
        return new PagingResult(pagingParam, totalCount, record);
    }

    public <E> PagingResult<E> paging(String statement, Object pagingParamObject) {
        Integer count = (Integer)this.selectOne(String.valueOf(statement) + "Count", pagingParamObject);
        if (count == 0) {
            return new PagingResult();
        }
        Object pageObj = ReflectUtil.getBeanPropertyValue(pagingParamObject, "page");
        Object sizeObj = ReflectUtil.getBeanPropertyValue(pagingParamObject, "size");
        if (ObjUtils.isBlank(pageObj)) {
            ReflectUtil.setBeanPropertyValue(pagingParamObject, "page", 1);
        }
        if (ObjUtils.isBlank(sizeObj)) {
            ReflectUtil.setBeanPropertyValue(pagingParamObject, "size", 20);
        }
        Integer page = NumberUtils.toInt((String)pageObj.toString());
        Integer size = NumberUtils.toInt((String)sizeObj.toString());
        List<E> record = this.selectList(statement, pagingParamObject);
        return new PagingResult(page, size, count, record);
    }

    public T selectOne(Number id) {
        WhereBuilder whereBuilder = new WhereBuilder().eq(this.primaryKeyName, id);
        return this.selectOne(whereBuilder);
    }

    public T selectOne(Map<String, Object> paramMap) {
        WhereBuilder whereBuilder = new WhereBuilder().eq(paramMap).orderDesc(this.primaryKeyName);
        return this.selectOne(whereBuilder);
    }

    public T selectOne(WhereBuilder wherebuilder) {
        wherebuilder.limit(1);
        List<T> result = this.selectList(wherebuilder);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        return (T)((IdPo)ObjUtils.get(result, 0));
    }

    public List<T> selectList(List<Number> ids) {
        WhereBuilder whereBuilder = new WhereBuilder().in(this.primaryKeyName, ids);
        return this.selectList(whereBuilder);
    }

    public List<T> selectList(Map<String, Object> paramMap) {
        WhereBuilder whereBuilder = new WhereBuilder().eq(paramMap);
        return this.selectList(whereBuilder);
    }

    public List<T> selectList(WhereBuilder whereBuilder) {
        String statement = this.getBaseSqlStatement("selecListByWhereBuilder");
        SelectMappingParamBean selectMappingParamBean = new SelectMappingParamBean(this.tableName, this.primaryKeyName, whereBuilder);
        List mapList = super.selectList(statement, (Object)selectMappingParamBean);
        List<T> list = this.toPoList(mapList);
        return list;
    }

    public <E> List<E> selectFieldList(String field, Map<String, Object> paramMap) {
        WhereBuilder whereBuilder = new WhereBuilder().eq(paramMap);
        return this.selectFieldList(field, whereBuilder);
    }

    public <E> List<E> selectFieldList(String field, WhereBuilder whereBuilder) {
        String statement = this.getBaseSqlStatement("selecFieldByWhereBuilder");
        SelectFieldMappingParamBean selectFieldMappingParamBean = new SelectFieldMappingParamBean(this.tableName, this.primaryKeyName, field, whereBuilder);
        return super.selectList(statement, (Object)selectFieldMappingParamBean);
    }

    public int count(Map<String, Object> paramMap) {
        WhereBuilder whereBuilder = new WhereBuilder().eq(paramMap);
        return this.count(whereBuilder);
    }

    public Integer count(WhereBuilder whereBuilder) {
        String statement = this.getBaseSqlStatement("countByWhereBuilder");
        SelectMappingParamBean selectMappingParamBean = new SelectMappingParamBean(this.tableName, this.primaryKeyName, whereBuilder);
        return (Integer)super.selectOne(statement, (Object)selectMappingParamBean);
    }

    public Integer insert(T po) {
        String statement = this.getBaseSqlStatement("insert");
        InsertMappingParamBean insertMappingParamBean = new InsertMappingParamBean(this.tableName, this.primaryKeyName, (AbstractDomain)po);
        int num = super.insert(statement, (Object)insertMappingParamBean);
        po.setId((Number)insertMappingParamBean.getInsertId());
        return num;
    }

    public int insertBatch(List<T> poList) {
        String statement = this.getBaseSqlStatement("insertBatch");
        InsertBatchMappingParamBean insertBatchMappingParamBean = new InsertBatchMappingParamBean(this.tableName, this.primaryKeyName, poList);
        return super.insert(statement, (Object)insertBatchMappingParamBean);
    }

    public int insertOrUpdate(T po) {
        int num = this.update(po);
        if (num == 0) {
            num = this.insert(po);
        }
        return num;
    }

    public int insertOrUpdate(T po, WhereBuilder whereBuilder) {
        T selectPo = this.selectOne(whereBuilder);
        if (selectPo == null) {
            return this.insert(po);
        }
        po.setId(selectPo.getId());
        return this.update(po);
    }

    public int update(T po) {
        Map updateFieldMap = po.toMap();
        UpdateBuilder updateBuilder = new UpdateBuilder().updateEq(updateFieldMap).whereEq(this.primaryKeyName, po.getId());
        return this.update(updateBuilder);
    }

    public int update(UpdateBuilder updateBuilder) {
        if (updateBuilder.getWhereBuilder().isEmptyOperExpressList()) {
            return 0;
        }
        String statement = this.getBaseSqlStatement("updateByBuilder");
        UpdateMappingParamBean updateMappingParamBean = new UpdateMappingParamBean(this.tableName, this.primaryKeyName, updateBuilder);
        return super.update(statement, (Object)updateMappingParamBean);
    }

    public int delete(Number ... ids) {
        WhereBuilder whereBuilder = new WhereBuilder().in(this.primaryKeyName, Arrays.asList(ids));
        return this.delete(whereBuilder);
    }

    public int delete(WhereBuilder whereBuilder) {
        if (whereBuilder.isEmptyOperExpressList()) {
            return 0;
        }
        String statement = this.getBaseSqlStatement("delete");
        DeleteMappingParamBean deleteMappingParamBean = new DeleteMappingParamBean(this.tableName, this.primaryKeyName, whereBuilder);
        return super.delete(statement, (Object)deleteMappingParamBean);
    }

    public <E> E selectOne(String statement) {
        return (E)super.selectOne(this.getStatement(statement));
    }

    public <E> E selectOne(String statement, Object parameter) {
        return (E)super.selectOne(this.getStatement(statement), parameter);
    }

    public <E> List<E> selectList(String statement) {
        return super.selectList(this.getStatement(statement));
    }

    public <E> List<E> selectList(String statement, Object parameter) {
        return super.selectList(this.getStatement(statement), parameter);
    }

    public int insert(String statement) {
        return super.insert(this.getStatement(statement));
    }

    public int insert(String statement, Object parameter) {
        return super.insert(this.getStatement(statement), parameter);
    }

    public int update(String statement) {
        return super.update(this.getStatement(statement));
    }

    public int update(String statement, Object parameter) {
        return super.update(this.getStatement(statement), parameter);
    }

    public int delete(String statement) {
        return super.delete(this.getStatement(statement));
    }

    public int delete(String statement, Object parameter) {
        return super.delete(this.getStatement(statement), parameter);
    }

    protected void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    private String getNamespace() {
        String name = ((Object)((Object)this)).getClass().getSimpleName();
        name = StringUtils.removeEndIgnoreCase((String)name, (String)"Dao");
        name = StringUtils.uncapitalize((String)name);
        return name;
    }

    private String getTableName() {
        String namespace = this.getNamespace();
        String tableName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, namespace);
        return tableName;
    }

    private String getStatement(String statement) {
        return String.valueOf(this.namespace) + "." + statement;
    }

    private String getBaseSqlStatement(String statement) {
        return String.valueOf("ormybatis") + "." + statement;
    }

    public void afterPropertiesSet() throws Exception {
        String namespace;
        Annotation annotation = AnnotationUtils.findAnnotation(((Object)((Object)this)).getClass(), DaoConfig.class);
        String table = (String)AnnotationUtils.getValue((Annotation)annotation, (String)"table");
        if (StringUtils.isNotBlank((CharSequence)table)) {
            this.tableName = table;
        }
        if (StringUtils.isNotBlank((CharSequence)(namespace = (String)AnnotationUtils.getValue((Annotation)annotation, (String)"namespace")))) {
            this.namespace = namespace;
        }
        String id = (String)AnnotationUtils.getValue((Annotation)annotation, (String)"id");
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            this.primaryKeyName = id;
        }
    }

    private T toPo(Map<String, Object> map) {
        HashMap<String, Object> camelKeyMap = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            String camelKey = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, key);
            if (value == null) continue;
            if (this.primaryKeyName.equals(key)) {
                camelKey = "id";
            }
            camelKeyMap.put(camelKey, value);
        }
        Type type = ((Object)((Object)this)).getClass().getGenericSuperclass();
        Type[] p = ((ParameterizedType)type).getActualTypeArguments();
        IdPo po = null;
        try {
            po = (IdPo)((Class)p[0]).newInstance();
            BeanUtils.populate((Object)po, camelKeyMap);
        }
        catch (Exception e) {
            this.log.error(null, (Throwable)e);
        }
        return (T)po;
    }

    private List<T> toPoList(List<Map<String, Object>> mapList) {
        ArrayList<T> result = new ArrayList<T>();
        for (Map<String, Object> map : mapList) {
            T po = this.toPo(map);
            result.add(po);
        }
        return result;
    }
}

