/*
 * Decompiled with CFR 0.152.
 */
package pers.richard.ormybatis.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import pers.richard.ormybatis.bean.OperationExpressionBean;
import pers.richard.ormybatis.bean.OrderByBean;
import pers.richard.ormybatis.domain.core.AbstractDomain;
import pers.richard.ormybatis.util.ObjUtils;

public class WhereBuilder
extends AbstractDomain {
    private List<OperationExpressionBean> operExpressList = new ArrayList<OperationExpressionBean>();
    private List<OrderByBean> orderByList = new ArrayList<OrderByBean>();
    private Integer limitIndex = 0;
    private Integer limitSize = null;
    private boolean isNotEmpty = false;

    public WhereBuilder() {
    }

    public WhereBuilder(String field, Object value) {
        this.eq(field, value);
    }

    public WhereBuilder eq(String field, Object value) {
        return this.setOperationExpression(field, "=", value);
    }

    public WhereBuilder eq(Map<String, Object> paramMap) {
        if (MapUtils.isNotEmpty(paramMap)) {
            for (String key : paramMap.keySet()) {
                this.eq(key, paramMap.get(key));
            }
        }
        return this;
    }

    public WhereBuilder gt(String field, Object value) {
        return this.setOperationExpression(field, ">", value);
    }

    public WhereBuilder gte(String field, Object value) {
        return this.setOperationExpression(field, ">=", value);
    }

    public WhereBuilder lt(String field, Object value) {
        return this.setOperationExpression(field, "<", value);
    }

    public WhereBuilder lte(String field, Object value) {
        return this.setOperationExpression(field, "<=", value);
    }

    public WhereBuilder like(String field, Object value) {
        return this.setOperationExpression(field, "like", value);
    }

    public WhereBuilder likeLeft(String field, Object value) {
        return this.setOperationExpression(field, "like_left", value);
    }

    public WhereBuilder likeRight(String field, Object value) {
        return this.setOperationExpression(field, "like_right", value);
    }

    public WhereBuilder betweenDateTime(String field, String startDateTime, String endDateTime) {
        return this.betweenByDateFormat(field, startDateTime, endDateTime, "%Y-%m-%d %T");
    }

    public WhereBuilder betweenDate(String field, String startDate, String endDate) {
        return this.betweenByDateFormat(field, startDate, endDate, "%Y-%m-%d");
    }

    public WhereBuilder betweenByDateFormat(String field, String startDate, String endDate, String format) {
        field = "DATE_FORMAT(" + field + ", '" + format + "')";
        if (StringUtils.isNotBlank((CharSequence)startDate)) {
            this.gte(field, startDate);
        }
        if (StringUtils.isNotBlank((CharSequence)endDate)) {
            this.lte(field, endDate);
        }
        return this;
    }

    public WhereBuilder in(String field, Object ... values) {
        return this.setOperationExpression(field, "in", values);
    }

    public WhereBuilder in(String field, List values) {
        return this.setOperationExpression(field, "in", values);
    }

    public WhereBuilder isNull(String field) {
        return this.setOperationExpression(field, "is_null", null, true);
    }

    public WhereBuilder isNotNull(String field) {
        return this.setOperationExpression(field, "is_not_null", null, true);
    }

    public WhereBuilder limit(int limitSize) {
        this.limitSize = limitSize;
        return this;
    }

    public WhereBuilder limit(int limitIndex, int limitSize) {
        this.limitIndex = limitIndex < 0 ? 0 : limitIndex;
        this.limitSize = limitSize;
        return this;
    }

    public WhereBuilder orderDesc(String field) {
        this.orderByList.add(new OrderByBean(field, "DESC"));
        return this;
    }

    public WhereBuilder orderAsc(String field) {
        this.orderByList.add(new OrderByBean(field, "ASC"));
        return this;
    }

    public WhereBuilder isNotEmpty(boolean isNotEmpty) {
        this.isNotEmpty = isNotEmpty;
        return this;
    }

    public boolean isEmptyOperExpressList() {
        return CollectionUtils.isEmpty(this.operExpressList);
    }

    private WhereBuilder setOperationExpression(String field, String oper, Object value) {
        return this.setOperationExpression(field, oper, value, true);
    }

    private WhereBuilder setOperationExpression(String field, String oper, Object value, boolean required) {
        if (this.isNotEmpty && ObjUtils.isBlank(value)) {
            return this;
        }
        OperationExpressionBean bean = new OperationExpressionBean(field, oper, value);
        this.operExpressList.add(bean);
        return this;
    }

    public List<OperationExpressionBean> getOperExpressList() {
        return this.operExpressList;
    }

    public void setOperExpressList(List<OperationExpressionBean> operExpressList) {
        this.operExpressList = operExpressList;
    }

    public List<OrderByBean> getOrderByList() {
        return this.orderByList;
    }

    public void setOrderByList(List<OrderByBean> orderByList) {
        this.orderByList = orderByList;
    }

    public Integer getLimitIndex() {
        return this.limitIndex;
    }

    public void setLimitIndex(Integer limitIndex) {
        this.limitIndex = limitIndex;
    }

    public Integer getLimitSize() {
        return this.limitSize;
    }

    public void setLimitSize(Integer limitSize) {
        this.limitSize = limitSize;
    }
}

