/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.scm.es.PsCustomizeColorVO;
import com.thebeastshop.scm.es.PsCustomizeElementVO;
import com.thebeastshop.scm.es.PsCustomizeImageVO;
import com.thebeastshop.scm.es.PsSkuCustomizationVO;
import com.thebeastshop.scm.po.SkuCustomization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table="t_pcs_sku_customization")
public class SkuCustomizationDao
extends BaseDao<SkuCustomization> {
    @Autowired
    public SkuCustomizationDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<PsSkuCustomizationVO> findBySkuCode(String skuCode) {
        ArrayList<PsSkuCustomizationVO> voList = new ArrayList<PsSkuCustomizationVO>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skuCode", skuCode);
        List list = super.selectList("findSkuCustomizationByIdsfindBySkuCode", params);
        for (SkuCustomization skuCustomization : list) {
            voList.add(new PsSkuCustomizationVO(skuCustomization));
        }
        return voList;
    }

    public List<PsCustomizeElementVO> findCustomizeElementList(String skuCode, Integer elementType, String positionIcon) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCode", skuCode);
        params.put("elementType", elementType);
        params.put("positionIcon", positionIcon);
        List list = super.selectList("findCustomizeElementList", params);
        for (PsCustomizeElementVO vo : list) {
            Integer type = vo.getElementType();
            ArrayList<PsCustomizeColorVO> colorVOs = new ArrayList<PsCustomizeColorVO>();
            String color = vo.getColor();
            List ListObj = (List)JSON.parseObject((String)color, List.class);
            if (CollectionUtils.isNotEmpty((Collection)ListObj)) {
                for (List listVO : ListObj) {
                    PsCustomizeColorVO colorVO = new PsCustomizeColorVO();
                    colorVO.setColorName((String)listVO.get(0));
                    colorVO.setColorValue((String)listVO.get(1));
                    if (listVO.size() > 2) {
                        colorVO.setBackgroundColorValue((String)listVO.get(2));
                    }
                    if (listVO.size() > 3) {
                        colorVO.setWordColorValue((String)listVO.get(3));
                    }
                    colorVOs.add(colorVO);
                }
            }
            vo.setColorList(colorVOs);
        }
        return list;
    }

    public List<PsCustomizeImageVO> findCustomizeImageList(String skuCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skuCode", skuCode);
        List list = super.selectList("findCustomizeImageList", params);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (PsCustomizeImageVO vo : list) {
                String attr = vo.getAttr();
                List listObj = (List)JSON.parseObject((String)attr, List.class);
                vo.setAttrs(listObj);
            }
        }
        return list;
    }
}

