/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.es.PsSkuAttributeVO;
import com.thebeastshop.scm.es.PsSkuVO;
import com.thebeastshop.scm.po.Sku;
import com.thebeastshop.scm.vo.EditProductSkuInfoVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table="t_pcs_sku")
public class SkuDao
extends BaseDao<Sku> {
    @Autowired
    public SkuDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public Sku byCode(String code) {
        return (Sku)super.selectOne(new WhereBuilder("code", (Object)code));
    }

    public Integer getCrossBorderFlagByCodes(List<String> codes) {
        return (Integer)super.selectOne("getCrossBorderFlagByCodes", codes);
    }

    public List<String> getSellOnLineByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<String>();
        }
        return super.selectList("getSellOnLineByCodes", codes);
    }

    public Integer getIsJitByCodes(List<String> codes) {
        return (Integer)super.selectOne("getIsJitByCodes", codes);
    }

    public List<PsSkuVO> getEsSkuVo(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.EMPTY_LIST;
        }
        return super.selectList("getEsSkuVo", codes);
    }

    public Date getLastSaleStartDateByCodes(List<String> skuCodes) {
        Date date = (Date)super.selectOne("getLastSaleStartDateByCodes", skuCodes);
        return date;
    }

    public Map getSaleStartDateAndProductIdBySkuCode(String skuCode) {
        return (Map)super.selectOne("getSaleStartDateAndProductIdBySkuCode", (Object)skuCode);
    }

    public Map getCategoryIdAndCategoryCodeByCodes(List<String> codes) {
        return (Map)super.selectOne("getCategoryIdAndCategoryCodeByCodes", codes);
    }

    public List<Integer> getProductIdBySkuCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.EMPTY_LIST;
        }
        return super.selectList("getProductIdBySkuCodes", codes);
    }

    public List<String> getAllCode() {
        return super.selectFieldList("code", new WhereBuilder().gt("id", (Object)0));
    }

    public Map<String, Object> getMinSalePrice(List<String> codes) {
        return (Map)super.selectOne("getMinSalePrice", codes);
    }

    public List<Map> getMinSalePriceSkuCodes(List<String> codes) {
        return super.selectList("getMinSalePriceSkuCodes", codes);
    }

    public List<Integer> getProductIdsByCodes(List<String> codes) {
        return super.selectList("getProductIdsByCodes", codes);
    }

    public List<EditProductSkuInfoVo> getEditProductSkuInfoByProdId(Integer productId) {
        return super.selectList("getEditProductSkuInfoByProdId", (Object)productId);
    }

    public List<EditProductSkuInfoVo> findNoUserdByNameOrCode(String value) {
        return super.selectList("findNoUserdByNameOrCode", (Object)value);
    }

    public List<Map> getCodeAndNameByProductCode(String productCode) {
        return super.selectList("getCodeAndNameByProductCode", (Object)productCode);
    }

    public List<PsSkuAttributeVO> getSkuAttributeBySkuCodes(List<String> skuCodes) {
        if (CollectionUtils.isEmpty(skuCodes)) {
            return Collections.EMPTY_LIST;
        }
        return super.selectList("getSkuAttributeBySkuCodes", skuCodes);
    }

    public Integer getFlowerMonthlyBySkuCode(String skuCode) {
        return (Integer)super.selectOne("getFlowerMonthlyBySkuCode", (Object)skuCode);
    }

    public Set<String> getSkuSample() {
        List list = super.selectList("getSkuSample");
        HashSet<String> sets = new HashSet<String>();
        for (String str : list) {
            sets.add(str);
        }
        return sets;
    }
}

