package com.thebeastshop.scm.dao;

import java.util.List;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.thebeastshop.scm.po.SessionType;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table = "t_op_session_type")
public class SessionTypeDao extends BaseDao<SessionType>{
	
	@Autowired
	public SessionTypeDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}

	/**
	 * 新增会话类型
	 * @param sessionType
	 * @return
	 */
	public void addSessionTypeList(List<SessionType> sessionType){
		super.insert("addSessionTypeList",sessionType);
	}
}