package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.es.PsCampaignSectionProductVO;
import com.thebeastshop.scm.po.CampaignSection;
import com.thebeastshop.scm.po.CampaignSectionProduct;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import java.util.ArrayList;
import java.util.List;

/**
 * @author gongjun
 * @since 2016-11-30
 */
@DaoConfig(table = "campaign_section_product")
public class CampaignSectionProductDao extends BaseDao<CampaignSectionProduct> {

    @Autowired
    public CampaignSectionProductDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<PsCampaignSectionProductVO> findCampaignSectionProductBySectionId(Long sectionId) {
        List<PsCampaignSectionProductVO> voList = new ArrayList<>();
        List<CampaignSectionProduct> list = super.selectList(
                new WhereBuilder("campaign_section_id", sectionId).eq("temp", 0).orderAsc("sort"));
        for (CampaignSectionProduct sectionProduct : list) {
            PsCampaignSectionProductVO sectionProductVO = new PsCampaignSectionProductVO(sectionProduct);
            voList.add(sectionProductVO);
        }
        return voList;
    }

}
