/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.google.common.collect.Lists;
import com.thebeastshop.scm.es.PsProductVO;
import com.thebeastshop.scm.po.Product;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table="t_op_product")
public class ProductDao
extends BaseDao<Product> {
    @Autowired
    public ProductDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public Product byCode(String code) {
        return (Product)super.selectOne(new WhereBuilder("code", (Object)code));
    }

    public List<Product> byProductIds(List<Integer> productIds) {
        return super.selectList(new WhereBuilder().in("id", productIds));
    }

    public List<String> getSkuCodesById(Integer id) {
        return super.selectList("getSkuCodeById", (Object)id);
    }

    public List<Map> getProductIdSkuCodes(List<Integer> productIds) {
        return super.selectList("getProductIdSkuCodes", productIds);
    }

    public List<String> getBarCodesBySkuCodes(List<String> skuCodes) {
        return super.selectList("getBarCodesBySkuCodes", skuCodes);
    }

    public List<String> getBuBySkuCodes(List<String> skuCodes) {
        return super.selectList("getBuBySkuCodes", skuCodes);
    }

    public List<Map> getSkuCodeBarCodes() {
        return super.selectList("getSkuCodeBarCodes");
    }

    public List<Map> getSkuCodeBu() {
        return super.selectList("getSkuCodeBu");
    }

    public List<PsProductVO> getPsProductVOByIds(List<Integer> ids) {
        return super.selectList("getPsProductVOByIds", ids);
    }

    public PsProductVO getPsProductVOById(Integer id) {
        return (PsProductVO)super.selectOne("getPsProductVOByIds", (Object)Lists.newArrayList((Object[])new Integer[]{id}));
    }

    public List<Integer> getAllProductId() {
        return super.selectFieldList("id", new WhereBuilder().gte("id", (Object)0).orderDesc("id"));
    }

    public List<Map> getAllProductIdAndSkuCodeByOnShelf() {
        return super.selectList("getAllIdAndSkuCodeByOnShelf");
    }

    public Long getCategoryIdByProductId(Long productId) {
        return (Long)super.selectOne("getCategoryIdByProductId", (Object)productId);
    }

    public List<Map> mailContentByIds(List<Integer> productIds) {
        return super.selectList("mailContentByIds", productIds);
    }

    public List<Map> listProdMat(Map params) {
        Integer page = MapUtils.getInteger((Map)params, (Object)"page", (Integer)1);
        Integer size = MapUtils.getInteger((Map)params, (Object)"size", (Integer)20);
        if (page > 0) {
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page - 1);
        }
        int start = page * size;
        params.put("start", start);
        return super.selectList("listProdMat", (Object)params);
    }

    public boolean isJitById(Integer productId) {
        Integer result = (Integer)super.selectOne("isJitById", (Object)productId);
        return result != null;
    }

    public List<String> isJitByIds(List<Integer> productIds) {
        List result = super.selectList("isJitByIds", productIds);
        ArrayList<String> list = new ArrayList<String>();
        for (Map map : result) {
            list.add((String)map.get("code"));
        }
        return list;
    }

    public boolean isCustomizeById(Integer productId) {
        Integer result = (Integer)super.selectOne("isCustomizeById", (Object)productId);
        return result != null;
    }

    public List<Integer> getJitCustomizeProductId() {
        List result = super.selectList("getJitCustomizeProductId");
        return result;
    }

    public List<Integer> getDiscountProductId() {
        List result = super.selectList("getDiscountProductId");
        return result;
    }

    public Boolean findByDiscountProductId(Integer productId) {
        Integer result = (Integer)super.selectOne("findByDiscountProductId", (Object)productId);
        return result != null;
    }

    public List<Map> getAllDetailBigImg() {
        return super.selectList("getAllDetailBigImg");
    }

    public Map getDetailBigImgByProdId(Integer productId) {
        return (Map)super.selectOne("getDetailBigImgByProdId", (Object)productId);
    }

    public List<Map> autoRecommendAutocomplete(String value) {
        return super.selectList("autoRecommendAutocomplete", (Object)value);
    }

    public Map recommendAutoByProdCode(String prodCode) {
        return (Map)super.selectOne("recommendAutoByProdCode", (Object)prodCode);
    }

    public Integer deleteOpClPsProdRepeatRecords() {
        return super.delete("deleteOpClPsProdRepeatRecords");
    }

    public Integer updateBrandIdByPrimaryKey(Long id, Integer brandId) {
        return super.update(new UpdateBuilder().updateEq("BRAND_ID", (Object)brandId).whereEq("id", (Object)id));
    }
}

