/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.ProductAutoDownFlag;
import java.util.Date;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;
import pers.richard.ormybatis.domain.po.IdPo;

@DaoConfig(table="t_op_product_auto_down_flag")
public class ProductAutoDownFlagDao
extends BaseDao<ProductAutoDownFlag> {
    @Autowired
    public ProductAutoDownFlagDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public void deleteTwoDay() {
        super.delete(new WhereBuilder().lt("create_time", (Object)new DateTime().minusDays(2).toDate()));
    }

    public void deleteXDay(int days) {
        super.delete(new WhereBuilder().lt("create_time", (Object)new DateTime().minusDays(days).toDate()));
    }

    public void save(Integer productId, Date createTime) {
        ProductAutoDownFlag productAutoDownFlag = new ProductAutoDownFlag();
        productAutoDownFlag.setProductId(productId);
        productAutoDownFlag.setCreateTime(createTime);
        super.insert((IdPo)productAutoDownFlag);
    }

    public int deleteByProductId(Integer productId) {
        return super.delete(new WhereBuilder("product_id", (Object)productId));
    }
}

