package com.thebeastshop.scm.dao;

import java.util.List;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.es.PsTagVO;
import com.thebeastshop.scm.po.Tag;

@DaoConfig(table = "t_pcs_tag")
public class TagDao extends BaseDao<Tag>{
	
	@Autowired
	public TagDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<PsTagVO> getPsTagVOByProdcutId(Integer productId){
		return super.selectList("getPsTagVOByProdcutId", productId);
	}

	public List<PsTagVO> getPsTagVOByAll(){
		return super.selectList("getPsTagVOByAll");
	}
}