package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.BusinessRecord;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by admin on 2018/11/16.
 */
@DaoConfig(table = "t_op_business_record")
public class BusinessRecordDao extends BaseDao<BusinessRecord> {
    @Autowired
    public BusinessRecordDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public BusinessRecord findBusinessTypeAndDetailId(String businessType,String businessDetailId){
        Map<String,Object> params = new HashMap<String,Object>();
        params.put("businessType",businessType);
        params.put("businessDetailId",businessDetailId);
        return super.selectOne("findBusinessTypeAndDetailId",params);
    }

    public Integer createData(BusinessRecord vo){
        return super.insert("createData",vo);
    }
}
