package com.thebeastshop.scm.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.scm.es.PsAttributeValuePairVO;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.es.PsAttributeVO;
import com.thebeastshop.scm.po.Attribute;

@DaoConfig(table = "t_op_attribute")
public class AttributeDao extends ScmBaseDao<Attribute>{
	
	@Autowired
	public AttributeDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<PsAttributeVO> getEsByProductId(Long productId) {
		List<Map> list = super.selectList("getEsByProductId", productId);
		list = convergeMapList(list, primaryKeyName);
		List<PsAttributeVO> result =  new ArrayList<>();
		for (Map attributeMap : list) {
			PsAttributeVO attributeVo = new PsAttributeVO(attributeMap);
			result.add(attributeVo);
		}
		return result;
	}

	public Map<Integer,List<PsAttributeVO>>getEsByProductIdAll() {
		Map<Integer,List<PsAttributeVO>> mapResult = new HashMap<Integer,List<PsAttributeVO>>();

		List<Map> listAll = super.selectList("getEsByProductIdAll");
		Map<Integer,List<Map>> productIdMap = new HashMap<Integer,List<Map>>();
		for(Map mapItem : listAll){
			if (mapItem.get("productId") == null){
				continue;
			}
			Integer productId = Integer.valueOf(mapItem.get("productId").toString());
			List<Map>  lstTemp = productIdMap.get(productId);
			if (lstTemp == null){
				lstTemp = new ArrayList<Map>();
				productIdMap.put(productId,lstTemp);
			}
			lstTemp.add(mapItem);
		}

		for(Map.Entry<Integer,List<Map>> mapItem : productIdMap.entrySet()){
			List<Map>  list = mapItem.getValue();
			list = convergeMapList(list, primaryKeyName);
			List<PsAttributeVO> listResult =  new ArrayList<>();
			for (Map attributeMap : list) {
				PsAttributeVO attributeVo = new PsAttributeVO(attributeMap);
				listResult.add(attributeVo);
			}
			mapResult.put(mapItem.getKey(),listResult);
		}
        return mapResult;
	}


	public List<PsAttributeValuePairVO> findPairByIds(List<Long> ids) {
		Map params = new HashMap();
		params.put("ids", ids);
		List<Map> list = super.selectList("findPairByIds", params);
		list = convergeMapList(list, primaryKeyName);
		List<PsAttributeValuePairVO> result =  new ArrayList<>();
		for (Map attributePairMap : list) {
			PsAttributeValuePairVO attributeValuePairVo = new PsAttributeValuePairVO(attributePairMap);
			result.add(attributeValuePairVo);
		}
		return result;

	}


}

