package com.thebeastshop.scm.dao;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.ProdCanSelfDelivery;

@DaoConfig(table = "t_op_prod_can_self_delivery")
public class ProdCanSelfDeliveryDao extends BaseDao<ProdCanSelfDelivery>{
	
	@Autowired
	public ProdCanSelfDeliveryDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<Map> getPsDeliveryVOByProductId(Integer productId){
		return super.selectList("getPsDeliveryVOByProductId", productId);
	}
}