package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.ClPsCampaign;
import com.thebeastshop.scm.po.ClPsProd;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import java.util.List;

import static pers.richard.ormybatis.domain.po.IdPo.F_ID;

/**
 * @author gongjun[dt_flys@hotmail.com]
 * @since 2016-11-20 19:59
 */
@DaoConfig(table = "campaign_cl_ps")
public class ClPsCampaignDao extends BaseDao<ClPsCampaign> {

    @Autowired
    public ClPsCampaignDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<ClPsCampaign> limit(int limitSize) {
        return super.selectList(new WhereBuilder().orderDesc(F_ID).limit(limitSize));
    }

    /**
     * 删除小于或者等于maxId的记录
     * @param maxId
     * @return
     */
    public int deleteMaxId(Integer maxId) {
        return super.delete(new WhereBuilder().lte(F_ID, maxId));
    }

}
