package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.es.PsCampaignVO;
import com.thebeastshop.scm.po.Campaign;
import com.thebeastshop.scm.po.CampaignProduct;
import org.apache.commons.collections.map.HashedMap;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * Desc:活动关联商品相关的dao接口
 * Created by hafiz.zhang on 2016/12/30.
 */
@DaoConfig(table = "campaign_product")
public class CampaignProductDao extends BaseDao<CampaignProduct> {

    @Autowired
    public CampaignProductDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    /**
     * 查找SKU对应的抢购信息
     */
    public CampaignProduct findCampaignProductBySkuCode(String skuCode, Long campaignId) {
        Map<String, Object> params = new HashedMap();
        params.put("skuCode", skuCode);
        params.put("campaignId", campaignId);
        CampaignProduct campaignProduct = super.selectOne("getLimitAmountBySkuCode", params);
        return campaignProduct;
    }
}
