package com.thebeastshop.scm.dao;

import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.thebeastshop.scm.po.SmsSendLog;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table = "t_sms_send_log")
public class SmsSendLogDao extends BaseDao<SmsSendLog>{

	@Autowired
	public SmsSendLogDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}

	/**
	 * 获取最近一条会员生日短信信息(包含'生日'两字,status = 0的)
	 * @param mobile
	 * @return
	 */
	public SmsSendLog getLastBirthDayContentByMobile(String mobile){
		return super.selectOne("getLastBirthDayContentByMobile",mobile);
	}

	/**
	 * 更新短信发送状态(根据手机号+msgid)
	 * @param params
	 */
	public void updateSmsSendStatusByParmas(Map<String,Object> params){
		 super.update("updateSmsSendStatusByParmas", params);
	}
}