package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.Sku.*;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.es.PsSkuVO;
import com.thebeastshop.scm.po.Sku;
import com.thebeastshop.scm.vo.EditProductSkuInfoVo;

@DaoConfig(table = "t_pcs_sku")
public class SkuDao extends BaseDao<Sku> {
	
	@Autowired
	public SkuDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public Sku byCode(String code){
		return super.selectOne(new WhereBuilder(F_CODE, code));
	}
	
	public Integer getCrossBorderFlagByCodes(List<String> codes){
		return super.selectOne("getCrossBorderFlagByCodes", codes);
	}
	
	/**
	 * 查询es主要数据
	 */
	public List<PsSkuVO> getEsSkuVo(List<String> codes){
		if (CollectionUtils.isEmpty(codes)) {
			return Collections.EMPTY_LIST;
		}
		return super.selectList("getEsSkuVo", codes);
	}
	
	public Date getLastSaleStartDateByCodes(List<String> skuCodes) {
		Date date = super.selectOne("getLastSaleStartDateByCodes", skuCodes);
		return date;
	}
	
	public Map getSaleStartDateAndProductIdBySkuCode(String skuCode) {
		return super.selectOne("getSaleStartDateAndProductIdBySkuCode", skuCode);
	}
	
	public Map getCategoryIdAndCategoryCodeByCodes(List<String> codes) {
		return super.selectOne("getCategoryIdAndCategoryCodeByCodes", codes);
	}
	
	public List<Integer> getProductIdBySkuCodes(List<String> codes) {
		if (CollectionUtils.isEmpty(codes)) {
			return Collections.EMPTY_LIST;
		}
		return super.selectList("getProductIdBySkuCodes", codes);
	}
	
	public List<String> getAllCode(){
		return super.selectFieldList(F_CODE, new WhereBuilder().gt("id", 0));
	}
	
	public BigDecimal getMinSalePrice(List<String> codes){
		return super.selectOne("getMinSalePrice", codes);
	}
	
	public List<Integer> getProductIdsByCodes(List<String> codes){
		return super.selectList("getProductIdsByCodes", codes);
	}
	
	public List<EditProductSkuInfoVo> getEditProductSkuInfoByProdId(Integer productId) {
		return super.selectList("getEditProductSkuInfoByProdId", productId);
	}
	
	/**
	 * 查找没有被绑定过的SKU
	 */
	public List<EditProductSkuInfoVo> findNoUserdByNameOrCode(String value) {
		return super.selectList("findNoUserdByNameOrCode", value);
	}

}