package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.SkuCategoryRelation;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import java.util.List;

/**
 * @author gongjun
 * @since 2016-11-17
 */
@DaoConfig(table = "t_pcs_sku_category_relation")
public class SkuCategoryRelationDao extends BaseDao<SkuCategoryRelation> {
    @Autowired
    public SkuCategoryRelationDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<Integer> getProductIdsByCategoryIds(List<Integer> categoryIds) {
        List<Integer> ids = super.selectList("getProductIdsByCategoryIds", categoryIds);
        return ids;
    }
}
