package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.ClPs;
import com.thebeastshop.scm.po.ClPsWarehouse;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import java.util.List;

import static com.thebeastshop.scm.po.ClPs.F_CHANGE_SOURCE;
import static pers.richard.ormybatis.domain.po.IdPo.F_ID;

/**
 * @author gongjun[dt_flys@hotmail.com]
 * @since 2016-11-20 19:29
 */
@DaoConfig(table = "t_wh_cl_ps")
public class ClPsWarehouseDao extends BaseDao<ClPsWarehouse> {

    @Autowired
    public ClPsWarehouseDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<ClPsWarehouse> limit(int limitSize){
        return super.selectList(new WhereBuilder().orderDesc(F_ID).limit(limitSize));
    }

    public List<ClPsWarehouse> byChangeSource(ClPs.ChangeSource changeSource){
        return super.selectList(new WhereBuilder(F_CHANGE_SOURCE, changeSource.value));
    }

    /**
     * 删除小于或者等于maxId的记录
     * @param maxId
     * @return
     */
    public int deleteMaxId(Integer maxId){
        return super.delete(new WhereBuilder().lte(F_ID, maxId));
    }

    /**
     * 批量删除ID
     * @param ids
     * @return
     */
    public int deleteIds(List<Integer> ids){
        return super.delete(new WhereBuilder().in(F_ID, ids));
    }


}
