/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.cond.PrdcRecipeCond;
import com.thebeastshop.pegasus.service.purchase.dao.PrdcRecipeMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PrdcRecipeMaterialMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipe;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipeMaterial;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipeMaterialExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcRecipeService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeMaterialVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="prdcRecipeService")
public class PrdcRecipeServiceImpl
implements PrdcRecipeService {
    @Autowired
    private PcsSkuService pcsSkuService;
    @Autowired
    private PrdcRecipeMapper prdcRecipeMapper;
    @Autowired
    private PrdcRecipeMaterialMapper prdcRecipeMaterialMapper;

    @Override
    public PrdcRecipeVO findRecipeVOById(Long id) {
        PrdcRecipeCond cond = new PrdcRecipeCond();
        cond.setRecipeId(id);
        cond.setCurrpage(1);
        List<PrdcRecipeVO> prdcRecipeVOList = this.findRecipeVOByCond(cond, true);
        if (CollectionUtils.isEmpty(prdcRecipeVOList)) {
            return null;
        }
        return prdcRecipeVOList.get(0);
    }

    private List<PrdcRecipeMaterialVO> findRecipeMaterialVOByRecipeIds(List<Long> recipeIds) {
        return this.prdcRecipeMaterialMapper.findRecipeMaterialVOByRecipeIds(recipeIds);
    }

    @Override
    public List<PrdcRecipeMaterialVO> findRecipeMaterialVOByRecipeId(Long recipeId) {
        PrdcRecipeMaterialExample example = new PrdcRecipeMaterialExample();
        example.createCriteria().andRecipeIdEqualTo(recipeId);
        List<PrdcRecipeMaterial> prdcRecipeMaterialList = this.prdcRecipeMaterialMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(prdcRecipeMaterialList)) {
            return Collections.emptyList();
        }
        List prdcRecipeMaterialVOList = BeanUtil.buildListFrom(prdcRecipeMaterialList, PrdcRecipeMaterialVO.class);
        for (PrdcRecipeMaterialVO prdcRecipeMaterialVO : prdcRecipeMaterialVOList) {
            PcsSkuVO skuVO = this.pcsSkuService.findByCode(prdcRecipeMaterialVO.getSkuCode());
            if (!EmptyUtil.isNotEmpty((Object)skuVO)) continue;
            prdcRecipeMaterialVO.setSkuName(skuVO.getNameCn() == null ? "" : skuVO.getNameCn());
        }
        return prdcRecipeMaterialVOList;
    }

    @Override
    public List<PrdcRecipeVO> findRecipeVOByCond(PrdcRecipeCond cond, Boolean cascade) {
        List<PrdcRecipeVO> prdcRecipeList = this.prdcRecipeMapper.findRecipeVOByCond(cond);
        if (CollectionUtils.isEmpty(prdcRecipeList)) {
            return Collections.emptyList();
        }
        List<PrdcRecipeVO> prdcRecipeVOList = prdcRecipeList;
        if (cascade.booleanValue()) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (PrdcRecipeVO recipe : prdcRecipeVOList) {
                ids.add(recipe.getId());
            }
            List<PrdcRecipeMaterialVO> recipeMaterialList = this.findRecipeMaterialVOByRecipeIds(ids);
            HashMap<Long, ArrayList<PrdcRecipeMaterialVO>> recipeMap = new HashMap<Long, ArrayList<PrdcRecipeMaterialVO>>();
            for (PrdcRecipeMaterialVO m : recipeMaterialList) {
                ArrayList<PrdcRecipeMaterialVO> tmp = (ArrayList<PrdcRecipeMaterialVO>)recipeMap.get(m.getRecipeId());
                if (NullUtil.isNull((Object)tmp)) {
                    tmp = new ArrayList<PrdcRecipeMaterialVO>();
                    recipeMap.put(m.getRecipeId(), tmp);
                }
                tmp.add(m);
            }
            for (PrdcRecipeVO prdcRecipeVO : prdcRecipeVOList) {
                ArrayList mList = (ArrayList)recipeMap.get(prdcRecipeVO.getId());
                if (NullUtil.isNull((Object)mList)) {
                    mList = new ArrayList();
                }
                prdcRecipeVO.setRecipeMaterialVOList(mList);
            }
        }
        return prdcRecipeVOList;
    }

    @Override
    @Transactional
    public Long create(PrdcRecipeVO vo) {
        PrdcRecipe prdcRecipe = (PrdcRecipe)BeanUtil.buildFrom((Object)vo, PrdcRecipe.class);
        List prdcRecipeMaterialList = BeanUtil.buildListFrom(vo.getRecipeMaterialVOList(), PrdcRecipeMaterial.class);
        this.createRecipe(prdcRecipe);
        this.saveRecipeMaterial(prdcRecipe, prdcRecipeMaterialList);
        return prdcRecipe.getId();
    }

    @Override
    @Transactional
    public Boolean update(PrdcRecipeVO vo) {
        PrdcRecipe prdcRecipe = (PrdcRecipe)BeanUtil.buildFrom((Object)vo, PrdcRecipe.class);
        List prdcRecipeMaterialList = BeanUtil.buildListFrom(vo.getRecipeMaterialVOList(), PrdcRecipeMaterial.class);
        this.updateRecipe(prdcRecipe);
        this.saveRecipeMaterial(prdcRecipe, prdcRecipeMaterialList);
        return true;
    }

    @Override
    public Boolean deleteRecipeMaterial(Long recipeId, Long recipeMaterialId) {
        if (recipeId == null || recipeMaterialId == null) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PrdcRecipeVO prdcRecipeVO = this.findRecipeVOById(recipeId);
        if (prdcRecipeVO == null) {
            throw new PurchaseException("PC0001", "\u5339\u914d\u4e0d\u5230\u914d\u65b9");
        }
        Boolean found = false;
        for (PrdcRecipeMaterialVO prdcRecipeMaterialVO : prdcRecipeVO.getRecipeMaterialVOList()) {
            if (!prdcRecipeMaterialVO.getId().equals(recipeMaterialId)) continue;
            found = true;
        }
        if (found.booleanValue()) {
            if (this.prdcRecipeMaterialMapper.deleteByPrimaryKey(recipeMaterialId) == 0) {
                throw new PurchaseException("PC0011", "\u5220\u9664\u914d\u65b9\u884c\u5931\u8d25");
            }
        } else {
            throw new PurchaseException("PC0001", "\u914d\u65b9\u4e0d\u5305\u542b\u8be5\u884c\u6570\u636e");
        }
        return true;
    }

    private void validateRecipe(Boolean isCreat, PrdcRecipe rcd) {
        PcsSkuVO skuVO;
        PrdcRecipeCond con = new PrdcRecipeCond();
        con.setRecipeSkuCode(rcd.getSkuCode());
        List<PrdcRecipeVO> list = this.prdcRecipeMapper.findRecipeVOByCond(con);
        if (isCreat.booleanValue()) {
            if (rcd.getId() != null) {
                throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
            }
            if (list != null && list.size() > 0) {
                throw new PurchaseException("PC0001", "skuCode\u4e0d\u80fd\u91cd\u590d");
            }
        } else {
            PrdcRecipeVO prdcRecipe;
            if (rcd.getId() == null) {
                throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
            }
            if (list.size() > 1) {
                throw new PurchaseException("PC0001", "skuCode\u4e0d\u80fd\u91cd\u590d");
            }
            if (list.size() == 1 && !(prdcRecipe = list.get(0)).getId().equals(rcd.getId())) {
                throw new PurchaseException("PC0001", "skuCode\u4e0d\u80fd\u91cd\u590d");
            }
        }
        if ((skuVO = this.pcsSkuService.findByCode(rcd.getSkuCode())) == null) {
            throw new PurchaseException("PC0001", "skuCode\u5339\u914d\u4e0d\u5230sku");
        }
    }

    @Transactional
    private void createRecipe(PrdcRecipe rcd) {
        this.validateRecipe(true, rcd);
        rcd.setCreateTime(DateUtil.getNow());
        if (this.prdcRecipeMapper.insert(rcd) == 0) {
            throw new PurchaseException("PC0009", "\u6570\u636e\u5e93\u63d2\u5165\u5931\u8d25");
        }
    }

    @Transactional
    private void updateRecipe(PrdcRecipe rcd) {
        this.validateRecipe(false, rcd);
        if (this.prdcRecipeMapper.updateByPrimaryKeySelective(rcd) == 0) {
            throw new PurchaseException("PC0010", "\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
        }
    }

    private void saveRecipeMaterial(PrdcRecipe prdcRecipe, List<PrdcRecipeMaterial> rcdList) {
        for (PrdcRecipeMaterial rcd : rcdList) {
            if (rcd.getId() == null) {
                this.createRecipeMaterial(prdcRecipe, rcd);
                continue;
            }
            this.updateRecipeMaterial(prdcRecipe, rcd);
        }
    }

    private void validateRecipeMaterial(PrdcRecipe prdcRecipe, PrdcRecipeMaterial rcd) {
        PcsSkuVO skuVO = this.pcsSkuService.findByCode(rcd.getSkuCode());
        if (skuVO == null) {
            throw new PurchaseException("PC0001", "\u8017\u6750skuCode\u5339\u914d\u4e0d\u5230sku");
        }
        if (EmptyUtil.isEmpty((Object)rcd.getQuantity())) {
            throw new PurchaseException("PC0001", "\u8017\u6750sku\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (rcd.getQuantity().compareTo(new Float(0.0f)) <= 0) {
            throw new PurchaseException("PC0001", "\u8017\u6750sku\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (rcd.getSkuCode().equals(prdcRecipe.getSkuCode())) {
            throw new PurchaseException("PC0001", "\u8017\u6750SKU\u5305\u542b\u6210\u54c1SKU");
        }
    }

    @Transactional
    private void createRecipeMaterial(PrdcRecipe prdcRecipe, PrdcRecipeMaterial rcd) {
        this.validateRecipeMaterial(prdcRecipe, rcd);
        rcd.setRecipeId(prdcRecipe.getId());
        if (this.prdcRecipeMaterialMapper.insert(rcd) == 0) {
            throw new PurchaseException("PC0009", "\u6570\u636e\u5e93\u63d2\u5165\u5931\u8d25");
        }
    }

    @Transactional
    private void updateRecipeMaterial(PrdcRecipe prdcRecipe, PrdcRecipeMaterial rcd) {
        this.validateRecipeMaterial(prdcRecipe, rcd);
        if (this.prdcRecipeMaterialMapper.updateByPrimaryKeySelective(rcd) == 0) {
            throw new PurchaseException("PC0010", "\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
        }
    }
}

