/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.cond.PrdcJobCond;
import com.thebeastshop.pegasus.service.purchase.dao.PrdcJobLineMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PrdcJobMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJob;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJobExample;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJobLine;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJobLineExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcJobService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcRecipeService;
import com.thebeastshop.pegasus.service.purchase.util.PrdcJobLineUtil;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcJobLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcJobVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeVO;
import com.thebeastshop.pegasus.service.warehouse.PegasusWarehouseInnerServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.PegasusWarehouseServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.PegasusWmsServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvOccupy;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReleaseOccupationVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPrdcJobTaskVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="prdcJobService")
public class PrdcJobServiceImpl
implements PrdcJobService {
    @Autowired
    private PcsSkuService pcsSkuService;
    @Autowired
    private PrdcRecipeService prdcRecipeService;
    @Autowired
    private PrdcJobMapper prdcJobMapper;
    @Autowired
    private PrdcJobLineMapper prdcJobLineMapper;
    private PegasusWarehouseInnerServiceFacade facadeWi;
    private PegasusWarehouseServiceFacade facadeWs;
    private PegasusWmsServiceFacade facadeWms;

    @PostConstruct
    private void init() {
        this.facadeWi = PegasusWarehouseInnerServiceFacade.getInstance();
        this.facadeWs = PegasusWarehouseServiceFacade.getInstance();
        this.facadeWms = PegasusWmsServiceFacade.getInstance();
    }

    @Override
    public PrdcJobVO findJobVOById(Long id) {
        PrdcJobCond cond = new PrdcJobCond();
        cond.setJobId(id);
        cond.setCurrpage(1);
        List<PrdcJobVO> prdcJobVOList = this.findJobVOByCond(cond, true);
        if (CollectionUtils.isEmpty(prdcJobVOList)) {
            return null;
        }
        return prdcJobVOList.get(0);
    }

    @Override
    public PrdcJobVO findJobVOByCode(String code) {
        PrdcJobExample example = new PrdcJobExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PrdcJob> jobs = this.prdcJobMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(jobs)) {
            return null;
        }
        List jobVOs = BeanUtil.buildListFrom(jobs, PrdcJobVO.class);
        PrdcJobVO jobVO = (PrdcJobVO)jobVOs.get(0);
        jobVO.setPrdcJobLineVOList(this.findJobLineVOByJobId(jobVO.getId()));
        return jobVO;
    }

    @Override
    public List<PrdcJobVO> findJobVOByRecipeId(Long recipeId, Boolean cascade) {
        PrdcJobCond cond = new PrdcJobCond();
        cond.setRecipeId(recipeId);
        cond.setCurrpage(null);
        List<PrdcJobVO> prdcJobVOList = this.findJobVOByCond(cond, cascade);
        if (CollectionUtils.isEmpty(prdcJobVOList)) {
            return Collections.emptyList();
        }
        return prdcJobVOList;
    }

    @Override
    public List<PrdcJobLineVO> findJobLineVOByJobId(Long jobId) {
        PrdcJobLineExample example = new PrdcJobLineExample();
        example.createCriteria().andJobIdEqualTo(jobId);
        List<PrdcJobLine> prdcJobLineList = this.prdcJobLineMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(prdcJobLineList)) {
            return Collections.emptyList();
        }
        List prdcJobLineVOList = BeanUtil.buildListFrom(prdcJobLineList, PrdcJobLineVO.class);
        for (PrdcJobLineVO prdcJobLineVO : prdcJobLineVOList) {
            PcsSkuVO skuVO = this.pcsSkuService.findByCode(prdcJobLineVO.getSkuCode());
            prdcJobLineVO.setSkuName(skuVO.getNameCn());
        }
        return prdcJobLineVOList;
    }

    @Override
    public List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond, Boolean cascade) {
        List<PrdcJob> prdcJobList = this.prdcJobMapper.findJobVOByCond(cond);
        if (CollectionUtils.isEmpty(prdcJobList)) {
            return Collections.emptyList();
        }
        List prdcJobVOList = BeanUtil.buildListFrom(prdcJobList, PrdcJobVO.class);
        Iterator i$ = prdcJobVOList.iterator();
        while (i$.hasNext()) {
            PrdcJobVO prdcJobVO;
            PcsSkuVO skuVO = this.pcsSkuService.findByCode((prdcJobVO = (PrdcJobVO)i$.next()).getSkuCode());
            prdcJobVO.setSkuName(skuVO == null ? "" : skuVO.getNameCn());
            if (!cascade.booleanValue()) continue;
            PrdcRecipeVO prdcRecipeVO = this.prdcRecipeService.findRecipeVOById(prdcJobVO.getRecipeId());
            prdcJobVO.setRecipeName(prdcRecipeVO == null ? "" : prdcRecipeVO.getRecipeName());
            prdcJobVO.setPrdcJobLineVOList(this.findJobLineVOByJobId(prdcJobVO.getId()));
        }
        return prdcJobVOList;
    }

    @Override
    @Transactional
    public Long create(PrdcJobVO vo) {
        vo.setProcessingAmount(0);
        vo.setFinishedDamagedQuantity(0);
        vo.setFinishedQuantity(0);
        PrdcJob prdcJob = (PrdcJob)BeanUtil.buildFrom((Object)vo, PrdcJob.class);
        List prdcJobLineList = BeanUtil.buildListFrom(vo.getPrdcJobLineVOList(), PrdcJobLine.class);
        if (vo.getJobType() == PrdcJobVO.JOB_TYPE_ASSEMBLE) {
            for (PrdcJobLine jobLine : prdcJobLineList) {
                WhInvVO whInvVO = this.facadeWs.findCanUseQttBySkuCodeAndWarehouseCode(jobLine.getSkuCode(), vo.getWarehouseCode());
                if (!(jobLine.getQuantity().floatValue() > (float)whInvVO.getCanUseInv())) continue;
                throw new PurchaseException("", "[" + jobLine.getSkuCode() + "]\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3");
            }
        } else if (vo.getJobType() == PrdcJobVO.JOB_TYPE_SPLIT) {
            WhInvVO whInvVO = this.facadeWs.findCanUseQttBySkuCodeAndWarehouseCode(vo.getSkuCode(), vo.getWarehouseCode());
            if (vo.getEstQuantity() > whInvVO.getCanUseInv()) {
                throw new PurchaseException("", "[" + vo.getSkuCode() + "]\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3");
            }
        }
        this.createJob(prdcJob);
        this.saveJobLine(prdcJob, prdcJobLineList);
        List<WhInvOccupy> whOccupyList = this.buildWhOccupy(prdcJob, prdcJobLineList, vo.getWarehouseCode(), WhInvOccupy.TYPE_PRODUCE_OUT);
        PrdcJobServiceImpl prdcJobServiceImpl = this;
        prdcJobServiceImpl.facadeWi.getInstance().occupy(whOccupyList);
        return prdcJob.getId();
    }

    @Override
    @Transactional
    public List<Long> batchCreate(List<PrdcJobVO> list) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (EmptyUtil.isNotEmpty(list)) {
            for (PrdcJobVO vo : list) {
                ids.add(this.create(vo));
            }
        }
        return ids;
    }

    @Override
    @Transactional
    public Boolean returnModify(PrdcJobVO vo) {
        PrdcJob prdcJob = (PrdcJob)BeanUtil.buildFrom((Object)vo, PrdcJob.class);
        List prdcJobLineList_0 = BeanUtil.buildListFrom(this.findJobLineVOByJobId(vo.getId()), PrdcJobLine.class);
        List<WhReleaseOccupationVO> whReleaseList = this.buildWhRelease(prdcJob, prdcJobLineList_0, WhInvOccupy.TYPE_PRODUCE_OUT);
        List prdcJobLineList = BeanUtil.buildListFrom(vo.getPrdcJobLineVOList(), PrdcJobLine.class);
        this.returnModifyJob(prdcJob);
        this.changeJobLine(prdcJob, prdcJobLineList);
        List<WhInvOccupy> whOccupyList = this.buildWhOccupy(prdcJob, prdcJobLineList, vo.getWarehouseCode(), WhInvOccupy.TYPE_PRODUCE_OUT);
        this.facadeWi.occupyAfterRelease(whOccupyList, whReleaseList);
        return true;
    }

    @Override
    public Boolean deleteJobLine(Long jobId, Long jobLineId) {
        if (jobId == null || jobLineId == null) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PrdcJobVO prdcJobVO = this.findJobVOById(jobId);
        if (prdcJobVO == null) {
            throw new PurchaseException("PC0001", "\u5339\u914d\u4e0d\u5230\u4efb\u52a1");
        }
        Boolean found = false;
        for (PrdcJobLineVO prdcJobLineVO : prdcJobVO.getPrdcJobLineVOList()) {
            if (!prdcJobLineVO.getId().equals(jobLineId)) continue;
            found = true;
        }
        if (found.booleanValue()) {
            if (this.prdcJobLineMapper.deleteByPrimaryKey(jobLineId) == 0) {
                throw new PurchaseException("PC0011", "\u5220\u9664\u4efb\u52a1\u884c\u5931\u8d25");
            }
        } else {
            throw new PurchaseException("PC0001", "\u4efb\u52a1\u4e0d\u5305\u542b\u8be5\u884c\u6570\u636e");
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean cancelJobForStatusReturnModify(Long jobId) {
        if (jobId == null || jobId <= 0L) throw new PurchaseException("PC0001", "the id is invalid");
        PrdcJobVO prdcJobVO = this.findJobVOById(jobId);
        if (prdcJobVO == null) throw new PurchaseException("PC0001", "job is not found ");
        if (!prdcJobVO.getPlanStatus().equals(PrdcJob.PLAN_STATUS_RETURN_MODIFY)) throw new PurchaseException("PC0002", "the status is invalid ");
        PrdcJob update = new PrdcJob();
        update.setId(jobId);
        update.setPlanStatus(PrdcJob.PLAN_STATUS_CANCEL);
        if (this.prdcJobMapper.updateByPrimaryKeySelective(update) != 0) return true;
        throw new PurchaseException("PC0010", "\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    @Transactional
    public Boolean startProduction(PrdcJobVO jobVO) {
        if (jobVO == null) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PrdcJob prdcJob = (PrdcJob)BeanUtil.buildFrom((Object)jobVO, PrdcJob.class);
        int update = this.prdcJobMapper.updateByPrimaryKey(prdcJob);
        if (update <= 0) {
            throw new PurchaseException("PC0010", "\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean releaseJobLineOccupyAndUpdate(PrdcJobVO jobVO, List<WhReleaseOccupationVO> whReleaseOccupationVOList) {
        if (jobVO == null) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PrdcJob prdcJob = (PrdcJob)BeanUtil.buildFrom((Object)jobVO, PrdcJob.class);
        int update = this.prdcJobMapper.updateByPrimaryKey(prdcJob);
        if (update <= 0) {
            throw new PurchaseException("PC0010", "\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
        }
        this.facadeWi.releaseOccupation(whReleaseOccupationVOList);
        return true;
    }

    @Override
    @Transactional
    public Boolean createCommandsAfterReleaseThenFinishAndUpdate(PrdcJobVO jobVO, List<WhCommand> whCommands, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        if (jobVO == null) {
            throw new PurchaseException("PC0001", "param abnormal!");
        }
        if (jobVO.getPlanStatus() == PrdcJob.PLAN_STATUS_FINISHED || jobVO.getPlanStatus() == PrdcJob.WMS_PLAN_STATUS_FINISHED || jobVO.getPlanStatus() == PrdcJob.PLAN_STATUS_CANCEL) {
            throw new PurchaseException("PC0001", "status abnormal!");
        }
        PrdcJob prdcJob = (PrdcJob)BeanUtil.buildFrom((Object)jobVO, PrdcJob.class);
        prdcJob.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_FINISHED);
        prdcJob.setFinishTime(new Date());
        int updateJob = this.prdcJobMapper.updateByPrimaryKey(prdcJob);
        if (updateJob <= 0) {
            throw new PurchaseException("PC0010", "update data failed!");
        }
        for (PrdcJobLine prdcJobLine : jobVO.getPrdcJobLineVOList()) {
            int updateJobLine = this.prdcJobLineMapper.updateByPrimaryKey(prdcJobLine);
            if (updateJobLine > 0) continue;
            throw new PurchaseException("PC0010", "update data failed!");
        }
        List commands = this.facadeWi.createCommandsAfterReleaseThenFinish(whCommands, whReleaseOccupationVOList);
        if (EmptyUtil.isEmpty((List)commands)) {
            throw new PurchaseException("PC0001", "param abnormal!");
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean updateJobVO(PrdcJobVO jobVO) {
        if (jobVO == null) {
            throw new PurchaseException("PC0010", "param abnormal!");
        }
        PrdcJob prdcJob = (PrdcJob)BeanUtil.buildFrom((Object)jobVO, PrdcJob.class);
        int update = this.prdcJobMapper.updateByPrimaryKey(prdcJob);
        if (update <= 0) {
            throw new PurchaseException("PC0010", "update data failed!");
        }
        return true;
    }

    private void validateJob(Boolean isCreat, PrdcJob rcd) {
        if (isCreat != false ? rcd.getId() != null : rcd.getId() == null) {
            throw new PurchaseException("PC0001", "param abnormal");
        }
        PrdcRecipeVO prdcRecipeVO = this.prdcRecipeService.findRecipeVOById(rcd.getRecipeId());
        if (prdcRecipeVO == null) {
            throw new PurchaseException("PC0001", "recipeId\u5339\u914d\u4e0d\u5230\u914d\u65b9");
        }
        if (!prdcRecipeVO.getSkuCode().equals(rcd.getSkuCode())) {
            throw new PurchaseException("PC0001", "\u914d\u65b9\u6210\u54c1skuCode\u4e0e\u4efb\u52a1\u6210\u54c1skuCode\u4e0d\u4e00\u81f4");
        }
        PcsSkuVO skuVO = this.pcsSkuService.findByCode(rcd.getSkuCode());
        if (skuVO == null) {
            throw new PurchaseException("PC0001", "skuCode\u5339\u914d\u4e0d\u5230sku");
        }
    }

    @Transactional
    private void createJob(PrdcJob rcd) {
        this.validateJob(true, rcd);
        rcd.setCode("");
        rcd.setPlanStatus(PrdcJob.WMS_STATUS_RETURN_MODIFY);
        rcd.setCreateTime(DateUtil.getNow());
        if (this.prdcJobMapper.insert(rcd) == 0) {
            throw new PurchaseException("PC0009", "insert data failed!");
        }
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", rcd.getId());
        String code = CodeGenerator.getInstance().generate("PRDC_JOB_CODE", params);
        if (EmptyUtil.isEmpty((String)code)) {
            throw new PurchaseException("PC0006", "\u4efb\u52a1\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
        rcd.setCode(code);
        if (this.prdcJobMapper.updateByPrimaryKey(rcd) == 0) {
            throw new PurchaseException("PC0010", "update data failed!");
        }
    }

    @Transactional
    private void returnModifyJob(PrdcJob rcd) {
        if (rcd.getPlanStatus() != PrdcJob.WMS_STATUS_RETURN_MODIFY) {
            throw new PurchaseException("PC0010", "status abnormal!");
        }
        this.validateJob(false, rcd);
        PrdcJob update = new PrdcJob();
        update.setRecipeId(rcd.getRecipeId());
        update.setId(rcd.getId());
        update.setSkuCode(rcd.getSkuCode());
        update.setWarehouseCode(rcd.getWarehouseCode());
        update.setEstQuantity(rcd.getEstQuantity());
        update.setEstDoneDate(rcd.getEstDoneDate());
        update.setRemark(rcd.getRemark());
        update.setJobType(rcd.getJobType());
        if (this.prdcJobMapper.updateByPrimaryKeySelective(update) == 0) {
            throw new PurchaseException("PC0010", "update data failed!");
        }
    }

    private void saveJobLine(PrdcJob prdcJob, List<PrdcJobLine> rcdList) {
        ArrayList<Integer> nums = new ArrayList<Integer>();
        nums.add(0);
        for (PrdcJobLine line : rcdList) {
            if (line.getCode() == null || line.getCode().equals("")) continue;
            String suffixCode = line.getCode().substring(line.getCode().indexOf(prdcJob.getCode()) + prdcJob.getCode().length());
            nums.add(Integer.valueOf(suffixCode));
        }
        Collections.sort(nums);
        Integer maxNum = (Integer)nums.get(0);
        for (int i = 0; i < rcdList.size(); ++i) {
            PrdcJobLine rcd = rcdList.get(i);
            if (rcd.getId() != null) continue;
            maxNum = maxNum + 1;
            rcd.setCode(PrdcJobLineUtil.getJobLineCode(prdcJob.getCode(), maxNum));
            this.createJobLine(prdcJob, rcd);
        }
    }

    @Transactional
    private void changeJobLine(PrdcJob prdcJob, List<PrdcJobLine> rcdList) {
        ArrayList<Integer> nums = new ArrayList<Integer>();
        PrdcJobLineExample example = new PrdcJobLineExample();
        example.createCriteria().andJobIdEqualTo(prdcJob.getId());
        this.prdcJobLineMapper.deleteByExample(example);
        nums.add(0);
        for (PrdcJobLine line : rcdList) {
            if (line.getCode() == null || line.getCode().equals("")) continue;
            String suffixCode = line.getCode().substring(line.getCode().indexOf(prdcJob.getCode()) + prdcJob.getCode().length());
            nums.add(Integer.valueOf(suffixCode));
        }
        Collections.sort(nums);
        Integer maxNum = (Integer)nums.get(0);
        for (int i = 0; i < rcdList.size(); ++i) {
            PrdcJobLine rcd = rcdList.get(i);
            maxNum = maxNum + 1;
            rcd.setCode(PrdcJobLineUtil.getJobLineCode(prdcJob.getCode(), maxNum));
            this.createJobLine(prdcJob, rcd);
        }
    }

    private void validateJobLine(PrdcJob prdcJob, PrdcJobLine rcd) {
        PcsSkuVO skuVO = this.pcsSkuService.findByCode(rcd.getSkuCode());
        if (skuVO == null) {
            throw new PurchaseException("PC0001", "\u8017\u6750skuCode\u5339\u914d\u4e0d\u5230sku");
        }
        if (rcd.getQuantity().compareTo(new Float(0.0f)) <= 0) {
            throw new PurchaseException("PC0001", "\u8017\u6750sku\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (rcd.getSkuCode().equals(prdcJob.getSkuCode())) {
            throw new PurchaseException("PC0001", "\u8017\u6750SKU\u5305\u542b\u6210\u54c1SKU");
        }
    }

    @Transactional
    private void createJobLine(PrdcJob prdcJob, PrdcJobLine rcd) {
        this.validateJobLine(prdcJob, rcd);
        rcd.setJobId(prdcJob.getId());
        if (this.prdcJobLineMapper.insert(rcd) == 0) {
            throw new PurchaseException("PC0009", "insert data failed!");
        }
    }

    @Override
    public List<WhCommand> buildPrdcCommands(PrdcJobVO jobVO) {
        if (CollectionUtils.isEmpty(jobVO.getPrdcJobLineVOList())) {
            throw new PurchaseException("PC0001", "\u6784\u9020\u91ca\u653e\u5e93\u5b58\u5931\u8d25,prdcJobLineVOList");
        }
        ArrayList<WhCommand> whCommandList = new ArrayList<WhCommand>();
        WhCommand whCommandJob = new WhCommand();
        whCommandJob.setWarehouseCode(jobVO.getWarehouseCode());
        whCommandJob.setReferenceCode(jobVO.getCode());
        if (jobVO.getJobType() == PrdcJob.JOB_TYPE_ASSEMBLE) {
            whCommandJob.setInOutType(WhCommand.TYPE_PRODUCE_IN);
        } else if (jobVO.getJobType() == PrdcJob.JOB_TYPE_SPLIT) {
            whCommandJob.setInOutType(WhCommand.TYPE_PRODUCE_OUT);
        }
        ArrayList<WhCommandSku> jobSkuList = new ArrayList<WhCommandSku>();
        WhCommandSku jobSku = new WhCommandSku();
        jobSku.setSkuCode(jobVO.getSkuCode());
        jobSku.setPlanedQuantity(jobVO.getEstQuantity());
        jobSku.setQuantity(jobVO.getFinishedQuantity());
        jobSku.setDamagedQuantity(jobVO.getFinishedDamagedQuantity());
        jobSkuList.add(jobSku);
        whCommandJob.setWhCommandSkuList(jobSkuList);
        whCommandList.add(whCommandJob);
        for (PrdcJobLineVO jobLineVO : jobVO.getPrdcJobLineVOList()) {
            WhCommand whCommandJobLine = new WhCommand();
            ArrayList<WhCommandSku> jobLineSkuList = new ArrayList<WhCommandSku>();
            whCommandJobLine.setWarehouseCode(jobVO.getWarehouseCode());
            whCommandJobLine.setReferenceCode(jobLineVO.getCode());
            if (jobVO.getJobType() == PrdcJob.JOB_TYPE_ASSEMBLE) {
                whCommandJobLine.setInOutType(WhCommand.TYPE_PRODUCE_OUT);
            } else if (jobVO.getJobType() == PrdcJob.JOB_TYPE_SPLIT) {
                if (jobLineVO.getMaterialType() == PrdcJobLineVO.MATERIAL_TYPE_AUXILIARY) continue;
                whCommandJobLine.setInOutType(WhCommand.TYPE_PRODUCE_IN);
            }
            if (jobLineVO.getQuantity().compareTo(new Float(0.0f)) <= 0) {
                throw new PurchaseException("PC0001", "\u6784\u9020\u4ed3\u5e93\u6307\u4ee4\u5931\u8d25,\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            }
            WhCommandSku jobLineSku = new WhCommandSku();
            jobLineSku.setSkuCode(jobLineVO.getSkuCode());
            jobLineSku.setPlanedQuantity(Integer.valueOf(jobLineVO.getQuantity().intValue()));
            jobLineSku.setQuantity(Integer.valueOf(jobLineVO.getRealQuantity().intValue()));
            jobLineSku.setDamagedQuantity(Integer.valueOf(jobLineVO.getDamageQuantity().intValue()));
            jobLineSkuList.add(jobLineSku);
            whCommandJobLine.setWhCommandSkuList(jobLineSkuList);
            whCommandList.add(whCommandJobLine);
        }
        return whCommandList;
    }

    @Override
    public List<WhReleaseOccupationVO> buildWhRelease(PrdcJob prdcJob, List<PrdcJobLine> prdcJobLineList, Integer occupyType) {
        ArrayList<WhReleaseOccupationVO> releaseList = new ArrayList<WhReleaseOccupationVO>();
        if (CollectionUtils.isEmpty(prdcJobLineList)) {
            throw new PurchaseException("PC0001", "\u6784\u9020\u91ca\u653e\u5e93\u5b58\u7684LIST\u5931\u8d25,opSoPackageSkuList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PrdcJobVO prdcJob_0 = this.findJobVOById(prdcJob.getId());
        if (prdcJob_0.getJobType() == PrdcJob.JOB_TYPE_ASSEMBLE) {
            for (PrdcJobLine rdcJobLine : prdcJobLineList) {
                if (rdcJobLine.getQuantity().compareTo(new Float(0.0f)) <= 0) {
                    throw new PurchaseException("PC0001", "\u6784\u9020\u91ca\u653e\u5e93\u5b58\u7684LIST\u5931\u8d25,\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
                }
                WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
                whReleaseOccupationVO.setOccupyType(occupyType);
                whReleaseOccupationVO.setReferenceCode(rdcJobLine.getCode());
                releaseList.add(whReleaseOccupationVO);
            }
        } else if (prdcJob_0.getJobType() == PrdcJob.JOB_TYPE_SPLIT) {
            WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
            whReleaseOccupationVO.setOccupyType(occupyType);
            whReleaseOccupationVO.setReferenceCode(prdcJob_0.getCode());
            releaseList.add(whReleaseOccupationVO);
        } else {
            throw new PurchaseException("PC0001", "error,type abnormal!");
        }
        return releaseList;
    }

    @Override
    public List<WhInvOccupy> buildWhOccupy(PrdcJob prdcJob, List<PrdcJobLine> prdcJobLineList, String warehouseCode, Integer occupyType) {
        ArrayList<WhInvOccupy> occupyList = new ArrayList<WhInvOccupy>();
        if (CollectionUtils.isEmpty(prdcJobLineList)) {
            throw new PurchaseException("PC0001", "param list cannot be null");
        }
        if (prdcJob.getJobType() == PrdcJob.JOB_TYPE_ASSEMBLE) {
            for (PrdcJobLine prdcJobLine : prdcJobLineList) {
                if (NumberUtil.isNullOrZero((Number)prdcJobLine.getQuantity())) {
                    throw new PurchaseException("PC0001", "the quantity cannot be 0 or null");
                }
                WhInvOccupy whInvOccupy = new WhInvOccupy();
                whInvOccupy.setWarehouseCode(warehouseCode);
                whInvOccupy.setOccupyType(occupyType);
                whInvOccupy.setReferenceCode(prdcJobLine.getCode());
                whInvOccupy.setSkuCode(prdcJobLine.getSkuCode());
                whInvOccupy.setQuantity(Integer.valueOf(prdcJobLine.getQuantity().intValue()));
                occupyList.add(whInvOccupy);
            }
        } else if (prdcJob.getJobType() == PrdcJob.JOB_TYPE_SPLIT) {
            if (NumberUtil.isNullOrZero((Number)prdcJob.getEstQuantity())) {
                throw new PurchaseException("PC0001", "the quantity cannot be 0 or null!");
            }
            WhInvOccupy whInvOccupy = new WhInvOccupy();
            whInvOccupy.setWarehouseCode(warehouseCode);
            whInvOccupy.setOccupyType(occupyType);
            whInvOccupy.setReferenceCode(prdcJob.getCode());
            whInvOccupy.setSkuCode(prdcJob.getSkuCode());
            whInvOccupy.setQuantity(prdcJob.getEstQuantity());
            occupyList.add(whInvOccupy);
        } else {
            throw new PurchaseException("PC0001", "error,status abnormal!");
        }
        return occupyList;
    }

    @Override
    public List<Map<String, String>> getWarehouseList(List<String> warehouseCodeList) {
        ArrayList<Map<String, String>> warehouseNameList = new ArrayList<Map<String, String>>();
        for (String warehouseCode : warehouseCodeList) {
            HashMap<String, String> option = new HashMap<String, String>();
            option.put("code", warehouseCode);
            option.put("name", this.getWarehouseName(warehouseCode));
            warehouseNameList.add(option);
        }
        return warehouseNameList;
    }

    @Override
    public String getWarehouseName(String warehouseCode) {
        WhWarehouse wh;
        String name = "";
        if (NullUtil.isNotNull((Object)warehouseCode) && NullUtil.isNotNull((Object)(wh = this.facadeWs.findWarehouseByCode(warehouseCode))) && EmptyUtil.isNotEmpty((String)wh.getName())) {
            name = wh.getName();
        }
        return name;
    }

    @Override
    public int getPrdcJobMaxTask(WhWmsPrdcJobTaskVO vo) {
        return this.facadeWms.getPrdcJobMaxTask(vo);
    }

    @Override
    public boolean updatePrdcJobWhenTaskFinish(WhWmsPrdcJobTaskVO vo) {
        List<PrdcJob> prdcJobs;
        ArrayList<String> prdcJobCodes = new ArrayList<String>();
        if (vo != null) {
            prdcJobCodes.add(vo.getPrdcJobCode());
        }
        if ((prdcJobs = this.prdcJobMapper.getPrdcJobProcessingOrPartFinished(prdcJobCodes)) != null && !prdcJobs.isEmpty()) {
            prdcJobCodes.clear();
            for (PrdcJob job : prdcJobs) {
                prdcJobCodes.add(job.getCode());
            }
            List wmsPrdcJobTaskInfos = this.facadeWms.getWmsPrdcJobTaskFinishedInfo(prdcJobCodes);
            List wmsPrdcJobTaskProcesInfos = this.facadeWms.getWmsPrdcJobTaskProcessingInfo(prdcJobCodes);
            List wmsPrdcJobTaskFinishedRealAmount = this.facadeWms.getWmsPrdcJobTaskFinishedRealAmount(prdcJobCodes);
            if (wmsPrdcJobTaskInfos != null && !wmsPrdcJobTaskInfos.isEmpty()) {
                for (PrdcJob job : prdcJobs) {
                    Integer finishedDefectiveAmount;
                    Integer finishedGoodsAmount;
                    PrdcJob update;
                    Map<String, Object> info = this.getTaskInfoByPrdcJobCode(wmsPrdcJobTaskInfos, job.getCode());
                    Map<String, Object> processingInfo = this.getTaskInfoByPrdcJobCode(wmsPrdcJobTaskProcesInfos, job.getCode());
                    List<Map<String, Object>> jobLineRealAmounts = this.getJobInfoByPrdcJobCode(wmsPrdcJobTaskFinishedRealAmount, job.getCode());
                    if (info != null && processingInfo == null) {
                        update = new PrdcJob();
                        update.setId(job.getId());
                        if (PrdcJob.JOB_TYPE_ASSEMBLE.equals(job.getJobType())) {
                            finishedGoodsAmount = this.object2Int(info.get("finishedGoodsAmount"));
                            finishedDefectiveAmount = this.object2Int(info.get("finishedDefectiveAmount"));
                            Integer amount = this.object2Int(info.get("amount"));
                            if (job.getEstQuantity().compareTo(amount) == 0) {
                                update.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_FINISHED);
                                update.setFinishTime(DateUtil.getNow());
                            } else if (job.getEstQuantity().compareTo(amount) > 0 && amount > 0) {
                                update.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_PARTFINISHED);
                            } else {
                                update.setPlanStatus(PrdcJob.WMS_STATUS_RETURN_MODIFY);
                            }
                            update.setFinishedQuantity(finishedGoodsAmount);
                            update.setFinishedDamagedQuantity(finishedDefectiveAmount);
                            update.setProcessingAmount(0);
                        } else {
                            Integer amount = this.object2Int(info.get("amount"));
                            if (job.getEstQuantity().compareTo(amount) == 0) {
                                update.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_FINISHED);
                                update.setFinishTime(DateUtil.getNow());
                            } else if (job.getEstQuantity().compareTo(amount) > 0 && amount > 0) {
                                update.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_PARTFINISHED);
                            } else {
                                update.setPlanStatus(PrdcJob.WMS_STATUS_RETURN_MODIFY);
                            }
                            update.setFinishedQuantity(amount);
                            update.setProcessingAmount(0);
                        }
                        this.updatePrdcJobCheckCancle(update);
                        for (Map<String, Object> realInfo : jobLineRealAmounts) {
                            PrdcJobLine prdcJobLine = this.makePrdcJobLine(realInfo, update);
                            if (prdcJobLine == null) continue;
                            this.prdcJobLineMapper.updateByExampleSelective(prdcJobLine, this.makePrdcJobLineExample(prdcJobLine));
                        }
                        continue;
                    }
                    if (info == null || processingInfo == null) continue;
                    update = new PrdcJob();
                    update.setId(job.getId());
                    update.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_PROCESSING);
                    if (PrdcJob.JOB_TYPE_ASSEMBLE.equals(job.getJobType())) {
                        finishedGoodsAmount = this.object2Int(info.get("finishedGoodsAmount"));
                        finishedDefectiveAmount = this.object2Int(info.get("finishedDefectiveAmount"));
                        update.setFinishedQuantity(finishedGoodsAmount);
                        update.setFinishedDamagedQuantity(finishedDefectiveAmount);
                    } else {
                        finishedGoodsAmount = this.object2Int(info.get("finishedGoodsAmount"));
                        update.setFinishedQuantity(finishedGoodsAmount);
                    }
                    Integer processingAmount = this.object2Int(processingInfo.get("amount"));
                    update.setProcessingAmount(processingAmount);
                    this.updatePrdcJobCheckCancle(update);
                }
            }
        }
        return true;
    }

    private void updatePrdcJobCheckCancle(PrdcJob update) {
        PrdcJobExample example = new PrdcJobExample();
        example.createCriteria().andIdEqualTo(update.getId()).andPlanStatusNotEqualTo(PrdcJob.PLAN_STATUS_CANCEL);
        int size = this.prdcJobMapper.updateByExampleSelective(update, example);
        if (size == 0) {
            update.setPlanStatus(null);
            this.prdcJobMapper.updateByPrimaryKeySelective(update);
        }
    }

    private PrdcJobLineExample makePrdcJobLineExample(PrdcJobLine prdcJobLine) {
        if (prdcJobLine == null) {
            return null;
        }
        PrdcJobLineExample exam = new PrdcJobLineExample();
        PrdcJobLineExample.Criteria crit = exam.createCriteria();
        crit.andSkuCodeEqualTo(prdcJobLine.getSkuCode());
        crit.andJobIdEqualTo(prdcJobLine.getJobId());
        return exam;
    }

    private PrdcJobLine makePrdcJobLine(Map<String, Object> jobLineRealAmount, PrdcJob update) {
        if (jobLineRealAmount == null) {
            return null;
        }
        PrdcJobLine prdcJobLine = new PrdcJobLine();
        prdcJobLine.setJobId(update.getId());
        prdcJobLine.setSkuCode(String.valueOf(jobLineRealAmount.get("skuCode")));
        prdcJobLine.setRealQuantity(Float.valueOf(String.valueOf(jobLineRealAmount.get("realAmount"))));
        return prdcJobLine;
    }

    private Integer object2Int(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return Integer.parseInt(obj.toString());
    }

    private Map<String, Object> getTaskInfoByPrdcJobCode(List<Map<String, Object>> infos, String prdcJobCode) {
        if (infos != null && !infos.isEmpty()) {
            for (Map<String, Object> info : infos) {
                Object code = info.get("prdcJobCode");
                if (!prdcJobCode.equals(code)) continue;
                return info;
            }
        }
        return null;
    }

    private List<Map<String, Object>> getJobInfoByPrdcJobCode(List<Map<String, Object>> jobFinishedRealAmount, String prdcJobCode) {
        ArrayList<Map<String, Object>> map = new ArrayList<Map<String, Object>>();
        if (jobFinishedRealAmount != null && !jobFinishedRealAmount.isEmpty()) {
            for (Map<String, Object> info : jobFinishedRealAmount) {
                Object code = info.get("prdcJobCode");
                if (!prdcJobCode.equals(code)) continue;
                map.add(info);
            }
            return map;
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> getWmsPrdcJobTaskFinishedInfo(List<String> prdcJobCodes) {
        return this.facadeWms.getWmsPrdcJobTaskFinishedInfo(prdcJobCodes);
    }

    @Override
    public List<PrdcJob> getPrdcJobProcessingOrPartFinished(List<String> codes) {
        return this.prdcJobMapper.getPrdcJobProcessingOrPartFinished(codes);
    }

    @Override
    public List<WhReleaseOccupationVO> buildWhRelease(List<PrdcJobLineVO> prdcJobLineVOList, Integer occupyType) {
        ArrayList<WhReleaseOccupationVO> releaseList = new ArrayList<WhReleaseOccupationVO>();
        if (CollectionUtils.isEmpty(prdcJobLineVOList)) {
            throw new PurchaseException("PC0001", "\u6784\u9020\u91ca\u653e\u5e93\u5b58\u7684LIST\u5931\u8d25,opSoPackageSkuList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (PrdcJobLineVO rdcJobLineVO : prdcJobLineVOList) {
            if (rdcJobLineVO.getQuantity().compareTo(Float.valueOf(0.0f)) <= 0) {
                throw new PurchaseException("PC0001", "\u6784\u9020\u91ca\u653e\u5e93\u5b58\u7684LIST\u5931\u8d25,\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            }
            WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
            whReleaseOccupationVO.setOccupyType(occupyType);
            whReleaseOccupationVO.setReferenceCode(rdcJobLineVO.getCode());
            releaseList.add(whReleaseOccupationVO);
        }
        return releaseList;
    }

    @Override
    public List<WhInvOccupy> buildWhOccupy(List<PrdcJobLineVO> prdcJobLineVOList, String warehouseCode, Integer occupyType) {
        ArrayList<WhInvOccupy> occupyList = new ArrayList<WhInvOccupy>();
        if (CollectionUtils.isEmpty(prdcJobLineVOList)) {
            throw new PurchaseException("PC0001", "\u6784\u9020\u5360\u7528\u5e93\u5b58\u7684LIST\u5931\u8d25,opSoPackageSkuList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (PrdcJobLineVO prdcJobLineVO : prdcJobLineVOList) {
            if (prdcJobLineVO.getQuantity().compareTo(Float.valueOf(0.0f)) <= 0) {
                throw new PurchaseException("PC0001", "\u6784\u9020\u5360\u7528\u5e93\u5b58\u7684LIST\u5931\u8d25,\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            }
            WhInvOccupy whInvOccupy = new WhInvOccupy();
            whInvOccupy.setWarehouseCode(warehouseCode);
            whInvOccupy.setOccupyType(occupyType);
            whInvOccupy.setReferenceCode(prdcJobLineVO.getCode());
            whInvOccupy.setSkuCode(prdcJobLineVO.getSkuCode());
            whInvOccupy.setQuantity(Integer.valueOf(Double.valueOf(Math.ceil(prdcJobLineVO.getQuantity().floatValue())).intValue()));
            occupyList.add(whInvOccupy);
        }
        return occupyList;
    }

    @Override
    @Transactional
    public Boolean checkOccupyAndUpdate(PrdcJobVO jobVO, List<WhInvOccupy> whInvOccupyList) {
        if (jobVO == null) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PrdcJob prdcJob = (PrdcJob)BeanUtil.buildFrom((Object)jobVO, PrdcJob.class);
        int update = this.prdcJobMapper.updateByPrimaryKey(prdcJob);
        if (update <= 0) {
            throw new PurchaseException("PC0010", "\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
        }
        PrdcJobServiceImpl prdcJobServiceImpl = this;
        prdcJobServiceImpl.facadeWi.getInstance().occupy(whInvOccupyList);
        return true;
    }

    @Override
    public List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond) {
        return this.prdcJobMapper.findExportJobVOByCond(cond);
    }

    @Override
    public List<PrdcJob> findSkuReportJobVO() {
        return this.prdcJobMapper.findSkuReportJobVO();
    }
}

