/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.cond.PcsTagCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsTagMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuTag;
import com.thebeastshop.pegasus.service.purchase.model.ProdTag;
import com.thebeastshop.pegasus.service.purchase.service.PcsClPsService;
import com.thebeastshop.pegasus.service.purchase.service.PcsTagService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsTagVO;
import com.thebeastshop.pegasus.service.purchase.vo.ProdSkuVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsTagService")
public class PcsTagServiceImpl
implements PcsTagService {
    private static final Logger log = LoggerFactory.getLogger(PcsTagServiceImpl.class);
    @Autowired
    private PcsTagMapper pcsTagMapper;
    @Autowired
    private PcsClPsService pcsClPsService;

    @Override
    @Transactional
    public int addTag(PcsTagVO tagVO) {
        int ret = this.pcsTagMapper.insert(tagVO);
        if (ret > 0) {
            Random random = new Random();
            int n = random.nextInt(99);
            tagVO.setCode("T0" + n + tagVO.getId());
            this.pcsTagMapper.update(tagVO);
        }
        return ret;
    }

    @Override
    @Transactional
    public int updateTag(PcsTagVO tagVO) {
        int ret = this.pcsTagMapper.update(tagVO);
        List<String> codeList = this.pcsTagMapper.querySkuCodeListByTagId(tagVO.getId());
        this.pcsClPsService.saveSkuCodeList(codeList, 1);
        return ret;
    }

    @Override
    public PcsTagVO findTagById(Long id) {
        return this.pcsTagMapper.findById(id);
    }

    @Override
    public List<ProdSkuVO> queryProdTagListByTagCode(PcsTagCond cond) {
        return this.pcsTagMapper.queryProdTagListByTagCode(cond);
    }

    @Override
    @Transactional
    public int saveOrUpdateProdTag(ProdTag prodTag) {
        int count = this.pcsTagMapper.countOfProdTag(prodTag);
        if (count == 0) {
            count = this.pcsTagMapper.insertProdTag(prodTag);
            log.info("\u65b0\u589e" + count);
            log.info("add record:" + prodTag.toString());
            return 1;
        }
        prodTag.setActive(1);
        count = this.pcsTagMapper.updateProdTag(prodTag);
        log.info("\u66f4\u65b0\uff1a" + count);
        log.info("update record:" + prodTag.toString());
        return 2;
    }

    @Override
    @Transactional
    public int updateProdTagByCodeList(ProdSkuVO prod, List<String> codeList, boolean isEmptyBeforeUpdate) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (isEmptyBeforeUpdate) {
            params.put("productId", prod.getProdId());
            List<ProdTag> toDelProdTagList = this.pcsTagMapper.queryToDeleteProdTagList(params);
            if (!toDelProdTagList.isEmpty()) {
                ArrayList<Long> toDelIdList = new ArrayList<Long>();
                for (int i = 0; i < toDelProdTagList.size(); ++i) {
                    ProdTag toDelProdTag = toDelProdTagList.get(i);
                    toDelIdList.add(toDelProdTag.getId());
                }
                HashMap<String, Object> delParams = new HashMap<String, Object>();
                delParams.put("ids", toDelIdList);
                delParams.put("active", 0);
                int count = this.pcsTagMapper.updateProdTagActiveByIds(delParams);
                log.info("\u5220\u9664\u91cf\uff1a" + count);
            }
        }
        ArrayList<ProdTag> prodTagList = new ArrayList<ProdTag>();
        for (int i = 0; i < codeList.size(); ++i) {
            String code = codeList.get(i);
            ProdTag prodTag = new ProdTag();
            prodTag.setProductCode(prod.getProdCode());
            prodTag.setProductId(prod.getProdId());
            prodTag.setTagCode(code);
            prodTagList.add(prodTag);
        }
        int ret = 0;
        for (int i = 0; i < prodTagList.size(); ++i) {
            ProdTag prodTag = (ProdTag)prodTagList.get(i);
            prodTag.setSort(i);
            ret += this.saveOrUpdateProdTag(prodTag);
        }
        return ret;
    }

    @Override
    public List<PcsTagVO> queryTagList(Map<String, Object> params) {
        return this.pcsTagMapper.queryTagList(params);
    }

    @Override
    public List<ProdSkuVO> queryProdSkuListByTagParams(List<String> idList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", idList);
        return this.pcsTagMapper.queryProdSkuListByTagParams(params);
    }

    @Override
    public int saveOrUpdateSkuTag(PcsSkuTag skuTag) {
        return 0;
    }

    @Override
    public int deleteProdTagByIds(List<String> idList) {
        HashMap<String, Object> delParams = new HashMap<String, Object>();
        delParams.put("ids", idList);
        delParams.put("active", 0);
        return this.pcsTagMapper.updateProdTagActiveByIds(delParams);
    }
}

