/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.integration.sms.SmsUtil;
import com.thebeastshop.pegasus.integration.sms.SmsVO;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSupplierCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSupplierMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PcsSupplier;
import com.thebeastshop.pegasus.service.purchase.model.PcsSupplierExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsBuyerInfoService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSupplierService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSupplierVO;
import com.thebeastshop.pegasus.service.purchase.vo.UserInfo;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.model.CommCurrency;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsSupplierService")
public class PcsSupplierServiceImpl
implements PcsSupplierService,
CheckAble {
    private final Logger log = LoggerFactory.getLogger(PcsSupplierServiceImpl.class);
    @Autowired
    private PcsSupplierMapper pcsSupplierMapper;
    @Autowired
    private PcsBuyerInfoService pcsBuyerInfoService;

    @Override
    public PcsSupplier buildFromVO(PcsSupplierVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsSupplier record = new PcsSupplier();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    public PcsSupplierVO buildFromModel(PcsSupplier record) {
        if (NullUtil.isNull((Object)record)) {
            return null;
        }
        PcsSupplierVO vo = new PcsSupplierVO();
        BeanUtils.copyProperties((Object)record, (Object)vo);
        return vo;
    }

    @Override
    @Transactional
    public Long create(PcsSupplier record, boolean saveDraft) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            record.setCreateTime(new Date());
            this.pcsSupplierMapper.insertSelective(record);
            if (!saveDraft) {
                // empty if block
            }
            return record.getId();
        }
        return null;
    }

    @Override
    @Transactional
    public Boolean update(PcsSupplier record, boolean saveDraft) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            return this.pcsSupplierMapper.updateByPrimaryKeySelective(record) != 0;
        }
        return false;
    }

    private void sendNotice(String code, UserInfo userInfo) {
        SmsUtil smsUtil = SmsUtil.getInstance();
        SmsVO smsVO = new SmsVO();
        smsVO.setSendTime(new Date());
        CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("finance.Approval.Mobile");
        String[] toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        if (userInfo != null) {
            String[] categoryManager = new String[]{userInfo.getMobile()};
            smsVO.setMobileList(Arrays.asList(categoryManager));
        } else {
            smsVO.setMobileList(Arrays.asList(toNotifyUsers));
        }
        smsVO.setContent("\u60a8\u597d\uff0c\u60a8\u6709\u65b0\u7684\u4f9b\u5e94\u5546\u9700\u8981\u5ba1\u6279\uff0c\u4f9b\u5e94\u5546\uff1a" + code + "\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\uff0c\u8c22\u8c22\uff01");
        smsUtil.send(smsVO);
        commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("finance.Approval.Email");
        toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        EmailVO emailVO = new EmailVO();
        if (userInfo != null) {
            String[] categoryManager = new String[]{userInfo.getEmail()};
            emailVO.setToAddressList(Arrays.asList(categoryManager));
        } else {
            emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
        }
        emailVO.setSubject("\u4f9b\u5e94\u5546\u5ba1\u6279");
        emailVO.setContent("\u60a8\u597d\uff0c\u60a8\u6709\u65b0\u7684\u4f9b\u5e94\u5546\u9700\u8981\u5ba1\u6279\uff0c\u4f9b\u5e94\u5546\uff1a" + code + "\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\uff0c\u8c22\u8c22\uff01");
        if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList())) {
            EmailUtil.getInstance().send(emailVO);
        }
    }

    @Override
    public PcsSupplier findById(Long id) {
        if (EmptyUtil.isEmpty((Object)id)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return this.pcsSupplierMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsSupplierVO> findByCond(PcsSupplierCond cond) {
        List<PcsSupplierVO> recordList = this.pcsSupplierMapper.findByCond(cond);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSupplier> findByCriteria(PcsSupplierCond cond) {
        PcsSupplierExample example = new PcsSupplierExample();
        List<PcsSupplier> recordList = this.pcsSupplierMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSupplier> findByName(String name) {
        PcsSupplierExample example = new PcsSupplierExample();
        example.createCriteria().andNameCnLike(SQLUtils.allLike((String)name));
        example.or().andNameLike(SQLUtils.allLike((String)name));
        example.setOrderByClause("ID LIMIT 20 ");
        List<PcsSupplier> recordList = this.pcsSupplierMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSupplier> findByIds(List<Long> ids) {
        ArrayList<PcsSupplier> recordList = new ArrayList<PcsSupplier>();
        for (long id : ids) {
            PcsSupplier record = this.findById(id);
            if (!EmptyUtil.isNotEmpty((Object)record) || !EmptyUtil.isNotEmpty((Object)record.getId())) continue;
            recordList.add(record);
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    public Boolean check(Object obj) {
        PcsSupplier record = (PcsSupplier)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        Boolean currencyFlag = false;
        List allCurrency = PegasusUtilFacade.getInstance().findAllCurrency();
        for (CommCurrency c : allCurrency) {
            if (!c.getCode().equals(record.getPurchaseCurrencyCode())) continue;
            record.setPurchaseCurrencyDesc(c.getDescInfo());
            currencyFlag = true;
            break;
        }
        if (!currencyFlag.booleanValue()) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(PcsSupplier record, Boolean isCreate) {
        PcsSupplier oldRecord;
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PcsSupplierExample example1 = new PcsSupplierExample();
        PcsSupplierExample example2 = new PcsSupplierExample();
        example1.createCriteria().andNameEqualTo(record.getName());
        example2.createCriteria().andNameCnEqualTo(record.getNameCn());
        List<PcsSupplier> oldList = null;
        oldList = this.pcsSupplierMapper.selectByExample(example1);
        if (oldList.size() > 0 && isCreate.booleanValue()) {
            throw new PurchaseException("PC0005", "name\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        if (oldList.size() > 0 && !isCreate.booleanValue() && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException("PC0005", "name\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        oldList = this.pcsSupplierMapper.selectByExample(example2);
        if (oldList.size() > 0 && isCreate.booleanValue()) {
            throw new PurchaseException("PC0005", "nameCn\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        if (oldList.size() > 0 && !isCreate.booleanValue() && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException("PC0005", "nameCn\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        if (!isCreate.booleanValue() && NullUtil.isNotNull((Object)(oldRecord = this.pcsSupplierMapper.selectByPrimaryKey(record.getId()))) && EmptyUtil.isNotEmpty((Object)oldRecord.getFileId()) && EmptyUtil.isNotEmpty((Object)record.getFileId()) && !oldRecord.getFileId().equals(record.getFileId())) {
            PegasusUtilFacade.getInstance().deleteFileById((long)oldRecord.getFileId().intValue());
        }
        return true;
    }

    @Override
    public Boolean audiSupplier(Long userId, long id, Boolean isPass, Integer type) {
        PcsSupplier record = this.pcsSupplierMapper.selectByPrimaryKey(id);
        record.setLastModifier(userId);
        if (isPass.booleanValue()) {
            if (type == 1) {
                record.setSupplierOrderStatus(3);
            } else {
                record.setSupplierOrderStatus(2);
                String code = record.getName();
            }
        } else {
            record.setSupplierOrderStatus(-1);
        }
        return this.pcsSupplierMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    public long countByCond(PcsSupplierCond cond) {
        return this.pcsSupplierMapper.countByCond(cond);
    }
}

