/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.integration.sms.SmsUtil;
import com.thebeastshop.pegasus.integration.sms.SmsVO;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuBarcodeMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuDistributeChannelMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PcsBrand;
import com.thebeastshop.pegasus.service.purchase.model.PcsSku;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuBarcode;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCategory;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCostPriceChange;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCustomMade;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuDistributeChannel;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuDistributeChannelExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSalesPriceChange;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSupplierChange;
import com.thebeastshop.pegasus.service.purchase.service.PcsBrandService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCategoryService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCustomMadeService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuSalesPriceChangeService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuService;
import com.thebeastshop.pegasus.service.purchase.service.PcsTagService;
import com.thebeastshop.pegasus.service.purchase.service.PcsWatermarkService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuBarcodeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuInfoVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuSalesPriceChangeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsSkuService")
public class PcsSkuServiceImpl
implements PcsSkuService,
CheckAble,
CodeAble {
    private final Logger log = LoggerFactory.getLogger(PcsSkuServiceImpl.class);
    @Autowired
    private PcsWatermarkService pcsWatermarkService;
    @Autowired
    private PcsTagService pcsTagService;
    @Autowired
    private PcsSkuMapper pcsSkuMapper;
    @Autowired
    private PcsSkuCategoryService pcsSkuCategoryService;
    @Autowired
    private PcsSkuSalesPriceChangeService pcsSkuSalesPriceChangeService;
    @Autowired
    private PcsSkuCustomMadeService pcsSkuCustomMadeService;
    @Autowired
    private PcsBrandService pcsBrandService;
    @Autowired
    private PcsSkuDistributeChannelMapper pcsSkuDistributeChannelMapper;
    @Autowired
    private PcsSkuBarcodeMapper pcsSkuBarcodeMapper;

    @Override
    public PcsSkuVO buildFromModel(PcsSku record) {
        if (NullUtil.isNull((Object)record)) {
            return null;
        }
        PcsSkuVO vo = new PcsSkuVO();
        BeanUtils.copyProperties((Object)record, (Object)vo);
        return vo;
    }

    @Override
    public PcsSku bulidFromVO(PcsSkuVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsSku record = new PcsSku();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    @Transactional
    public Long create(PcsSku record) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            this.initDefaultValue(record);
            this.pcsSkuMapper.insertSelective(record);
            try {
                String code = this.generateSkuCode(record);
                if (!this.check(code).booleanValue()) {
                    throw new PurchaseException("PC0005", "code\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u590d");
                }
                record.setCode(code);
                this.pcsSkuMapper.updateByPrimaryKeySelective(record);
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
                throw new PurchaseException("PC0006", "\u751f\u6210SKUCODE\u5931\u8d25");
            }
            String skuCode = record.getCode();
            if (record.getSkuStatus() == 1) {
                this.pcsSkuSalesPriceChangeService.create(skuCode, record.getSalesPrice());
                this.pcsSkuSalesPriceChangeService.createCostPriceChange(skuCode, record.getCostPrice());
                this.pcsSkuSalesPriceChangeService.createSupplierChange(skuCode, record.getDefaultSupplierId().intValue());
            }
            if (EmptyUtil.isNotEmpty((Object)record.getPictureFileId())) {
                PegasusUtilFacade.getInstance().modifyFileName(record.getPictureFileId().longValue(), record.getCode() + ".jpg");
            }
            this.getBarcodeList(record);
            this.createPcsSkuBarcode(record.getBarcodeList());
            return record.getId();
        }
        return null;
    }

    private void getBarcodeList(PcsSku vo) {
        ArrayList<PcsSkuBarcode> barcodeList = new ArrayList<PcsSkuBarcode>();
        if (EmptyUtil.isNotEmpty((String)vo.getBarcode())) {
            String[] barcodeArr;
            for (String barcode : barcodeArr = vo.getBarcode().split(",")) {
                PcsSkuBarcode pcsSkuBarcode = new PcsSkuBarcode();
                pcsSkuBarcode.setAvailable(true);
                pcsSkuBarcode.setBarcode(barcode);
                pcsSkuBarcode.setSkuCode(vo.getCode());
                barcodeList.add(pcsSkuBarcode);
            }
        }
        vo.setBarcodeList(barcodeList);
    }

    @Override
    @Transactional
    public List<Long> createSkus(List<PcsSku> list) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (PcsSku pcsSku : list) {
            ids.add(this.create(pcsSku));
        }
        return ids;
    }

    private void initDefaultValue(PcsSku record) {
        record.setCode("");
        record.setCreateTime(new Date());
        record.setPointDeductRule(0);
        record.setPointDeductPoint(new BigDecimal("0.00"));
        record.setPointDuductPrice(new BigDecimal("0.00"));
        record.setCanRemark(0);
    }

    @Override
    @Transactional
    public boolean update(PcsSku record) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            PcsSku oldRecord = this.findById(record.getId());
            List<PcsSkuSalesPriceChange> salesPriceChangelist = this.pcsSkuSalesPriceChangeService.findByCode(oldRecord.getCode());
            if ((EmptyUtil.isNotEmpty((Object)record.getSalesPrice()) || EmptyUtil.isEmpty(salesPriceChangelist)) && record.getOptType() != 1 && record.getSkuStatus() == 1) {
                record.setOldSalesPrice(record.getSalesPrice());
                if (this.canUpdateSalesPrice(record.getCode()).booleanValue()) {
                    this.pcsSkuSalesPriceChangeService.create(record.getCode(), record.getSalesPrice());
                    record.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
                    String skuCode = record.getCode();
                }
            }
            List<PcsSkuCostPriceChange> costPriceChangelist = this.pcsSkuSalesPriceChangeService.findCostPriceChangeByCode(oldRecord.getCode());
            if ((EmptyUtil.isNotEmpty((Object)record.getCostPrice()) || EmptyUtil.isEmpty(costPriceChangelist)) && record.getOptType() != 1 && record.getSkuStatus() == 1) {
                record.setOldCostPrice(record.getCostPrice());
                if (this.canUpdateSalesPrice(record.getCode()).booleanValue()) {
                    this.pcsSkuSalesPriceChangeService.createCostPriceChange(record.getCode(), record.getCostPrice());
                    record.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
                }
            }
            List<PcsSkuSupplierChange> supplierChangelist = this.pcsSkuSalesPriceChangeService.findSupplierChangeByCode(oldRecord.getCode());
            if ((EmptyUtil.isNotEmpty((Object)record.getDefaultSupplierId()) || EmptyUtil.isEmpty(supplierChangelist)) && record.getOptType() != 1 && record.getSkuStatus() == 1) {
                record.setOldSupplierId(record.getDefaultSupplierId());
                if (this.canUpdateSalesPrice(record.getCode()).booleanValue()) {
                    this.pcsSkuSalesPriceChangeService.createSupplierChange(record.getCode(), record.getDefaultSupplierId().intValue());
                    record.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
                }
            }
            if (record.getOptType() != 1 && record.getSkuStatus() == 0) {
                record.setOldSalesPrice(record.getSalesPrice());
                record.setOldSupplierId(record.getDefaultSupplierId());
                record.setOldCostPrice(record.getCostPrice());
            }
            this.setNonField(record);
            if (record.getOptType() != 1 && oldRecord.getSkuStatus() != null && record.getSkuStatus() == 0) {
                record.setSkuStatus(oldRecord.getSkuStatus());
            }
            boolean result = this.pcsSkuMapper.updateByPrimaryKeySelective(record) != 0;
            this.createPcsSkuBarcode(record.getBarcodeList());
            if (result && EmptyUtil.isNotEmpty((Object)record.getPictureFileId())) {
                PegasusUtilFacade.getInstance().modifyFileName(record.getPictureFileId().longValue(), oldRecord.getCode() + ".jpg");
            }
            return result;
        }
        return false;
    }

    private void sendNotice(String skuCode) {
        SmsUtil smsUtil = SmsUtil.getInstance();
        SmsVO smsVO = new SmsVO();
        smsVO.setSendTime(new Date());
        CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("finance.Approval.Mobile");
        String[] toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        smsVO.setMobileList(Arrays.asList(toNotifyUsers));
        smsVO.setContent("\u60a8\u597d\uff0c\u60a8\u6709\u65b0\u7684SKU\u9700\u8981\u5ba1\u6279\uff0cSKU code\uff1a" + skuCode + "\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\uff0c\u8c22\u8c22\uff01");
        smsUtil.send(smsVO);
        commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("finance.Approval.Email");
        toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        EmailVO emailVO = new EmailVO();
        emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
        emailVO.setSubject("SKU\u5ba1\u6279");
        emailVO.setContent("\u60a8\u597d\uff0c\u60a8\u6709\u65b0\u7684SKU\u9700\u8981\u5ba1\u6279\uff0cSKU code\uff1a" + skuCode + "\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\uff0c\u8c22\u8c22\uff01");
        if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList())) {
            EmailUtil.getInstance().send(emailVO);
        }
    }

    private void setNonField(PcsSku record) {
        record.setSalesPrice(null);
        record.setCode(null);
        record.setSkuType(null);
        record.setIsImported(null);
        record.setIsMadeBySelf(null);
    }

    @Override
    public Boolean canUpdateSalesPrice(String code) {
        List<PcsSkuSalesPriceChange> processingPriceList = this.pcsSkuSalesPriceChangeService.findByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (processingPriceList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean auditSkuSalesPriceChange(String code, Boolean isPass) {
        PcsSkuVO pcsSkuVO = this.findByCode(code);
        if (EmptyUtil.isEmpty((Object)pcsSkuVO)) {
            throw new PurchaseException("PC0001", "sku\u5b9e\u4f53\u4e3a\u7a7a");
        }
        if (!pcsSkuVO.getSkuStatus().equals(PcsSku.SKU_STATUS_WAITING_VERIFY)) {
            throw new PurchaseException("PC0002", "\u5fc5\u987b\u662f\u5f85\u5ba1\u6838\u72b6\u6001");
        }
        PcsSkuSalesPriceChange pcsSkuSalesPriceChange = this.pcsSkuSalesPriceChangeService.auditSkuSalesPriceChange(code, isPass);
        PcsSkuCostPriceChange pcsSkuCostPriceChange = this.pcsSkuSalesPriceChangeService.auditSkuCostPriceChange(code, isPass);
        PcsSkuSupplierChange pcsSkuSupplierChange = this.pcsSkuSalesPriceChangeService.auditSkuSupplierChange(code, isPass);
        PcsSku pcsSku = new PcsSku();
        pcsSku.setId(pcsSkuVO.getId());
        if (EmptyUtil.isNotEmpty((Object)pcsSkuSalesPriceChange)) {
            if (pcsSkuSalesPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_SUCCESS)) {
                pcsSku.setSkuStatus(PcsSku.SKU_STATUS_ABLE);
                pcsSku.setSalesPrice(pcsSkuSalesPriceChange.getNewPrice());
            } else if (pcsSkuSalesPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_REJECT)) {
                pcsSku.setSkuStatus(PcsSku.SKU_STATUS_REJECT);
            }
        }
        if (EmptyUtil.isNotEmpty((Object)pcsSkuCostPriceChange)) {
            if (pcsSkuCostPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_SUCCESS)) {
                pcsSku.setSkuStatus(PcsSku.SKU_STATUS_ABLE);
                pcsSku.setCostPrice(pcsSkuCostPriceChange.getNewPrice());
            } else if (pcsSkuCostPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_REJECT)) {
                pcsSku.setSkuStatus(PcsSku.SKU_STATUS_REJECT);
            }
        }
        if (EmptyUtil.isNotEmpty((Object)pcsSkuSupplierChange)) {
            if (pcsSkuSupplierChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_SUCCESS)) {
                pcsSku.setSkuStatus(PcsSku.SKU_STATUS_ABLE);
                pcsSku.setDefaultSupplierId(pcsSkuSupplierChange.getNewSupplierId().longValue());
            } else if (pcsSkuSupplierChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_REJECT)) {
                pcsSku.setSkuStatus(PcsSku.SKU_STATUS_REJECT);
            }
        }
        this.pcsSkuMapper.updateByPrimaryKeySelective(pcsSku);
        return true;
    }

    @Override
    public PcsSkuSalesPriceChangeVO findSkuSalesPriceChangeByCodeAndProcessing(String code) {
        return this.pcsSkuSalesPriceChangeService.buildFromModel(this.pcsSkuSalesPriceChangeService.findSkuSalesPriceChangeByCodeAndProcessing(code));
    }

    @Override
    public List<PcsSku> findSkuByCodes(List<String> codes) {
        ArrayList<PcsSku> recordList = new ArrayList<PcsSku>();
        for (String code : codes) {
            PcsSku record = this.findSkuByCode(code);
            if (!EmptyUtil.isNotEmpty((Object)record) || !EmptyUtil.isNotEmpty((Object)record.getId())) continue;
            recordList.add(record);
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    @Transactional
    public Boolean convertSku(PcsSku sku, long skuCustomMadeId) {
        PcsSkuCustomMade pcsSkuCustomMade = this.pcsSkuCustomMadeService.findById(skuCustomMadeId);
        sku.setIsJit(0);
        if (EmptyUtil.isNotEmpty((Object)pcsSkuCustomMade) && pcsSkuCustomMade.getSkuStatus().equals(PcsSkuCustomMade.SKU_STATUS_WAITING_CONVERT)) {
            if (this.create(sku) > 0L) {
                pcsSkuCustomMade.setSkuStatus(PcsSkuCustomMade.SKU_STATUS_CONVERT);
                if (this.pcsSkuCustomMadeService.update(pcsSkuCustomMade)) {
                    return true;
                }
                throw new PurchaseException("PC0010", "sku\u5b9a\u5236\u5355\u66f4\u65b0\u5931\u8d25");
            }
            throw new PurchaseException("PC0009", "sku\u521b\u5efa\u5931\u8d25");
        }
        throw new PurchaseException("PC0002", "\u72b6\u6001\u5fc5\u987b\u662f\u5f85\u8f6c\u6362");
    }

    private PcsSku findSkuByCode(String code) {
        PcsSkuExample example = new PcsSkuExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PcsSku> recordList = this.pcsSkuMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return null;
        }
        if (recordList.size() > 1) {
            throw new PurchaseException("PC0007", " \u6839\u636ecode[" + code + "]\u80fd\u67e5\u51fa2\u6761\u4ee5\u4e0a(\u542b\u4e24\u6761)\u8bb0\u5f55");
        }
        return recordList.get(0);
    }

    @Override
    public PcsSku findById(long id) {
        if (EmptyUtil.isEmpty((Object)id)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return this.pcsSkuMapper.selectByPrimaryKey(id);
    }

    @Override
    public PcsSkuVO findByCode(String code) {
        return this.findByCode(code, false, true);
    }

    @Override
    public PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories) {
        List<PcsSkuCategory> categoryList;
        if (EmptyUtil.isEmpty((String)code)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        List<PcsSkuVO> voList = this.pcsSkuMapper.findSkuByCodes(Arrays.asList(code));
        if (CollectionUtils.isEmpty(voList)) {
            return null;
        }
        if (voList.size() > 1) {
            throw new PurchaseException("PC0007", " \u6839\u636ecode\u80fd\u67e5\u51fa2\u6761\u4ee5\u4e0a(\u542b\u4e24\u6761)\u8bb0\u5f55");
        }
        PcsSkuVO sku = voList.get(0);
        if (widthFrontCategories) {
            categoryList = this.pcsSkuCategoryService.findFrontCategoriesBySkuCode(sku.getCode());
            sku.setFrontCategoryList(categoryList);
        }
        if (withBackCategories) {
            categoryList = this.pcsSkuCategoryService.findBackCategoriesBySkuCode(sku.getCode());
            sku.setBackCategoryList(categoryList);
            ArrayList<PcsSkuCategory> secondaryCategoryList = new ArrayList<PcsSkuCategory>();
            for (PcsSkuCategory category : sku.getBackCategoryList()) {
                if (category.getId() == null || category.getId().equals(sku.getCategoryId())) continue;
                secondaryCategoryList.add(category);
            }
            sku.setSecondaryCategoryList(secondaryCategoryList);
        }
        sku.setBarcodeList(this.pcsSkuBarcodeMapper.selectBySkuCode(sku.getCode()));
        return sku;
    }

    @Override
    public List<PcsSkuVO> findByNameOrCode(String arg0) {
        if (EmptyUtil.isEmpty((String)arg0)) {
            return Collections.emptyList();
        }
        List<PcsSkuVO> voList = this.pcsSkuMapper.findSkuByNameOrCode(arg0);
        if (CollectionUtils.isEmpty(voList)) {
            return Collections.emptyList();
        }
        return voList;
    }

    @Override
    public List<PcsSkuVO> findByCond(PcsSkuCond cond) {
        return this.pcsSkuMapper.findSkuByCond(cond);
    }

    @Override
    public List<PcsSkuVO> findByCondForExport(PcsSkuCond cond) {
        return this.pcsSkuMapper.findSkuByCondForExport(cond);
    }

    @Override
    public List<Map<String, Object>> findSkuCanSaleAndCanSeeByChannelCode(String channelCode) {
        return this.pcsSkuMapper.findSkuCanSaleAndCanSeeByChannelCode(channelCode);
    }

    @Override
    public Map<String, Object> findSkuCanSaleAndCanSeeInfo(String channelCode, String skuCode) {
        return this.pcsSkuMapper.findSkuCanSaleAndCanSeeInfo(channelCode, skuCode);
    }

    @Override
    public List<PcsSkuVO> findSkuTagByCond(PcsSkuCond cond) {
        return this.pcsSkuMapper.findSkuTagByCond(cond);
    }

    public Boolean check(Object obj) {
        PcsSku record = (PcsSku)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(PcsSku record, Boolean isCreate) {
        PcsSku oldRecord;
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && NullUtil.isNotNull((Object)(oldRecord = this.pcsSkuMapper.selectByPrimaryKey(record.getId()))) && EmptyUtil.isNotEmpty((Object)oldRecord.getPictureFileId()) && EmptyUtil.isNotEmpty((Object)record.getPictureFileId()) && !oldRecord.getPictureFileId().equals(record.getPictureFileId())) {
            PegasusUtilFacade.getInstance().deleteFileById(oldRecord.getPictureFileId().longValue());
        }
        return true;
    }

    private Boolean check(String code) {
        PcsSkuExample example = new PcsSkuExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PcsSku> recordList = this.pcsSkuMapper.selectByExample(example);
        if (recordList.size() == 0) {
            return true;
        }
        return false;
    }

    public String generateCode(Object id) {
        return null;
    }

    private String generateSkuCode(PcsSku record) {
        String categoryCode = "";
        String createYear = "";
        Integer num = 0;
        String key = "";
        PcsSkuCategory skuCategory = this.pcsSkuCategoryService.findBackCategoryById(record.getCategoryId());
        if (!NullUtil.isNotNull((Object)skuCategory)) {
            throw new PurchaseException("PC0001", " sku \u54c1\u7c7b\u65e0\u76f8\u5173\u6570\u636e");
        }
        categoryCode = skuCategory.getCode();
        createYear = DateUtil.format((Date)DateUtil.getNow(), (String)"yyyy");
        createYear = createYear.substring(2);
        PcsSkuExample example = new PcsSkuExample();
        PcsSkuExample.Criteria criteria = example.createCriteria();
        criteria.andCodeLike(categoryCode + createYear + "%");
        example.setOrderByClause("id desc limit 1");
        List<PcsSku> skus = this.pcsSkuMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(skus)) {
            num = 1;
        } else {
            Integer _num;
            String tmp = skus.get(0).getCode();
            String prefix = categoryCode + createYear;
            int i = tmp.toUpperCase().indexOf(prefix.toUpperCase());
            tmp = tmp.substring(i + prefix.length());
            tmp = StringUtils.left((String)tmp, (int)3);
            Integer n = _num = Integer.valueOf(Integer.parseInt(tmp));
            Integer n2 = _num = Integer.valueOf(_num + 1);
            num = _num;
        }
        PcsBrand brand = this.pcsBrandService.findById(record.getBrandId());
        key = NullUtil.isNotNull((Object)brand) && !NumberUtil.isNullOrZero((Number)brand.getIsOwn()) ? (record.getSkuType().equals(PcsSku.SKU_TYPE_FINISHED_PRODUCT) ? (NumberUtil.isNullOrZero((Number)record.getIsImported()) ? (!NumberUtil.isNullOrZero((Number)record.getIsMadeBySelf()) ? "1" : "2") : (!NumberUtil.isNullOrZero((Number)record.getIsMadeBySelf()) ? "3" : "4")) : "0") : (record.getSkuType().equals(PcsSku.SKU_TYPE_FINISHED_PRODUCT) ? (!NumberUtil.isNullOrZero((Number)record.getIsImported()) ? (!NumberUtil.isNullOrZero((Number)record.getIsMadeBySelf()) ? "5" : "6") : (!NumberUtil.isNullOrZero((Number)record.getIsMadeBySelf()) ? "7" : "8")) : "9");
        if (EmptyUtil.isEmpty((String)categoryCode) || EmptyUtil.isEmpty((String)createYear) || NumberUtil.isNullOrZero((Number)num) || EmptyUtil.isEmpty((String)key)) {
            throw new PurchaseException("PC0001", " \u751f\u6210skucode\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryCode", categoryCode);
        params.put("createYear", createYear);
        params.put("num", num);
        params.put("key", key);
        String code = CodeGenerator.getInstance().generate("PCS_SKU", params);
        return code;
    }

    @Override
    public List<PcsSkuVO> findByCodes(List<String> codes) {
        return this.findByCodes(codes, false);
    }

    @Override
    public List<PcsSkuVO> findByCodes(List<String> codes, boolean withCategories) {
        List<Object> list = EmptyUtil.isEmpty(codes) ? new ArrayList() : this.pcsSkuMapper.findSkuByCodes(codes);
        for (int i = 0; i < list.size(); ++i) {
            PcsSkuVO skuVO = (PcsSkuVO)list.get(i);
            if (!withCategories) continue;
            List<PcsSkuCategory> categoryList = this.pcsSkuCategoryService.findFrontCategoriesBySkuCode(skuVO.getCode());
            skuVO.setFrontCategoryList(categoryList);
        }
        return list;
    }

    @Override
    public List<PcsSkuInfoVO> allSkuInfo() {
        return this.pcsSkuMapper.allSkuInfo();
    }

    @Override
    public PcsSkuInfoVO findStockByCode(String skuCode) {
        return this.pcsSkuMapper.findStockByCode(skuCode);
    }

    @Override
    public List<PcsSkuVO> findChannelSkuForNoDistribute(PcsSkuCond cond) {
        return this.pcsSkuMapper.findChannelSkuForNoDistribute(cond);
    }

    @Override
    @Transactional
    public void setSkuChannel(List<String> skuCodeList, List<String> channelCodeList, Long operatorId) {
        PcsSkuDistributeChannelExample example = new PcsSkuDistributeChannelExample();
        PcsSkuDistributeChannelExample.Criteria criteria = example.createCriteria();
        if (skuCodeList != null && skuCodeList.size() > 0) {
            for (String skuCode : skuCodeList) {
                criteria.andSkuCodeEqualTo(skuCode);
                List<PcsSkuDistributeChannel> list = this.pcsSkuDistributeChannelMapper.selectByExample(example);
                if (list != null && list.size() > 0) {
                    for (PcsSkuDistributeChannel pcsSkuDistributeChannel : list) {
                        pcsSkuDistributeChannel.setCancelFlag(1);
                        this.pcsSkuDistributeChannelMapper.updateByPrimaryKey(pcsSkuDistributeChannel);
                    }
                }
                if (channelCodeList == null || channelCodeList.size() <= 0) continue;
                for (String channelCode : channelCodeList) {
                    PcsSkuDistributeChannel pcsSkuDistributeChannel = new PcsSkuDistributeChannel();
                    pcsSkuDistributeChannel.setCancelFlag(0);
                    pcsSkuDistributeChannel.setChannelCode(channelCode);
                    pcsSkuDistributeChannel.setCreateTime(Calendar.getInstance().getTime());
                    pcsSkuDistributeChannel.setCreateUserId(operatorId);
                    pcsSkuDistributeChannel.setSkuCode(skuCode);
                    this.pcsSkuDistributeChannelMapper.insert(pcsSkuDistributeChannel);
                }
            }
        }
    }

    @Override
    public List<PcsSkuVO> findSkuByIds(List<Long> ids) {
        return this.pcsSkuMapper.findSkuByIds(ids);
    }

    @Override
    public List<PcsSkuVO> findSkuAuditByIds(List<Long> ids) {
        return this.pcsSkuMapper.findSkuAuditByIds(ids);
    }

    @Override
    public Boolean canUpdateCostPrice(String code) {
        List<PcsSkuCostPriceChange> processingPriceList = this.pcsSkuSalesPriceChangeService.findCostPriceChangeByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (processingPriceList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean canUpdateSupplier(String code) {
        List<PcsSkuSupplierChange> processingPriceList = this.pcsSkuSalesPriceChangeService.findSupplierChangeByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (processingPriceList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    public List<Long> updateSkus(List<PcsSkuVO> list) {
        return null;
    }

    public boolean update(PcsSkuVO vo) {
        if (vo.getOptType() == 1) {
            Boolean result = this.update(this.bulidFromVO(vo));
            return result;
        }
        PcsSkuVO oldSkuVO = this.findByCode(vo.getCode());
        boolean waitingVerify = false;
        if (!oldSkuVO.getSalesPrice().equals(vo.getSalesPrice())) {
            vo.setOldSalesPrice(oldSkuVO.getSalesPrice());
        }
        if (!oldSkuVO.getCostPrice().equals(vo.getCostPrice())) {
            vo.setOldCostPrice(oldSkuVO.getCostPrice());
            waitingVerify = true;
        }
        if (!oldSkuVO.getDefaultSupplierId().equals(vo.getDefaultSupplierId())) {
            vo.setOldSupplierId(oldSkuVO.getDefaultSupplierId());
            waitingVerify = true;
        }
        if (vo.getSkuStatus() != null && vo.getSkuStatus() == 1) {
            if (!oldSkuVO.getSalesPrice().equals(oldSkuVO.getOldSalesPrice())) {
                waitingVerify = true;
            }
            if (!oldSkuVO.getDefaultSupplierId().equals(oldSkuVO.getOldSupplierId())) {
                waitingVerify = true;
            }
            if (!oldSkuVO.getCostPrice().equals(oldSkuVO.getOldCostPrice())) {
                waitingVerify = true;
            }
        }
        Boolean result = this.update(this.bulidFromVO(vo));
        List<Long> categoryIds = vo.getSecondaryCategoryIds();
        if (categoryIds == null) {
            categoryIds = new ArrayList<Long>();
        }
        categoryIds.add(vo.getCategoryId());
        return result;
    }

    @Override
    public long countSkuByCond(PcsSkuCond cond) {
        return this.pcsSkuMapper.countSkuByCond(cond);
    }

    @Override
    public void createPcsSkuBarcode(List<PcsSkuBarcode> barcodeList) {
        if (EmptyUtil.isNotEmpty(barcodeList)) {
            String skuCode = barcodeList.get(0).getSkuCode();
            this.pcsSkuBarcodeMapper.deleteBySkuCode(skuCode);
            for (PcsSkuBarcode pcsSkuBarcode : barcodeList) {
                this.pcsSkuBarcodeMapper.insert(pcsSkuBarcode);
            }
        }
    }

    @Override
    public List<PcsSkuBarcodeVO> selectByBarCode(String barCode) {
        return this.pcsSkuBarcodeMapper.selectByBarCode(barCode);
    }
}

