/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuCostPriceChangeMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuSalesPriceChangeMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuSupplierChangeMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCostPriceChange;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCostPriceChangeExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSalesPriceChange;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSalesPriceChangeExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSupplierChange;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSupplierChangeExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuSalesPriceChangeService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuSalesPriceChangeVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsSkuSalesPriceChangeService")
public class PcsSkuSalesPriceChangeServiceImpl
implements PcsSkuSalesPriceChangeService,
CheckAble {
    private final Logger log = LoggerFactory.getLogger(PcsSkuSalesPriceChangeServiceImpl.class);
    @Autowired
    private PcsSkuSalesPriceChangeMapper pcsSkuSalesPriceChangeMapper;
    @Autowired
    private PcsSkuCostPriceChangeMapper pcsSkuCostPriceChangeMapper;
    @Autowired
    private PcsSkuSupplierChangeMapper pcsSkuSupplierChangeMapper;

    @Override
    public PcsSkuSalesPriceChangeVO buildFromModel(PcsSkuSalesPriceChange record) {
        if (NullUtil.isNull((Object)record)) {
            return null;
        }
        PcsSkuSalesPriceChangeVO vo = new PcsSkuSalesPriceChangeVO();
        BeanUtils.copyProperties((Object)record, (Object)vo);
        return vo;
    }

    @Override
    public PcsSkuSalesPriceChange bulidFromVO(PcsSkuSalesPriceChangeVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsSkuSalesPriceChange record = new PcsSkuSalesPriceChange();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    @Transactional
    public Long create(String code, BigDecimal price) {
        PcsSkuSalesPriceChange record = new PcsSkuSalesPriceChange();
        record.setSkuCode(code);
        record.setNewPrice(price);
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            record.setChangeTime(new Date());
            record.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
            this.pcsSkuSalesPriceChangeMapper.insertSelective(record);
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsSkuSalesPriceChange record) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            return this.pcsSkuSalesPriceChangeMapper.updateByPrimaryKeySelective(record) != 0;
        }
        return false;
    }

    @Override
    public PcsSkuSalesPriceChange findById(long id) {
        return this.pcsSkuSalesPriceChangeMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsSkuSalesPriceChange> findByCodeAndStatus(String code, Integer status) {
        if (EmptyUtil.isEmpty((String)code) || EmptyUtil.isEmpty((Object)status)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PcsSkuSalesPriceChangeExample example = new PcsSkuSalesPriceChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code).andChangeStatusEqualTo(status);
        List<PcsSkuSalesPriceChange> recordList = this.pcsSkuSalesPriceChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public PcsSkuSalesPriceChange auditSkuSalesPriceChange(String code, Boolean isPass) {
        PcsSkuSalesPriceChange record = this.findSkuSalesPriceChangeByCodeAndProcessing(code);
        if (EmptyUtil.isNotEmpty((Object)record)) {
            record.setChangeStatus(isPass != false ? PcsSkuSalesPriceChange.STATUS_SUCCESS : PcsSkuSalesPriceChange.STATUS_REJECT);
            if (this.update(record)) {
                return record;
            }
            throw new PurchaseException("PC0010", "\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
        }
        return null;
    }

    @Override
    public PcsSkuSalesPriceChange findSkuSalesPriceChangeByCodeAndProcessing(String code) {
        List<PcsSkuSalesPriceChange> list = this.findByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() > 1) {
            throw new PurchaseException("PC0007", "\u5f53\u524dSKUCODE\u6709\u4e24\u6761\u4ee5\u4e0a(\u542b\u4e24\u6761)\u5904\u7406\u4e2d\u7684\u552e\u4ef7\u53d8\u66f4,\u6bcf\u6b21\u53ea\u80fd\u6709\u4e00\u4e2a\u5904\u7406\u4e2d\u7684\u552e\u4ef7\u53d8\u66f4");
        }
        if (list.size() == 0) {
            return null;
        }
        throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
    }

    public Boolean check(Object obj) {
        PcsSkuSalesPriceChange record = (PcsSkuSalesPriceChange)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(PcsSkuSalesPriceChange record, Boolean isCreate) {
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        List<PcsSkuSalesPriceChange> oldList = this.findByCodeAndStatus(record.getSkuCode(), PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (oldList.size() > 0 && isCreate.booleanValue()) {
            throw new PurchaseException("PC0005", "\u524d\u4e00\u4e2aSKU\u552e\u4ef7\u5ba1\u6279\u8fd8\u672a\u901a\u8fc7\u6216\u9a73\u56de");
        }
        if (oldList.size() > 0 && !isCreate.booleanValue() && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException("PC0005", "\u524d\u4e00\u4e2aSKU\u552e\u4ef7\u5ba1\u6279\u8fd8\u672a\u901a\u8fc7\u6216\u9a73\u56de");
        }
        return true;
    }

    @Override
    public Long createSupplierChange(String code, Integer supplierId) {
        PcsSkuSupplierChange record = new PcsSkuSupplierChange();
        record.setSkuCode(code);
        record.setNewSupplierId(supplierId);
        if (this.checkSupplierChange(record, true).booleanValue()) {
            record.setChangeTime(new Date());
            record.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
            this.pcsSkuSupplierChangeMapper.insertSelective(record);
        }
        return null;
    }

    private Boolean checkCostPriceChange(PcsSkuCostPriceChange record, Boolean isCreate) {
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        List<PcsSkuCostPriceChange> oldList = this.findCostPriceChangeByCodeAndStatus(record.getSkuCode(), PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (oldList.size() > 0 && isCreate.booleanValue()) {
            throw new PurchaseException("PC0005", "\u524d\u4e00\u4e2aSKU\u6210\u672c\u5ba1\u6279\u8fd8\u672a\u901a\u8fc7\u6216\u9a73\u56de");
        }
        if (oldList.size() > 0 && !isCreate.booleanValue() && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException("PC0005", "\u524d\u4e00\u4e2aSKU\u6210\u672c\u5ba1\u6279\u8fd8\u672a\u901a\u8fc7\u6216\u9a73\u56de");
        }
        return true;
    }

    private Boolean checkSupplierChange(PcsSkuSupplierChange record, Boolean isCreate) {
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        List<PcsSkuSupplierChange> oldList = this.findSupplierChangeByCodeAndStatus(record.getSkuCode(), PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (oldList.size() > 0 && isCreate.booleanValue()) {
            throw new PurchaseException("PC0005", "\u524d\u4e00\u4e2aSKU\u4f9b\u5e94\u5546\u5ba1\u6279\u8fd8\u672a\u901a\u8fc7\u6216\u9a73\u56de");
        }
        if (oldList.size() > 0 && !isCreate.booleanValue() && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException("PC0005", "\u524d\u4e00\u4e2aSKU\u4f9b\u5e94\u5546\u5ba1\u6279\u8fd8\u672a\u901a\u8fc7\u6216\u9a73\u56de");
        }
        return true;
    }

    @Override
    public Long createCostPriceChange(String code, BigDecimal price) {
        PcsSkuCostPriceChange record = new PcsSkuCostPriceChange();
        record.setSkuCode(code);
        record.setNewPrice(price);
        if (this.checkCostPriceChange(record, true).booleanValue()) {
            record.setChangeTime(new Date());
            record.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
            this.pcsSkuCostPriceChangeMapper.insertSelective(record);
        }
        return null;
    }

    @Override
    public PcsSkuCostPriceChange auditSkuCostPriceChange(String code, Boolean isPass) {
        PcsSkuCostPriceChange record = null;
        List<PcsSkuCostPriceChange> list = this.findCostPriceChangeByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (list == null) {
            return null;
        }
        if (list.size() != 1) {
            if (list.size() > 1) {
                throw new PurchaseException("PC0007", "\u5f53\u524dSKUCODE\u6709\u4e24\u6761\u4ee5\u4e0a(\u542b\u4e24\u6761)\u5904\u7406\u4e2d\u7684\u552e\u4ef7\u53d8\u66f4,\u6bcf\u6b21\u53ea\u80fd\u6709\u4e00\u4e2a\u5904\u7406\u4e2d\u7684\u552e\u4ef7\u53d8\u66f4");
            }
            if (list.size() == 0) {
                return null;
            }
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        record = list.get(0);
        record.setChangeStatus(isPass != false ? PcsSkuSalesPriceChange.STATUS_SUCCESS : PcsSkuSalesPriceChange.STATUS_REJECT);
        if (this.checkCostPriceChange(record, false).booleanValue()) {
            if (this.pcsSkuCostPriceChangeMapper.updateByPrimaryKeySelective(record) != 0) {
                return record;
            }
            return record;
        }
        throw new PurchaseException("PC0010", "\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public PcsSkuSupplierChange auditSkuSupplierChange(String code, Boolean isPass) {
        PcsSkuSupplierChange record = null;
        List<PcsSkuSupplierChange> list = this.findSupplierChangeByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (list.size() != 1) {
            if (list.size() > 1) {
                throw new PurchaseException("PC0007", "\u5f53\u524dSKUCODE\u6709\u4e24\u6761\u4ee5\u4e0a(\u542b\u4e24\u6761)\u5904\u7406\u4e2d\u7684\u552e\u4ef7\u53d8\u66f4,\u6bcf\u6b21\u53ea\u80fd\u6709\u4e00\u4e2a\u5904\u7406\u4e2d\u7684\u552e\u4ef7\u53d8\u66f4");
            }
            if (list.size() == 0) {
                return null;
            }
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        record = list.get(0);
        record.setChangeStatus(isPass != false ? PcsSkuSalesPriceChange.STATUS_SUCCESS : PcsSkuSalesPriceChange.STATUS_REJECT);
        if (this.checkSupplierChange(record, false).booleanValue()) {
            if (this.pcsSkuSupplierChangeMapper.updateByPrimaryKeySelective(record) != 0) {
                return record;
            }
            return record;
        }
        throw new PurchaseException("PC0010", "\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public List<PcsSkuCostPriceChange> findCostPriceChangeByCodeAndStatus(String code, Integer status) {
        if (EmptyUtil.isEmpty((String)code) || EmptyUtil.isEmpty((Object)status)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PcsSkuCostPriceChangeExample example = new PcsSkuCostPriceChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code).andChangeStatusEqualTo(status);
        List<PcsSkuCostPriceChange> recordList = this.pcsSkuCostPriceChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSkuSupplierChange> findSupplierChangeByCodeAndStatus(String code, Integer status) {
        if (EmptyUtil.isEmpty((String)code) || EmptyUtil.isEmpty((Object)status)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PcsSkuSupplierChangeExample example = new PcsSkuSupplierChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code).andChangeStatusEqualTo(status);
        List<PcsSkuSupplierChange> recordList = this.pcsSkuSupplierChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSkuSalesPriceChange> findByCode(String code) {
        if (EmptyUtil.isEmpty((String)code)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PcsSkuSalesPriceChangeExample example = new PcsSkuSalesPriceChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code);
        List<PcsSkuSalesPriceChange> recordList = this.pcsSkuSalesPriceChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSkuCostPriceChange> findCostPriceChangeByCode(String code) {
        if (EmptyUtil.isEmpty((String)code)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PcsSkuCostPriceChangeExample example = new PcsSkuCostPriceChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code);
        List<PcsSkuCostPriceChange> recordList = this.pcsSkuCostPriceChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSkuSupplierChange> findSupplierChangeByCode(String code) {
        if (EmptyUtil.isEmpty((String)code)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PcsSkuSupplierChangeExample example = new PcsSkuSupplierChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code);
        List<PcsSkuSupplierChange> recordList = this.pcsSkuSupplierChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }
}

