/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuImgMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuImg;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuImgExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuImgService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PcsSkuImgServiceImpl
implements PcsSkuImgService {
    @Autowired
    private PcsSkuImgMapper pcsSkuImgMapper;

    @Override
    public boolean create(PcsSkuImg pcsSkuImg) {
        return this.pcsSkuImgMapper.insert(pcsSkuImg) != 0;
    }

    @Override
    public boolean update(PcsSkuImg pcsSkuImg) {
        return this.pcsSkuImgMapper.updateByPrimaryKeySelective(pcsSkuImg) != 0;
    }

    @Override
    public List<PcsSkuImg> findByCode(String code, Boolean isEnable) {
        PcsSkuImgExample example = new PcsSkuImgExample();
        PcsSkuImgExample.Criteria or1 = example.or();
        PcsSkuImgExample.Criteria or2 = example.or();
        or1.andSkuCodeEqualTo(code);
        or2.andProductCodeEqualTo(code);
        if (null != isEnable) {
            or1.andCancelFlagEqualTo(isEnable != false ? PcsSkuImg.CANCEL_NO : PcsSkuImg.CANCEL_YES);
            or2.andCancelFlagEqualTo(isEnable != false ? PcsSkuImg.CANCEL_NO : PcsSkuImg.CANCEL_YES);
        }
        example.setOrderByClause("seq");
        return this.pcsSkuImgMapper.selectByExample(example);
    }

    @Override
    public boolean create(List<PcsSkuImg> pcsSkuImgs) {
        if (CollectionUtils.isEmpty(pcsSkuImgs)) {
            return false;
        }
        String code = pcsSkuImgs.get(0).getProductCode();
        if (StringUtils.isBlank((String)code)) {
            code = pcsSkuImgs.get(0).getSkuCode();
        }
        List<PcsSkuImg> cancelImgs = this.findByCode(code, true);
        boolean succ = false;
        for (PcsSkuImg pcsSkuImg : pcsSkuImgs) {
            succ |= this.create(pcsSkuImg);
        }
        if (succ) {
            for (PcsSkuImg pcsSkuImg : pcsSkuImgs) {
                for (PcsSkuImg cancelImg : cancelImgs) {
                    if (!pcsSkuImg.getSeq().equals(cancelImg.getSeq())) continue;
                    cancelImg.setCancelFlag(PcsSkuImg.CANCEL_YES);
                    this.update(cancelImg);
                }
            }
        }
        return succ;
    }
}

