/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.integration.sms.SmsUtil;
import com.thebeastshop.pegasus.integration.sms.SmsVO;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseOrderCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseOrderMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrderExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSalesPriceChange;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuSalesPriceChangeService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseOrderVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;
import com.thebeastshop.pegasus.util.model.CommCurrency;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsPurchaseOrderService")
public class PcsPurchaseOrderServiceImpl
implements PcsPurchaseOrderService,
CheckAble,
CodeAble {
    private final Logger log = LoggerFactory.getLogger(PcsPurchaseOrderServiceImpl.class);
    @Autowired
    private PcsPurchaseOrderMapper pcsPurchaseOrderMapper;
    @Autowired
    private PcsPoLineService pcsPoLineService;
    @Autowired
    private PcsPoPlanMapper pcsPoPlanMapper;
    @Autowired
    private PcsPoPlanLineService pcsPoPlanLineService;
    @Autowired
    private PcsSkuSalesPriceChangeService pcsSkuSalesPriceChangeService;

    public Boolean check(Object obj) {
        PcsPurchaseOrder record = (PcsPurchaseOrder)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        Boolean currencyFlag = false;
        List allCurrency = PegasusUtilFacade.getInstance().findAllCurrency();
        for (CommCurrency c : allCurrency) {
            if (!c.getCode().equals(record.getPurchaseCurrencyCode())) continue;
            record.setPurchaseCurrencyDesc(c.getDescInfo());
            currencyFlag = true;
            break;
        }
        if (!currencyFlag.booleanValue()) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(PcsPurchaseOrder record, Boolean isCreate) {
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(String code) {
        return NullUtil.isNull((Object)this.findPoByCode(code));
    }

    public String generateCode(Object id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        String code = CodeGenerator.getInstance().generate("PCS_PURCHASE_ORDER", params);
        return code;
    }

    @Override
    public PcsPurchaseOrder buildFromVO(PcsPurchaseOrderVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsPurchaseOrder record = new PcsPurchaseOrder();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    public PcsPurchaseOrderVO buildFromModel(PcsPurchaseOrder record) {
        if (NullUtil.isNull((Object)record)) {
            return null;
        }
        PcsPurchaseOrderVO vo = new PcsPurchaseOrderVO();
        BeanUtils.copyProperties((Object)record, (Object)vo);
        return vo;
    }

    @Override
    @Transactional
    public PcsPurchaseOrder create(PcsPurchaseOrder record, boolean saveDraft) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            record.setCreateTime(new Date());
            record.setIsReceivedAll(1);
            this.pcsPurchaseOrderMapper.insertSelective(record);
            try {
                String code = this.generateCode(record.getId());
                if (this.check(code).booleanValue()) {
                    record.setCode(code);
                    if (!saveDraft) {
                        // empty if block
                    }
                    this.pcsPurchaseOrderMapper.updateByPrimaryKeySelective(record);
                    return record;
                }
                throw new PurchaseException("PC0005", "code\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u590d");
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
                throw new PurchaseException("PC0006", "\u751f\u6210CODE\u5931\u8d25");
            }
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsPurchaseOrder record) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            record.setCode(null);
            return this.pcsPurchaseOrderMapper.updateByPrimaryKeySelective(record) != 0;
        }
        return false;
    }

    @Override
    public PcsPurchaseOrder findPoById(long id) {
        return this.pcsPurchaseOrderMapper.selectByPrimaryKey(id);
    }

    @Override
    public PcsPurchaseOrderVO findPoVOById(long id) {
        return this.pcsPurchaseOrderMapper.findPoVOById(id);
    }

    @Override
    public PcsPurchaseOrderVO findPurchaseOrderByCommandCode(String commandCode) {
        return this.pcsPurchaseOrderMapper.findPurchaseOrderByCommandCode(commandCode);
    }

    @Override
    public PcsPurchaseOrder findPoByCode(String code) {
        PcsPurchaseOrderExample example = new PcsPurchaseOrderExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PcsPurchaseOrder> poList = this.pcsPurchaseOrderMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return null;
        }
        if (poList.size() > 1) {
            throw new PurchaseException("PC0005", " \u6839\u636ecode[" + code + "]\u80fd\u67e5\u51fa2\u6761\u4ee5\u4e0a(\u542b\u4e24\u6761)\u8bb0\u5f55");
        }
        return poList.get(0);
    }

    @Override
    public List<PcsPurchaseOrderVO> findPOVOByCond(PcsPurchaseOrderCond cond) {
        return this.pcsPurchaseOrderMapper.findPOVOByCond(cond);
    }

    @Override
    @Transactional
    public Long createPurchaseOrderAndLine(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, boolean saveDraft) {
        this.computeTotalPrice(pcsPurchaseOrder, pcsPoLineList);
        if (pcsPoLineList.size() == 0) {
            throw new PurchaseException("PC0001", "\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u884c\u4fe1\u606f");
        }
        if (saveDraft) {
            pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT);
        } else {
            pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT);
        }
        pcsPurchaseOrder = this.create(pcsPurchaseOrder, saveDraft);
        if (EmptyUtil.isEmpty((Object)pcsPurchaseOrder.getId())) {
            throw new PurchaseException("PC0009", "\u5934\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + pcsPurchaseOrder.toString());
        }
        for (PcsPoLine pcsPoLine : pcsPoLineList) {
            if (!saveDraft && EmptyUtil.isEmpty(this.pcsSkuSalesPriceChangeService.findByCodeAndStatus(pcsPoLine.getSkuCode(), PcsSkuSalesPriceChange.STATUS_SUCCESS))) {
                throw new PurchaseException("PC0001", "\u91c7\u8d2d\u5355\u4e2d\u5b58\u5728\u552e\u4ef7\u5ba1\u6279\u672a\u901a\u8fc7\u7684SKU\uff0c\u63d0\u4ea4\u5931\u8d25");
            }
            pcsPoLine.setPoId(pcsPurchaseOrder.getId());
            if (this.pcsPoLineService.create(pcsPoLine).compareTo(0L) >= 1) continue;
            throw new PurchaseException("PC0009", "\u884c\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + pcsPoLine.toString());
        }
        return pcsPurchaseOrder.getId();
    }

    private void computeTotalPrice(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList) {
        BigDecimal totalAmount = new BigDecimal(0.0);
        BigDecimal totalTax = new BigDecimal(0.0);
        BigDecimal totalAmountAfterTax = new BigDecimal(0.0);
        BigDecimal otherFeeAfterTax = new BigDecimal(0.0);
        if (EmptyUtil.isNotEmpty(pcsPoLineList)) {
            for (PcsPoLine pcsPoLine : pcsPoLineList) {
                BigDecimal unitPrice = pcsPoLine.getUnitPrice();
                int quantity = pcsPoLine.getQuantity();
                BigDecimal taxRate = pcsPoLine.getTaxRate();
                taxRate = taxRate.add(new BigDecimal(1));
                BigDecimal unitPriceAfterTax = pcsPoLine.getUnitPrice().divide(taxRate, 2, 6);
                pcsPoLine.setTotalPrice(unitPrice.multiply(new BigDecimal(quantity)));
                totalAmount = totalAmount.add(pcsPoLine.getTotalPrice());
                pcsPoLine.setUnitPriceAfterTax(unitPriceAfterTax);
                pcsPoLine.setTotalPriceAfterTax(unitPriceAfterTax.multiply(new BigDecimal(quantity)));
                pcsPoLine.setTaxRate(pcsPoLine.getTaxRate());
                totalAmountAfterTax = totalAmountAfterTax.add(pcsPoLine.getTotalPriceAfterTax());
            }
            totalAmount = totalAmount.add(pcsPurchaseOrder.getOtherFee());
            otherFeeAfterTax = pcsPurchaseOrder.getOtherFee().divide(pcsPurchaseOrder.getOtherFeeTaxRate().add(new BigDecimal(1)), 2, 6);
            totalAmountAfterTax = totalAmountAfterTax.add(otherFeeAfterTax);
            totalTax = totalAmount.subtract(totalAmountAfterTax);
        }
        pcsPurchaseOrder.setTotalAmount(totalAmount);
        pcsPurchaseOrder.setTotalAmountAfterTax(totalAmountAfterTax);
        if (EmptyUtil.isNotEmpty((Object)pcsPurchaseOrder.getCrossBorderFlag()) && pcsPurchaseOrder.getCrossBorderFlag() == 0 && EmptyUtil.isNotEmpty((Object)pcsPurchaseOrder.getIncludeShipment()) && pcsPurchaseOrder.getIncludeShipment() == 0) {
            BigDecimal logisticsCost = pcsPurchaseOrder.getLogisticsCost() == null ? new BigDecimal(0.0) : pcsPurchaseOrder.getLogisticsCost();
            totalAmount = totalAmount.add(logisticsCost);
            pcsPurchaseOrder.setTotalAmount(totalAmount);
            pcsPurchaseOrder.setTotalAmountAfterTax(totalAmountAfterTax.add(logisticsCost));
        }
        pcsPurchaseOrder.setOtherFeeTaxRate(pcsPurchaseOrder.getOtherFeeTaxRate());
    }

    @Override
    @Transactional
    public Boolean updatePurchaseOrderAndLine(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, boolean saveDraft) {
        Boolean update;
        this.computeTotalPrice(pcsPurchaseOrder, pcsPoLineList);
        if (pcsPoLineList.size() == 0) {
            throw new PurchaseException("PC0001", "\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u884c\u4fe1\u606f");
        }
        if (!saveDraft) {
            pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT);
            String code = pcsPurchaseOrder.getCode();
        }
        if ((update = Boolean.valueOf(this.update(pcsPurchaseOrder))).booleanValue()) {
            for (PcsPoLine pcsPoLine : pcsPoLineList) {
                if (!saveDraft && EmptyUtil.isEmpty(this.pcsSkuSalesPriceChangeService.findByCodeAndStatus(pcsPoLine.getSkuCode(), PcsSkuSalesPriceChange.STATUS_SUCCESS))) {
                    throw new PurchaseException("PC0001", "\u91c7\u8d2d\u5355\u4e2d\u5b58\u5728\u552e\u4ef7\u5ba1\u6279\u672a\u901a\u8fc7\u7684SKU\uff0c\u63d0\u4ea4\u5931\u8d25");
                }
                if (EmptyUtil.isEmpty((Object)pcsPoLine.getId())) {
                    pcsPoLine.setPoId(pcsPurchaseOrder.getId());
                    if (this.pcsPoLineService.create(pcsPoLine).compareTo(0L) >= 1) continue;
                    throw new PurchaseException("PC0009", "\u884c\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + pcsPoLine.toString());
                }
                if (this.pcsPoLineService.update(pcsPoLine)) continue;
                throw new PurchaseException("PC0010", "\u884c\u4fe1\u606f\u66f4\u65b0\u5931\u8d25," + pcsPoLine.toString());
            }
            return true;
        }
        throw new PurchaseException("PC0010", "\u5934\u4fe1\u606f\u66f4\u65b0\u5931\u8d25," + pcsPurchaseOrder.toString());
    }

    private void sendNotice(String code) {
        SmsUtil smsUtil = SmsUtil.getInstance();
        SmsVO smsVO = new SmsVO();
        smsVO.setSendTime(new Date());
        CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("planner.Approval.Mobile");
        String[] toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        smsVO.setMobileList(Arrays.asList(toNotifyUsers));
        smsVO.setContent("\u60a8\u597d\uff0c\u60a8\u6709\u65b0\u7684\u91c7\u8d2d\u5355\u9700\u8981\u5ba1\u6279\uff0c\u91c7\u8d2d\u5355code\uff1a" + code + "\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\uff0c\u8c22\u8c22\uff01");
        smsUtil.send(smsVO);
        commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("planner.Approval.Email");
        toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        EmailVO emailVO = new EmailVO();
        emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
        emailVO.setSubject("\u91c7\u8d2d\u5355\u5ba1\u6279");
        emailVO.setContent("\u60a8\u597d\uff0c\u60a8\u6709\u65b0\u7684\u91c7\u8d2d\u5355\u9700\u8981\u5ba1\u6279\uff0c\u91c7\u8d2d\u5355 code\uff1a" + code + "\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\uff0c\u8c22\u8c22\uff01");
        if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList())) {
            EmailUtil.getInstance().send(emailVO);
        }
    }

    @Override
    public List<String> findWarehouseCodeGroup() {
        List<String> warehouseCodeList = this.pcsPurchaseOrderMapper.findWarehouseCodeGroup();
        if (CollectionUtils.isEmpty(warehouseCodeList)) {
            return Collections.emptyList();
        }
        return warehouseCodeList;
    }

    @Override
    @Transactional
    public Boolean auditPurchaseOrder(long id, Boolean isPass, Integer type) {
        PcsPurchaseOrder record = this.findPoById(id);
        if (EmptyUtil.isNotEmpty((Object)record) && (record.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT) || record.getPurchaseOrderStatus() == 4)) {
            record.setAuditTime(new Date());
            if (isPass.booleanValue()) {
                if (type == 1) {
                    record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                } else {
                    record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                }
            } else {
                record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_REJECT);
            }
            boolean update = this.update(record);
            if (update) {
                return true;
            }
            throw new PurchaseException("PC0010", "\u5ba1\u6838\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
        }
        throw new PurchaseException("PC0002", "\u5fc5\u987b\u662f\u5f85\u5ba1\u6838\u72b6\u6001");
    }

    @Override
    @Transactional
    public Boolean closePurchaseOrder(long id) {
        PcsPurchaseOrder record = this.findPoById(id);
        if (EmptyUtil.isNotEmpty((Object)record) && (record.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE) || record.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE))) {
            record.setFinishedTime(new Date());
            record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH);
            boolean update = this.update(record);
            if (update) {
                return true;
            }
            throw new PurchaseException("PC0010", "\u5173\u95ed\u91c7\u8d2d\u5355\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
        }
        throw new PurchaseException("PC0002", "\u5fc5\u987b\u662f\u5f85\u6536\u8d27\u4e2d\u72b6\u6001");
    }

    @Override
    @Transactional
    public Boolean deletePcsPoLine(long poId, long pcsPoLineId) {
        PcsPurchaseOrder pcsPurchaseOrder = this.findPoById(poId);
        if (EmptyUtil.isNotEmpty((Object)pcsPurchaseOrder) && EmptyUtil.isNotEmpty((Object)pcsPurchaseOrder.getPurchaseOrderStatus()) && (pcsPurchaseOrder.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT) || pcsPurchaseOrder.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_REJECT))) {
            PcsPoLine pcsPoLine = this.pcsPoLineService.findPoLineById(pcsPoLineId);
            if (EmptyUtil.isNotEmpty((Object)pcsPoLine) && EmptyUtil.isNotEmpty((Object)pcsPoLine.getPoId()) && pcsPoLine.getPoId().equals(poId)) {
                return this.pcsPoLineService.deleteById(pcsPoLineId);
            }
            throw new PurchaseException("PC0002", "\u884cId\u5f02\u5e38");
        }
        throw new PurchaseException("PC0002", "\u53ea\u6709\u5f85\u4fee\u6539\u72b6\u6001\u7684\u91c7\u8d2d\u5355\u53ef\u4ee5\u5220\u51cf\u884c\u4fe1\u606f");
    }

    @Override
    @Transactional
    public void processReceicePlan(String poPlanCode, Map<String, Integer> liangpinMap, Map<String, Integer> canciMap) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andCodeEqualTo(poPlanCode);
        List<PcsPoPlan> pcsPoPlanList = this.pcsPoPlanMapper.selectByExample(example);
        if (pcsPoPlanList != null && pcsPoPlanList.size() > 0) {
            PcsPurchaseOrder purchaseOrder;
            PcsPoPlan pcsPoPlan = pcsPoPlanList.get(0);
            pcsPoPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_FINISHED);
            this.pcsPoPlanMapper.updateByPrimaryKey(pcsPoPlan);
            List<PcsPoPlanLine> pcsPoPlanLineList = this.pcsPoPlanLineService.findPoPlanLineByPoPlanId(pcsPoPlan.getId());
            for (PcsPoPlanLine pcsPoPlanLine : pcsPoPlanLineList) {
                pcsPoPlanLine.setQuantity(liangpinMap.get(pcsPoPlanLine.getSkuCode()));
                pcsPoPlanLine.setWasteQuantity(canciMap.get(pcsPoPlanLine.getSkuCode()));
                this.pcsPoPlanLineService.update(pcsPoPlanLine);
            }
            int result = this.pcsPoPlanMapper.isAllReceivePo(pcsPoPlan.getPoId());
            if (result <= 0 && (purchaseOrder = this.pcsPurchaseOrderMapper.selectByPrimaryKey(pcsPoPlan.getPoId())) != null) {
                purchaseOrder.setFinishedTime(Calendar.getInstance().getTime());
                purchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH);
                this.pcsPurchaseOrderMapper.updateByPrimaryKey(purchaseOrder);
            }
        }
    }

    @Override
    public boolean updatePurchaseOrder(PcsPurchaseOrder record) {
        return this.pcsPurchaseOrderMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    public long countByCond(PcsPurchaseOrderCond cond) {
        return this.pcsPurchaseOrderMapper.countByCond(cond);
    }
}

