/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanCostMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanLineMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseOrderMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanCost;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseOrderVO;
import com.thebeastshop.pegasus.service.purchase.vo.PoInfomationVO;
import com.thebeastshop.pegasus.service.warehouse.PegasusWarehouseInnerServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.ExcelUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;
import com.thebeastshop.pegasus.util.model.CommEntityOpRcd;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsPoPlanService")
public class PcsPoPlanServiceImpl
implements PcsPoPlanService,
CheckAble,
CodeAble {
    private final Logger log = LoggerFactory.getLogger(PcsPoPlanServiceImpl.class);
    private PegasusWarehouseInnerServiceFacade facadeWhInner;
    @Autowired
    private PcsPoPlanMapper pcsPoPlanMapper;
    @Autowired
    private PcsPoPlanLineMapper pcsPoPlanLineMapper;
    @Autowired
    private PcsPurchaseOrderMapper pcsPurchaseOrderMapper;
    @Autowired
    private PcsPoPlanLineService pcsPoPlanLineService;
    @Autowired
    private PcsPurchaseOrderService pcsPurchaseOrderService;
    @Autowired
    private PcsPoLineService pcsPoLineService;
    @Autowired
    private PcsPoPlanCostMapper pcsPoPlanCostMapper;

    @PostConstruct
    private void init() {
        this.facadeWhInner = PegasusWarehouseInnerServiceFacade.getInstance();
    }

    @Override
    public PcsPoPlan buildFromVO(PcsPoPlanVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsPoPlan record = new PcsPoPlan();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    public PcsPoPlanVO buildFromModel(PcsPoPlan record) {
        if (NullUtil.isNull((Object)record)) {
            return null;
        }
        PcsPoPlanVO vo = new PcsPoPlanVO();
        BeanUtils.copyProperties((Object)record, (Object)vo);
        return vo;
    }

    private WhCommand bulidWhCommand(PcsPoPlan pcsPoPlan, List<PcsPoPlanLine> pcsPoPlanLineList) {
        PcsPurchaseOrder po = this.pcsPurchaseOrderService.findPoById(pcsPoPlan.getPoId());
        if (EmptyUtil.isEmpty((Object)po)) {
            throw new PurchaseException("PC0001", "\u91c7\u8d2d\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!po.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE) && !po.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE)) {
            throw new PurchaseException("PC0002", "\u91c7\u8d2d\u5355\u72b6\u6001\u5fc5\u987b\u662f\u6536\u8d27\u4e2d");
        }
        if (CollectionUtils.isEmpty(pcsPoPlanLineList)) {
            throw new PurchaseException("PC0001", "pcsPoPlanLineList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WhCommand whCommand = new WhCommand();
        whCommand.setWarehouseCode(po.getWarehouseCode());
        whCommand.setReferenceCode(pcsPoPlan.getCode());
        whCommand.setInOutType(WhCommand.TYPE_PURCHASE_IN);
        ArrayList<WhCommandSku> whCommandSkuList = new ArrayList<WhCommandSku>();
        for (PcsPoPlanLine line : pcsPoPlanLineList) {
            if (line.getPlanedQuantity().compareTo(0) <= 0) {
                throw new PurchaseException("PC0001", "\u6784\u9020\u4ed3\u5e93\u6307\u4ee4\u7684LIST\u5931\u8d25,\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            }
            WhCommandSku whCommandSku = new WhCommandSku();
            whCommandSku.setSkuCode(line.getSkuCode());
            whCommandSku.setPlanedQuantity(line.getPlanedQuantity());
            whCommandSku.setQpb(line.getQpb());
            if (!NumberUtil.isNullOrZero((Number)line.getQuantity())) {
                whCommandSku.setQuantity(line.getQuantity());
            }
            if (!NumberUtil.isNullOrZero((Number)line.getWasteQuantity())) {
                whCommandSku.setDamagedQuantity(line.getWasteQuantity());
            }
            whCommandSkuList.add(whCommandSku);
        }
        if (CollectionUtils.isEmpty(whCommandSkuList)) {
            throw new PurchaseException("PC0001", "\u6784\u9020\u4ed3\u5e93\u6307\u4ee4\u7684LIST\u5931\u8d25,whCommandSkuList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        whCommand.setWhCommandSkuList(whCommandSkuList);
        return whCommand;
    }

    @Override
    @Transactional
    public PcsPoPlan create(PcsPoPlan record) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            record.setWhCommandCode("");
            record.setPlanStatus(PcsPoPlan.PLAN_STATUS_WAITING_RECEIVE);
            this.pcsPoPlanMapper.insertSelective(record);
            try {
                String code = this.generateCode(record.getId());
                if (!this.check(code).booleanValue()) {
                    throw new PurchaseException("PC0005", "code\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u590d");
                }
                record.setCode(code);
            }
            catch (WarehouseException we) {
                this.log.error("", (Throwable)we);
                throw new PurchaseException(we.getErrorCode(), "facadeWhInner error:" + we.getMessage());
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
                throw new PurchaseException("PC0006", e.getMessage());
            }
            this.pcsPoPlanMapper.updateByPrimaryKeySelective(record);
            return record;
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsPoPlan record) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            return this.pcsPoPlanMapper.updateByPrimaryKeySelective(record) != 0;
        }
        return false;
    }

    @Override
    public PcsPoPlan findPoPlanById(long id) {
        return this.pcsPoPlanMapper.selectByPrimaryKey(id);
    }

    @Override
    public boolean updatePcsPoPlanById(long id, String date) {
        int result = 0;
        try {
            result = this.pcsPoPlanMapper.updatePcsPoPlanById(id, date);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        return result > 0;
    }

    @Override
    public PcsPoPlan findPoPlanByCode(String code) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PcsPoPlan> poList = this.pcsPoPlanMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return null;
        }
        if (poList.size() > 1) {
            throw new PurchaseException("PC0005", " \u6839\u636ecode[" + code + "]\u80fd\u67e5\u51fa2\u6761\u4ee5\u4e0a(\u542b\u4e24\u6761)\u8bb0\u5f55");
        }
        return poList.get(0);
    }

    @Override
    public List<PcsPoPlan> findPoPlanByStatus(Integer status) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andPlanStatusEqualTo(status);
        List<PcsPoPlan> poList = this.pcsPoPlanMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        }
        return poList;
    }

    private List<PoInfomationVO> findPoInfomation() {
        List<PoInfomationVO> poList = this.pcsPoPlanMapper.findPoInfomation();
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        }
        return poList;
    }

    @Override
    @Transactional
    public Boolean createPoPlanAndLine(PcsPoPlan pcsPoPlan, List<PcsPoPlanLine> pcsPoPlanLineList) throws Exception {
        if (pcsPoPlanLineList.size() == 0) {
            throw new PurchaseException("PC0001", "\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u8ba1\u5212\u884c\u4fe1\u606f");
        }
        if (EmptyUtil.isEmpty((Object)(pcsPoPlan = this.create(pcsPoPlan)).getId())) {
            throw new PurchaseException("PC0009", "\u8ba1\u5212\u5934\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + pcsPoPlan.toString());
        }
        for (PcsPoPlanLine line : pcsPoPlanLineList) {
            line.setPoPlanId(pcsPoPlan.getId());
            if (this.pcsPoPlanLineService.create(line).compareTo(0L) >= 1) continue;
            throw new PurchaseException("PC0009", "\u8ba1\u5212\u884c\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + line.toString());
        }
        WhCommand whCommand = this.bulidWhCommand(pcsPoPlan, pcsPoPlanLineList);
        pcsPoPlan.setWhCommandCode(this.facadeWhInner.createCommand(whCommand));
        if (!this.update(pcsPoPlan)) {
            throw new PurchaseException("PC0010", "\u8ba1\u5212\u5934\u4fe1\u606f\u66f4\u65b0\u5931\u8d25," + pcsPoPlan.toString());
        }
        PcsPurchaseOrder pcsPurchaseOrder = this.pcsPurchaseOrderService.findPoById(pcsPoPlan.getPoId());
        pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE);
        this.pcsPurchaseOrderService.update(pcsPurchaseOrder);
        return true;
    }

    @Override
    @Transactional
    public Boolean createPoPlanAndLineThenFinish(PcsPoPlan pcsPoPlan, List<PcsPoPlanLine> pcsPoPlanLineList) throws Exception {
        if (pcsPoPlanLineList.size() == 0) {
            throw new PurchaseException("PC0001", "\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u8ba1\u5212\u884c\u4fe1\u606f");
        }
        pcsPoPlan.setPlanedSendDate(DateUtil.getNow());
        pcsPoPlan.setPlanedReceiveDate(DateUtil.getNow());
        pcsPoPlan = this.create(pcsPoPlan);
        if (EmptyUtil.isEmpty((Object)pcsPoPlan.getId())) {
            throw new PurchaseException("PC0009", "\u8ba1\u5212\u5934\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + pcsPoPlan.toString());
        }
        for (PcsPoPlanLine line : pcsPoPlanLineList) {
            line.setPoPlanId(pcsPoPlan.getId());
            Integer quantity = line.getQuantity();
            Integer wasteQuantity = line.getWasteQuantity();
            if (this.pcsPoPlanLineService.create(line).compareTo(0L) < 1) {
                throw new PurchaseException("PC0009", "\u8ba1\u5212\u884c\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + line.toString());
            }
            line.setQuantity(quantity);
            line.setWasteQuantity(wasteQuantity);
            if (this.pcsPoPlanLineService.update(line)) continue;
            throw new PurchaseException("PC0009", "\u8ba1\u5212\u884c\u4fe1\u606f\u66f4\u65b0\u5931\u8d25," + line.toString());
        }
        WhCommand whCommandForCreate = this.bulidWhCommand(pcsPoPlan, pcsPoPlanLineList);
        pcsPoPlan.setWhCommandCode(this.facadeWhInner.createCommandThenFinish(whCommandForCreate));
        if (EmptyUtil.isEmpty((String)pcsPoPlan.getWhCommandCode())) {
            throw new PurchaseException("PC0010", "\u4ed3\u5e93\u6307\u4ee4\u751f\u6210\u5931\u8d25," + pcsPoPlan.toString());
        }
        pcsPoPlan.setReceiveDate(DateUtil.getNow());
        pcsPoPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_ALREADY_IN);
        if (!this.update(pcsPoPlan)) {
            throw new PurchaseException("PC0010", "\u8ba1\u5212\u5934\u4fe1\u606f\u66f4\u65b0\u5931\u8d25," + pcsPoPlan.toString());
        }
        return true;
    }

    @Override
    public List<PcsPoPlan> findPcsPoPlanByPoId(long poId) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andPoIdEqualTo(poId);
        List<PcsPoPlan> poList = this.pcsPoPlanMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        }
        return poList;
    }

    @Override
    @Transactional
    public Boolean synPoPlanAndLine(PcsPoPlan poPlan) {
        WhCommand whCommand = this.facadeWhInner.findCommandByCode(poPlan.getWhCommandCode(), true);
        if (EmptyUtil.isNotEmpty((Object)whCommand) && whCommand.getCommandStatus().equals(WhCommand.STATUS_FINISHED)) {
            List<PcsPoPlanLine> pcsPoPlanLineList = this.pcsPoPlanLineService.findPoPlanLineByPoPlanId(poPlan.getId());
            for (PcsPoPlanLine poPlanLine : pcsPoPlanLineList) {
                for (WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
                    if (!poPlanLine.getSkuCode().equals(whCommandSku.getSkuCode())) continue;
                    poPlanLine.setQuantity(whCommandSku.getQuantity());
                    poPlanLine.setWasteQuantity(whCommandSku.getDamagedQuantity());
                    this.pcsPoPlanLineService.update(poPlanLine);
                }
            }
            poPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_ALREADY_IN);
            poPlan.setReceiveDate(whCommand.getProcessTime());
            this.update(poPlan);
        }
        return true;
    }

    @Override
    public byte[] exportPoInfomation() {
        List<PoInfomationVO> poList = this.findPoInfomation();
        if (CollectionUtils.isEmpty(poList)) {
            throw new PurchaseException("PC0001", "\u6ca1\u6709\u76f8\u5173\u6570\u636e");
        }
        HashMap sheets = new HashMap();
        ArrayList allLines = new ArrayList();
        ArrayList<String> head = new ArrayList<String>();
        head.add("\u91c7\u8d2d\u5355\u7f16\u53f7");
        head.add("\u91c7\u8d2d\u5355\u72b6\u6001");
        head.add("\u4f9b\u5e94\u5546");
        head.add("\u76ee\u6807\u4ed3\u5e93");
        head.add("\u521b\u5efa\u65f6\u95f4");
        head.add("\u521b\u5efa\u4eba");
        head.add("\u5ba1\u6838\u65f6\u95f4");
        head.add("SKU");
        head.add("SKU\u540d");
        head.add("\u8981\u6c42\u4ea4\u8d27\u65e5\u671f");
        head.add("\u6570\u91cf");
        head.add("\u5355\u4ef7");
        head.add("\u603b\u4ef7");
        head.add("\u5b9e\u6536\u826f\u54c1");
        head.add("\u5b9e\u6536\u6b8b\u6b21");
        head.add("\u5f85\u6536\u6570\u91cf");
        allLines.add(head);
        for (PoInfomationVO vo : poList) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(vo.getPoCode());
            list.add(vo.getPurchaseOrderStatus());
            list.add(vo.getSuppName());
            list.add(vo.getHouseName());
            list.add(vo.getCreateTime());
            list.add(vo.getNickName());
            list.add(vo.getAuditTime());
            list.add(vo.getSkuCode());
            list.add(vo.getSkuName());
            list.add(vo.getAskDeliveryDate());
            list.add(vo.getQuantity());
            list.add(vo.getUnitPriceAfterTax());
            list.add(vo.getTotalPriceAfterTax());
            list.add(vo.getReceiveQuantity());
            list.add(vo.getWasteQuantity());
            list.add(vo.getWaitStockAmout());
            allLines.add(list);
        }
        sheets.put("\u91c7\u8d2d\u5355\u660e\u7ec6", allLines);
        new ExcelUtil();
        byte[] res = ExcelUtil.write(sheets, (boolean)true);
        return res;
    }

    @Override
    public byte[] exportPoPlanStatusWaitingIn() {
        List<PcsPoPlan> poPlans = this.findPoPlanByStatus(PcsPoPlan.PLAN_STATUS_WAITING_IN);
        if (CollectionUtils.isEmpty(poPlans)) {
            throw new PurchaseException("PC0001", "\u6ca1\u6709\u76f8\u5173\u6570\u636e");
        }
        HashMap sheets = new HashMap();
        ArrayList allLines = new ArrayList();
        ArrayList<String> head = new ArrayList<String>();
        head.add("\u91c7\u8d2d\u5355\u7f16\u53f7");
        head.add("\u521b\u5efa\u4eba");
        head.add("SKU");
        head.add("SKU\u540d");
        head.add("\u91c7\u8d2d\u5355\u6570\u91cf");
        head.add("\u6536\u8d27\u8ba1\u5212\u7f16\u53f7");
        head.add("\u6536\u8d27\u72b6\u6001");
        head.add("\u8ba1\u5212\u53d1\u8d27\u65e5\u671f");
        head.add("\u8ba1\u5212\u6536\u8d27\u65e5\u671f");
        head.add("\u5b9e\u9645\u6536\u8d27\u65e5\u671f");
        head.add("\u8ba1\u5212\u5165\u6570\u91cf");
        allLines.add(head);
        HashMap<Long, PcsPurchaseOrderVO> poVOMap = new HashMap<Long, PcsPurchaseOrderVO>();
        HashMap<Long, List<PcsPoLine>> poLinesMap = new HashMap<Long, List<PcsPoLine>>();
        HashMap<Long, String> poAuditUserNameMap = new HashMap<Long, String>();
        for (PcsPoPlan poPlan : poPlans) {
            if (!poVOMap.containsKey(poPlan.getPoId())) {
                PcsPurchaseOrderVO poVO = this.pcsPurchaseOrderService.findPoVOById(poPlan.getPoId());
                poVOMap.put(poPlan.getPoId(), poVO);
            }
            if (!poLinesMap.containsKey(poPlan.getPoId())) {
                List<PcsPoLine> poLines = this.pcsPoLineService.findPoLineByPoId(poPlan.getPoId());
                poLinesMap.put(poPlan.getPoId(), poLines);
            }
            if (poAuditUserNameMap.containsKey(poPlan.getPoId())) continue;
            List commEntityOpRcds = PegasusUtilFacade.getInstance().findEntityOpRcdByClazzAndId("PcsPurchaseOrder", poPlan.getPoId().toString());
            poAuditUserNameMap.put(poPlan.getPoId(), "");
            for (CommEntityOpRcd commEntityOpRcd : commEntityOpRcds) {
                if (!commEntityOpRcd.getOperationDesc().equals("\u5ba1\u6838\u901a\u8fc7\u91c7\u8d2d\u5355")) continue;
                poAuditUserNameMap.put(poPlan.getPoId(), commEntityOpRcd.getOperatorName());
            }
        }
        HashMap<String, Integer> skuPoPlan = new HashMap<String, Integer>();
        for (PcsPoPlan poPlan : poPlans) {
            List<PcsPoPlanLineVO> poPlanLineVOs = this.pcsPoPlanLineService.findPoPlanLineVOByPoPlanId(poPlan.getId());
            PcsPurchaseOrderVO poVO = (PcsPurchaseOrderVO)poVOMap.get(poPlan.getPoId());
            List poLines = (List)poLinesMap.get(poPlan.getPoId());
            String poAuditUserName = (String)poAuditUserNameMap.get(poPlan.getPoId());
            for (PcsPoPlanLineVO poPlanLineVO : poPlanLineVOs) {
                String skuCode;
                skuPoPlan.put(skuCode, (skuPoPlan.get(skuCode = poPlanLineVO.getSkuCode()) == null ? 0 : (Integer)skuPoPlan.get(skuCode)) + 1);
                ArrayList<String> line = new ArrayList<String>();
                line.add(poVO.getCode());
                line.add(poVO.getCreateOperatorName());
                line.add(poPlanLineVO.getSkuCode());
                line.add(poPlanLineVO.getSkuNameCn());
                line.add(poPlanLineVO.getQuantity() + "");
                line.add(poPlan.getCode());
                line.add("\u5f85\u5165\u5e93");
                line.add(DateUtil.format((Date)poPlan.getPlanedSendDate(), (String)"yyyy-MM-dd"));
                line.add(DateUtil.format((Date)poPlan.getPlanedReceiveDate(), (String)"yyyy-MM-dd"));
                line.add(DateUtil.format((Date)poPlan.getReceiveDate(), (String)"yyyy-MM-dd"));
                line.add(poPlanLineVO.getPlanedQuantity().toString());
                allLines.add(line);
            }
        }
        sheets.put("\u6536\u8d27\u8ba1\u5212-\u5f85\u5165\u5e93", allLines);
        new ExcelUtil();
        byte[] res = ExcelUtil.write(sheets, (boolean)true);
        return res;
    }

    public Boolean check(Object obj) {
        PcsPoPlan record = (PcsPoPlan)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(PcsPoPlan record, Boolean isCreate) {
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getPoId())) {
            throw new PurchaseException("PC0001", "\u91c7\u8d2d\u5355ID\u4e3a\u7a7a");
        }
        if (isCreate.booleanValue() && EmptyUtil.isEmpty((Object)this.pcsPurchaseOrderService.findPoById(record.getPoId()))) {
            throw new PurchaseException("PC0001", "\u91c7\u8d2d\u5355ID\u6570\u636e\u5e93\u4e0d\u5b58\u5728");
        }
        return true;
    }

    private Boolean check(String code) {
        return NullUtil.isNull((Object)this.findPoPlanByCode(code));
    }

    public String generateCode(Object id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        String code = CodeGenerator.getInstance().generate("PCS_PO_PLAN", params);
        return code;
    }

    @Override
    public boolean updatePoPlan(PcsPoPlan po) {
        int rs = 0;
        rs = this.pcsPoPlanMapper.updateByPrimaryKeySelective(po);
        return rs > 0;
    }

    @Override
    public boolean updatePoPlanLine(PcsPoPlanLine line) {
        return this.pcsPoPlanLineMapper.updateByPrimaryKeySelective(line) != 0;
    }

    @Override
    public boolean isAllPoPlanFinished(Long poId) {
        int result = this.pcsPoPlanMapper.isAllPoPlanFinished(poId);
        return result == 0;
    }

    @Override
    public boolean isAllReceivePo(Long poId) {
        int result = this.pcsPoPlanMapper.isAllReceivePo(poId);
        return result == 0;
    }

    @Override
    public Boolean closePoPlanByPlanId(Long poPlandId) {
        PcsPoPlan pcsPoPlan = this.pcsPoPlanMapper.selectByPrimaryKey(poPlandId);
        if (pcsPoPlan != null && pcsPoPlan.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_WAITING_RECEIVE)) {
            PcsPurchaseOrder pcsPurchaseOrder;
            pcsPoPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_CLOSED);
            this.pcsPoPlanMapper.updateByPrimaryKey(pcsPoPlan);
            this.facadeWhInner.colseCommandByReferenceCode(WhCommand.TYPE_PURCHASE_IN.intValue(), pcsPoPlan.getCode());
            List<PcsPoPlan> pcsPoPlanList = this.findPcsPoPlanByPoId(pcsPoPlan.getPoId());
            boolean isUpdate = true;
            for (PcsPoPlan pcsPoPlan1 : pcsPoPlanList) {
                if (!pcsPoPlan1.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_WAITING_IN) && !pcsPoPlan1.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_WAITING_RECEIVE) && !pcsPoPlan1.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_WAITING)) continue;
                isUpdate = false;
                break;
            }
            if (isUpdate && !(pcsPurchaseOrder = this.pcsPurchaseOrderService.findPoById(pcsPoPlan.getPoId())).getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE)) {
                pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                this.pcsPurchaseOrderService.update(pcsPurchaseOrder);
            }
        } else {
            throw new RuntimeException("\u6536\u8d27\u8ba1\u5212\u4e0d\u5b58\u5728\u6216\u6536\u8d27\u8ba1\u5212\u4e0d\u662f\u5f85\u6536\u8d27\u72b6\u6001");
        }
        return true;
    }

    @Override
    @Transactional
    public int createPoPlanFee(PcsPoPlanCost pcsPoPlanCost) {
        pcsPoPlanCost.setTotalPrice(pcsPoPlanCost.getUnitPrice().multiply(new BigDecimal(pcsPoPlanCost.getQuantity())));
        pcsPoPlanCost.setAvailable((byte)1);
        this.updatePoTotalAmount(pcsPoPlanCost, 0);
        return this.pcsPoPlanCostMapper.insertSelective(pcsPoPlanCost);
    }

    @Override
    public List<PcsPoPlanCost> selectCostByPoPlanId(Integer poPlanId) {
        return this.pcsPoPlanCostMapper.selectCostByPoPlanId(poPlanId);
    }

    @Override
    public int updatePoTotalAmount(PcsPoPlanCost pcsPoPlanCost, int optType) {
        PcsPurchaseOrder pcsPurchaseOrder = this.pcsPurchaseOrderService.findPoById(this.pcsPoPlanMapper.selectByPrimaryKey(pcsPoPlanCost.getPoPlanId().longValue()).getPoId());
        if (optType == 0) {
            pcsPurchaseOrder.setTotalAmount(pcsPurchaseOrder.getTotalAmount().add(pcsPoPlanCost.getTotalPrice()));
            pcsPurchaseOrder.setTotalAmountAfterTax(pcsPurchaseOrder.getTotalAmountAfterTax().add(pcsPoPlanCost.getTotalPrice()));
        } else {
            pcsPurchaseOrder.setTotalAmount(pcsPurchaseOrder.getTotalAmount().subtract(pcsPoPlanCost.getTotalPrice()));
            pcsPurchaseOrder.setTotalAmountAfterTax(pcsPurchaseOrder.getTotalAmountAfterTax().subtract(pcsPoPlanCost.getTotalPrice()));
        }
        if (EmptyUtil.isNotEmpty((Object)pcsPurchaseOrder.getCrossBorderFlag()) && pcsPurchaseOrder.getCrossBorderFlag() == 1) {
            return this.pcsPurchaseOrderService.update(pcsPurchaseOrder) ? 1 : 0;
        }
        return 1;
    }

    @Override
    public int updatePoPlanFee(PcsPoPlanCost pcsPoPlanCost, int optType) {
        if (optType == 1) {
            PcsPoPlanCost oldPcsPoPlanCost = this.pcsPoPlanCostMapper.selectByPrimaryKey(pcsPoPlanCost.getId());
            this.updatePoTotalAmount(oldPcsPoPlanCost, 1);
        }
        return this.pcsPoPlanCostMapper.updateByPrimaryKeySelective(pcsPoPlanCost);
    }
}

