/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanLineMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLineExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLineVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsPoPlanLineService")
public class PcsPoPlanLineServiceImpl
implements PcsPoPlanLineService,
CheckAble {
    private final Logger log = LoggerFactory.getLogger(PcsPoPlanLineServiceImpl.class);
    @Autowired
    private PcsPoPlanLineMapper pcsPoPlanLineMapper;
    @Autowired
    private PcsSkuService pcsSkuService;

    @Override
    public PcsPoPlanLine buildFromVO(PcsPoPlanLineVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsPoPlanLine record = new PcsPoPlanLine();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    public PcsPoPlanLineVO buildFromModel(PcsPoPlanLine record) {
        if (NullUtil.isNull((Object)record)) {
            return null;
        }
        PcsPoPlanLineVO vo = new PcsPoPlanLineVO();
        BeanUtils.copyProperties((Object)record, (Object)vo);
        return vo;
    }

    @Override
    @Transactional
    public Long create(PcsPoPlanLine record) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            record.setQuantity(0);
            record.setWasteQuantity(0);
            this.pcsPoPlanLineMapper.insertSelective(record);
            return record.getId();
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsPoPlanLine record) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            return this.pcsPoPlanLineMapper.updateByPrimaryKeySelective(record) != 0;
        }
        return false;
    }

    @Override
    public List<PcsPoPlanLine> findPoPlanLineByPoPlanId(long poPlanId) {
        PcsPoPlanLineExample example = new PcsPoPlanLineExample();
        example.createCriteria().andPoPlanIdEqualTo(poPlanId);
        List<PcsPoPlanLine> list = this.pcsPoPlanLineMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public List<PcsPoPlanLineVO> findPoPlanLineVOByPoPlanId(long poPlanId) {
        List<PcsPoPlanLineVO> list = this.pcsPoPlanLineMapper.findPoPlanLineVOByPoPlanId(poPlanId);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list;
    }

    public Boolean check(Object obj) {
        PcsPoPlanLine record = (PcsPoPlanLine)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(PcsPoPlanLine record, Boolean isCreate) {
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getPlanedQuantity())) {
            throw new PurchaseException("PC0001", "\u8ba1\u5212\u6570\u91cf\u4e3a\u7a7a");
        }
        if (isCreate.booleanValue() && EmptyUtil.isEmpty((String)record.getSkuCode())) {
            throw new PurchaseException("PC0001", "skuCode\u4e3a\u7a7a");
        }
        if (isCreate.booleanValue() && EmptyUtil.isEmpty((Object)this.pcsSkuService.findByCode(record.getSkuCode()))) {
            throw new PurchaseException("PC0001", "skuCode\u6570\u636e\u5e93\u4e0d\u5b58\u5728");
        }
        return true;
    }
}

