/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PcsPoLineMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoLineExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLineService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoLineVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsPoLineService")
public class PcsPoLineServiceImpl
implements PcsPoLineService,
CheckAble {
    private final Logger log = LoggerFactory.getLogger(PcsPoLineServiceImpl.class);
    @Autowired
    private PcsPoLineMapper pcsPoLineMapper;

    public Boolean check(Object obj) {
        PcsPoLine record = (PcsPoLine)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(PcsPoLine record, Boolean isCreate) {
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    @Override
    public PcsPoLine buildFromVO(PcsPoLineVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsPoLine record = new PcsPoLine();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    public PcsPoLineVO buildFromModel(PcsPoLine record) {
        if (NullUtil.isNull((Object)record)) {
            return null;
        }
        PcsPoLineVO vo = new PcsPoLineVO();
        BeanUtils.copyProperties((Object)record, (Object)vo);
        return vo;
    }

    @Override
    @Transactional
    public Long create(PcsPoLine record) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            this.pcsPoLineMapper.insertSelective(record);
            return record.getId();
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsPoLine record) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            return this.pcsPoLineMapper.updateByPrimaryKeySelective(record) != 0;
        }
        return false;
    }

    @Override
    public PcsPoLine findPoLineById(long id) {
        return this.pcsPoLineMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsPoLine> findPoLineByPoId(long poId) {
        PcsPoLineExample example = new PcsPoLineExample();
        example.createCriteria().andPoIdEqualTo(poId);
        List<PcsPoLine> poLineList = this.pcsPoLineMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poLineList)) {
            return Collections.emptyList();
        }
        return poLineList;
    }

    @Override
    public List<PcsPoLineVO> findPoLineVOByPoId(long poId) {
        List<PcsPoLineVO> vos = this.pcsPoLineMapper.findPoLineVOByPoId(poId);
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        }
        return vos;
    }

    @Override
    @Transactional
    public Boolean deleteById(long id) {
        PcsPoLine record = this.findPoLineById(id);
        if (EmptyUtil.isNotEmpty((Object)record)) {
            return this.pcsPoLineMapper.deleteByPrimaryKey(id) != 0;
        }
        return false;
    }

    @Override
    public List<PcsPoLineVO> findPoSkuByPoId(long poId) {
        List<PcsPoLineVO> vos = this.pcsPoLineMapper.findPoSkuByPoId(poId);
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        }
        return vos;
    }
}

