/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.service.purchase.cond.PcsBrandCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseOrderCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSupplierCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.model.PcsSku;
import com.thebeastshop.pegasus.service.purchase.service.PcsBrandService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCronService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSupplierService;
import com.thebeastshop.pegasus.service.purchase.vo.UserInfo;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service(value="pcsCronService")
public class PcsCronServiceImpl
implements PcsCronService {
    private final Logger log = LoggerFactory.getLogger(PcsCronServiceImpl.class);
    @Autowired
    private PcsPoPlanService pcsPoPlanService;
    @Autowired
    private PcsSkuService pcsSkuService;
    @Autowired
    private PcsSupplierService pcsSupplierService;
    @Autowired
    private PcsPurchaseOrderService pcsPurchaseOrderService;
    @Autowired
    private PcsBrandService pcsBrandService;
    @Autowired
    private TaskExecutor scheduler;

    @Override
    public void cronSynPoPlanAndLine() {
        List<PcsPoPlan> poPlanList = this.pcsPoPlanService.findPoPlanByStatus(PcsPoPlan.PLAN_STATUS_WAITING_IN);
        if (CollectionUtils.isNotEmpty(poPlanList)) {
            for (PcsPoPlan poPlan : poPlanList) {
                try {
                    this.pcsPoPlanService.synPoPlanAndLine(poPlan);
                }
                catch (Exception e) {
                    this.log.error("", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void cronSendApprovalEmail() {
        PcsSkuCond cond = new PcsSkuCond();
        cond.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
        long skuQuantity = this.pcsSkuService.countSkuByCond(cond);
        PcsSupplierCond pcsSupplierCond = new PcsSupplierCond();
        pcsSupplierCond.setSupplierOrderStatus(2);
        long financeSupplierQuantity = this.pcsSupplierService.countByCond(pcsSupplierCond);
        String emailContent = "\u60a8\u6709";
        if (financeSupplierQuantity != 0L || skuQuantity != 0L) {
            if (skuQuantity != 0L) {
                emailContent = emailContent + skuQuantity + "\u4e2aSKU";
            }
            if (financeSupplierQuantity != 0L) {
                if (skuQuantity != 0L) {
                    emailContent = emailContent + "\u3001";
                }
                emailContent = emailContent + financeSupplierQuantity + "\u4e2a\u4f9b\u5e94\u5546";
            }
            emailContent = emailContent + "\u9700\u8981\u5ba1\u6279\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\u3002</br>\u53bb\u5ba1\u6279\uff1ahttp://scm.thebeastshop.com";
            this.sendNotice("finance.Approval.Email", null, emailContent);
        }
        PcsPurchaseOrderCond pcsPurchaseOrderCond = new PcsPurchaseOrderCond();
        pcsPurchaseOrderCond.setPoStatus(2);
        long pcsPurchaseOrderQuantity = this.pcsPurchaseOrderService.countByCond(pcsPurchaseOrderCond);
        emailContent = "\u60a8\u6709" + pcsPurchaseOrderQuantity + "\u4e2a\u91c7\u8d2d\u5355\u9700\u8981\u5ba1\u6279\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\u3002</br>\u53bb\u5ba1\u6279\uff1ahttp://scm.thebeastshop.com";
        if (pcsPurchaseOrderQuantity != 0L) {
            this.sendNotice("planner.Approval.Email", null, emailContent);
        }
        PcsBrandCond pcsBrandCond = new PcsBrandCond();
        pcsBrandCond.setBrandStatus(2);
        long pcsBrandQuantity = this.pcsBrandService.countByCond(pcsBrandCond);
        emailContent = "\u60a8\u6709" + pcsBrandQuantity + "\u4e2a\u54c1\u724c\u9700\u8981\u5ba1\u6279\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\u3002</br>\u53bb\u5ba1\u6279\uff1ahttp://scm.thebeastshop.com";
        if (pcsBrandQuantity != 0L) {
            this.sendNotice("legal.Approval.Email", null, emailContent);
        }
        HashMap<Long, String> categoryManagerMap = new HashMap<Long, String>();
        CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.71");
        categoryManagerMap.put(71L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
        commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.351");
        categoryManagerMap.put(351L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
        commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.360");
        categoryManagerMap.put(360L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
        commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.345");
        categoryManagerMap.put(345L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
        commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.262");
        categoryManagerMap.put(262L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
        for (Map.Entry entry : categoryManagerMap.entrySet()) {
            pcsSupplierCond.setCategoryManager((Long)entry.getKey());
            pcsSupplierCond.setSupplierOrderStatus(1);
            long supplierQuantity = this.pcsSupplierService.countByCond(pcsSupplierCond);
            pcsBrandCond.setCategoryManager((Long)entry.getKey());
            pcsBrandCond.setBrandStatus(1);
            pcsBrandQuantity = this.pcsBrandService.countByCond(pcsBrandCond);
            emailContent = "\u60a8\u6709";
            UserInfo userInfo = new UserInfo();
            userInfo.setEmail((String)entry.getValue());
            if (pcsBrandQuantity == 0L && supplierQuantity == 0L) continue;
            if (supplierQuantity != 0L) {
                emailContent = emailContent + supplierQuantity + "\u4e2a\u4f9b\u5e94\u5546";
            }
            if (pcsBrandQuantity != 0L) {
                if (supplierQuantity != 0L) {
                    emailContent = emailContent + "\u3001";
                }
                emailContent = emailContent + pcsBrandQuantity + "\u4e2a\u54c1\u724c";
            }
            emailContent = emailContent + "\u9700\u8981\u5ba1\u6279\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\u3002</br>\u53bb\u5ba1\u6279\uff1ahttp://scm.thebeastshop.com";
            this.sendNotice("", userInfo, emailContent);
        }
    }

    private void sendNotice(final String configKey, final UserInfo userInfo, final String content) {
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey(configKey);
                    System.out.println(configKey);
                    String[] toNotifyUsers = new String[]{};
                    if (EmptyUtil.isNotEmpty((Object)commGlobalConfig)) {
                        toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
                    }
                    EmailVO emailVO = new EmailVO();
                    if (userInfo != null) {
                        String[] categoryManager = userInfo.getEmail().split(",");
                        emailVO.setToAddressList(Arrays.asList(categoryManager));
                    } else {
                        emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
                    }
                    emailVO.setSubject("\u5ba1\u6279\u63d0\u9192");
                    emailVO.setContent(content);
                    if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList())) {
                        EmailUtil.getInstance().send(emailVO);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

