/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.cond.PcsBuyerCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsBuyerInfoMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PcsBuyerInfo;
import com.thebeastshop.pegasus.service.purchase.model.PcsBuyerInfoExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsBuyerInfoService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsBuyerInfoVO;
import com.thebeastshop.pegasus.service.purchase.vo.UserInfo;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pcsBuyerInfoService")
public class PcsBuyerInfoServiceImpl
implements PcsBuyerInfoService {
    @Autowired
    private PcsBuyerInfoMapper pcsBuyerInfoMapper;

    @Override
    public PcsBuyerInfoVO getBuyerInfoById(Long id) {
        PcsBuyerInfo buyerInfo = this.pcsBuyerInfoMapper.selectByPrimaryKey(id);
        return (PcsBuyerInfoVO)BeanUtil.buildFrom((Object)buyerInfo, PcsBuyerInfoVO.class);
    }

    @Override
    public List<PcsBuyerInfoVO> getAllBuyers() {
        PcsBuyerInfoExample example = new PcsBuyerInfoExample();
        example.createCriteria().getAllCriteria();
        List<PcsBuyerInfo> buyerInfoVOs = this.pcsBuyerInfoMapper.selectByExample(example);
        return BeanUtil.buildListFrom(buyerInfoVOs, PcsBuyerInfoVO.class);
    }

    @Override
    public List<Map<String, String>> getAllBuyerInfos() {
        List<PcsBuyerInfoVO> buyers = this.getAllBuyers();
        ArrayList<Map<String, String>> buyerInfos = new ArrayList<Map<String, String>>();
        for (PcsBuyerInfo pcsBuyerInfo : buyers) {
            HashMap<String, String> buyerInfoMap = new HashMap<String, String>();
            buyerInfoMap.put("value", pcsBuyerInfo.getId().toString());
            buyerInfoMap.put("text", pcsBuyerInfo.getRealName());
            buyerInfoMap.put("loginUserId", String.valueOf(pcsBuyerInfo.getLoginUserId()));
            buyerInfos.add(buyerInfoMap);
        }
        if (CollectionUtils.isEmpty(buyerInfos)) {
            return Collections.EMPTY_LIST;
        }
        return buyerInfos;
    }

    @Override
    public List<PcsBuyerInfoVO> getBuyerByCond(PcsBuyerCond cond) {
        return this.pcsBuyerInfoMapper.getBuyerInfoByCond(cond);
    }

    @Override
    public Boolean newBuyer(PcsBuyerInfo buyerInfo) {
        if (this.pcsBuyerInfoMapper.insertSelective(buyerInfo) > 0) {
            return true;
        }
        throw new PurchaseException("PC0011", "\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public Boolean updateBuyerInfo(PcsBuyerInfo buyer) {
        if (this.pcsBuyerInfoMapper.updateByPrimaryKeySelective(buyer) > 0) {
            return true;
        }
        throw new PurchaseException("PC0011", "\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public UserInfo findCategoryManagerByBuyer(Integer buyerId) {
        return this.pcsBuyerInfoMapper.selectCategoryManagerByBuyer(buyerId);
    }
}

