/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.integration.sms.SmsUtil;
import com.thebeastshop.pegasus.integration.sms.SmsVO;
import com.thebeastshop.pegasus.service.purchase.cond.PcsBrandCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsBrandMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PcsBrand;
import com.thebeastshop.pegasus.service.purchase.model.PcsBrandExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsBrandService;
import com.thebeastshop.pegasus.service.purchase.service.PcsBuyerInfoService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsBrandVO;
import com.thebeastshop.pegasus.service.purchase.vo.UserInfo;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsBrandService")
public class PcsBrandServiceImpl
implements PcsBrandService,
CheckAble {
    private final Logger log = LoggerFactory.getLogger(PcsBrandServiceImpl.class);
    @Autowired
    private PcsBrandMapper pcsBrandMapper;
    @Autowired
    private PcsBuyerInfoService pcsBuyerInfoService;

    @Override
    public PcsBrandVO buildFromModel(PcsBrand record) {
        if (NullUtil.isNull((Object)record)) {
            return null;
        }
        PcsBrandVO vo = new PcsBrandVO();
        BeanUtils.copyProperties((Object)record, (Object)vo);
        return vo;
    }

    @Override
    public PcsBrand bulidFromVO(PcsBrandVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsBrand record = new PcsBrand();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    @Transactional
    public Long create(PcsBrand record, boolean saveDraft) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            record.setCreateTime(new Date());
            this.pcsBrandMapper.insertSelective(record);
            if (!saveDraft) {
                // empty if block
            }
            return record.getId();
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsBrand record, boolean saveDraft) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            return this.pcsBrandMapper.updateByPrimaryKeySelective(record) != 0;
        }
        return false;
    }

    private void sendNotice(String code, UserInfo userInfo) {
        SmsUtil smsUtil = SmsUtil.getInstance();
        SmsVO smsVO = new SmsVO();
        smsVO.setSendTime(new Date());
        CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("legal.Approval.Mobile");
        String[] toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        if (userInfo != null) {
            String[] categoryManager = new String[]{userInfo.getMobile()};
            smsVO.setMobileList(Arrays.asList(categoryManager));
        } else {
            smsVO.setMobileList(Arrays.asList(toNotifyUsers));
        }
        smsVO.setContent("\u60a8\u597d\uff0c\u60a8\u6709\u65b0\u7684\u54c1\u724c\u9700\u8981\u5ba1\u6279\uff0c\u54c1\u724c\uff1a" + code + "\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\uff0c\u8c22\u8c22\uff01");
        smsUtil.send(smsVO);
        commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("legal.Approval.Email");
        toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        EmailVO emailVO = new EmailVO();
        if (userInfo != null) {
            String[] categoryManager = new String[]{userInfo.getEmail()};
            emailVO.setToAddressList(Arrays.asList(categoryManager));
        } else {
            emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
        }
        emailVO.setSubject("\u54c1\u724c\u5ba1\u6279");
        emailVO.setContent("\u60a8\u597d\uff0c\u60a8\u6709\u65b0\u7684\u54c1\u724c\u9700\u8981\u5ba1\u6279\uff0c\u54c1\u724c\uff1a" + code + "\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\uff0c\u8c22\u8c22\uff01");
        if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList())) {
            EmailUtil.getInstance().send(emailVO);
        }
    }

    @Override
    public PcsBrand findById(long id) {
        if (EmptyUtil.isEmpty((Object)id)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return this.pcsBrandMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsBrandVO> findByCond(PcsBrandCond cond) {
        List<PcsBrandVO> recordList = this.pcsBrandMapper.findByCond(cond);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsBrand> findByName(String name) {
        PcsBrandExample example = new PcsBrandExample();
        example.createCriteria().andNameCnLike(SQLUtils.allLike((String)name));
        example.or().andNameLike(SQLUtils.allLike((String)name));
        example.setOrderByClause("ID LIMIT 20 ");
        List<PcsBrand> recordList = this.pcsBrandMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsBrand> findByIds(List<Long> ids) {
        ArrayList<PcsBrand> recordList = new ArrayList<PcsBrand>();
        for (long id : ids) {
            PcsBrand record = this.findById(id);
            if (!EmptyUtil.isNotEmpty((Object)record) || !EmptyUtil.isNotEmpty((Object)record.getId())) continue;
            recordList.add(record);
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    public Boolean check(Object obj) {
        PcsBrand record = (PcsBrand)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(PcsBrand record, Boolean isCreate) {
        PcsBrand oldRecord;
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PcsBrandExample example1 = new PcsBrandExample();
        PcsBrandExample example2 = new PcsBrandExample();
        example1.createCriteria().andNameEqualTo(record.getName());
        example2.createCriteria().andNameCnEqualTo(record.getNameCn());
        List<PcsBrand> oldList = null;
        oldList = this.pcsBrandMapper.selectByExample(example1);
        if (oldList.size() > 0 && isCreate.booleanValue()) {
            throw new PurchaseException("PC0005", "name\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        if (oldList.size() > 0 && !isCreate.booleanValue() && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException("PC0005", "name\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        oldList = this.pcsBrandMapper.selectByExample(example2);
        if (oldList.size() > 0 && isCreate.booleanValue()) {
            throw new PurchaseException("PC0005", "nameCn\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        if (oldList.size() > 0 && !isCreate.booleanValue() && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException("PC0005", "nameCn\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        if (!isCreate.booleanValue() && NullUtil.isNotNull((Object)(oldRecord = this.pcsBrandMapper.selectByPrimaryKey(record.getId()))) && EmptyUtil.isNotEmpty((Object)oldRecord.getFileId()) && EmptyUtil.isNotEmpty((Object)record.getFileId()) && !oldRecord.getFileId().equals(record.getFileId())) {
            PegasusUtilFacade.getInstance().deleteFileById((long)oldRecord.getFileId().intValue());
        }
        return true;
    }

    @Override
    public Boolean auditBrand(Long userId, long id, Boolean isPass, Integer type) {
        PcsBrand record = this.pcsBrandMapper.selectByPrimaryKey(id);
        record.setLastModifier(userId);
        if (isPass.booleanValue()) {
            if (type == 1) {
                record.setBrandStatus(3);
            } else {
                record.setBrandStatus(2);
            }
        } else {
            record.setBrandStatus(-1);
        }
        return this.pcsBrandMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    public long countByCond(PcsBrandCond cond) {
        return this.pcsBrandMapper.countByCond(cond);
    }
}

