/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.flower.service.impl;

import com.thebeastshop.pegasus.service.purchase.flower.dao.FpcsPurchaseOrderMapper;
import com.thebeastshop.pegasus.service.purchase.flower.model.FpcsOrderListForm;
import com.thebeastshop.pegasus.service.purchase.flower.model.FpcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.flower.service.FpcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.model.FpcsSkuOrder;
import com.thebeastshop.pegasus.service.purchase.service.FpcsSkuService;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="fpcsPurchaseOrderService")
public class FpcsPurchaseOrderServiceImpl
implements FpcsPurchaseOrderService,
CheckAble,
CodeAble {
    @Autowired
    private FpcsPurchaseOrderMapper fpcsPurchaseOrderMapper;
    @Autowired
    private FpcsSkuService fpcsSkuServiceImpl;

    @Override
    public List<FpcsPurchaseOrder> select(FpcsPurchaseOrder example) {
        String channelCode = example.getChannelCode();
        String[] channelArray = null;
        if (StringUtils.isNotBlank((String)channelCode)) {
            channelArray = channelCode.split(",");
        }
        return this.fpcsPurchaseOrderMapper.select(example, channelArray);
    }

    @Override
    public void acceptOrder(FpcsPurchaseOrder example) {
        String channelCode = example.getChannelCode();
        String[] channelArray = null;
        if (StringUtils.isNotBlank((String)channelCode)) {
            channelArray = channelCode.split(",");
        }
        List<FpcsPurchaseOrder> orderList = this.fpcsPurchaseOrderMapper.select(example, channelArray);
        String purTime = String.valueOf(new Date().getTime());
        for (FpcsPurchaseOrder fpcsPurchaseOrder : orderList) {
            if (fpcsPurchaseOrder.getAcceptanceNo() != null) continue;
            fpcsPurchaseOrder.setAcceptanceNo(purTime);
            fpcsPurchaseOrder.setProcessState((short)1);
            this.fpcsPurchaseOrderMapper.updateByPrimaryKeySelective(fpcsPurchaseOrder);
        }
    }

    public String generateCode(Object arg0) {
        return null;
    }

    public Boolean check(Object obj) {
        return null;
    }

    @Override
    public int sumitOrder(FpcsOrderListForm example) {
        int resultFlag = 1;
        List<FpcsPurchaseOrder> orderList = example.getFpcsPurchaseOrderList();
        Set<String> channelList = example.getChannelList();
        Iterator<String> it = channelList.iterator();
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, 1);
        date = calendar.getTime();
        if (example.getPurchaseTime() == null) {
            example.setPurchaseTime(date);
        }
        String channel = "";
        while (it.hasNext()) {
            channel = it.next();
        }
        if (example.getType() == 1) {
            for (FpcsPurchaseOrder order : orderList) {
                if (order.getDemand() == null || order.getDemand() <= 0) continue;
                FpcsSkuOrder pcsSku = this.fpcsSkuServiceImpl.findSkuById(order.getId());
                order.setCategory(pcsSku.getSkuType());
                order.setSkuCode(pcsSku.getSkuCode());
                order.setSkuName(pcsSku.getSkuName());
                order.setSkuUnit(pcsSku.getSkuUnit());
                order.setPurchaseUnit(pcsSku.getPurchaseUnit());
                order.setPurchaseUnitNumber(pcsSku.getPurchaseUnitNumber());
                order.setId(null);
                order.setChannelCode(channel);
                order.setProcessState((short)0);
                order.setPurchaseTime(example.getPurchaseTime());
                this.fpcsPurchaseOrderMapper.insert(order);
            }
        } else {
            for (FpcsPurchaseOrder order : orderList) {
                if (order.getId() == null) continue;
                FpcsPurchaseOrder oldOrder = this.fpcsPurchaseOrderMapper.selectByPrimaryKey(order.getId());
                if (oldOrder != null && oldOrder.getProcessState() == 1) {
                    resultFlag = 0;
                    return resultFlag;
                }
                this.fpcsPurchaseOrderMapper.updateByPrimaryKeySelective(order);
            }
        }
        return resultFlag;
    }

    @Override
    public List<FpcsPurchaseOrder> getPurchaseOrderList(FpcsPurchaseOrder example) {
        String channelCode = example.getChannelCode();
        String[] channelArray = null;
        if (StringUtils.isNotBlank((String)channelCode)) {
            channelArray = channelCode.split(",");
        }
        return this.fpcsPurchaseOrderMapper.findPurchaseOrderList(example, channelArray);
    }

    @Override
    public Map<String, Object> getDetailPurchaseOrder(long id) {
        FpcsPurchaseOrder fpcsPurchaseOrder = this.fpcsPurchaseOrderMapper.selectByPrimaryKey(id);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("flowerShopsList", this.fpcsPurchaseOrderMapper.findDetailPurchaseOrder(fpcsPurchaseOrder.getPurchaseTime(), fpcsPurchaseOrder.getAcceptanceNo(), fpcsPurchaseOrder.getSkuCode()));
        resultMap.put("purchaseTime", DateUtil.format((Date)fpcsPurchaseOrder.getPurchaseTime(), (String)"yyyy-MM-dd"));
        resultMap.put("skuCode", fpcsPurchaseOrder.getSkuCode());
        return resultMap;
    }

    @Override
    public Map<String, List<List<String>>> exportPurchaseOrder(FpcsPurchaseOrder example) {
        String channelCode = example.getChannelCode();
        String[] channelArray = null;
        if (StringUtils.isNotBlank((String)channelCode)) {
            channelArray = channelCode.split(",");
        }
        List<FpcsPurchaseOrder> storeList = this.fpcsPurchaseOrderMapper.findStoreInfo(example, channelArray);
        ArrayList allLines = new ArrayList();
        ArrayList<String> head = new ArrayList<String>();
        head.add("\u91c7\u8d2d\u65f6\u95f4");
        head.add("SKU");
        head.add("\u5355\u4f4d");
        head.add("\u4ef7\u683c");
        head.add("\u4f9b\u5e94\u5546");
        ArrayList storeAllLines = new ArrayList();
        ArrayList<String> storeHead = new ArrayList<String>();
        storeHead.add("\u95e8\u5e97");
        storeHead.add("\u6e20\u9053\u7f16\u53f7");
        storeHead.add("\u6e20\u9053\u4ed3\u5e93\u53f7");
        storeAllLines.add(storeHead);
        for (FpcsPurchaseOrder store : storeList) {
            ArrayList<String> line = new ArrayList<String>();
            line.add(store.getStoreName());
            line.add(store.getChannelCode());
            line.add(store.getWarehouserForSales());
            storeAllLines.add(line);
            head.add(store.getStoreName());
        }
        head.add("\u5408\u8ba1");
        allLines.add(head);
        List<FpcsPurchaseOrder> purchaseOrderList = this.fpcsPurchaseOrderMapper.findPurchaseOrderList(example, channelArray);
        for (FpcsPurchaseOrder order : purchaseOrderList) {
            ArrayList<String> line = new ArrayList<String>();
            line.add(DateUtil.format((Date)order.getPurchaseTime(), (String)"yyyy/MM/dd"));
            line.add(order.getSkuCode() + "/" + order.getSkuName());
            line.add(order.getSkuUnit());
            line.add(String.valueOf(order.getTheUnitPrice() == null ? "" : order.getTheUnitPrice()));
            line.add(order.getSupplier());
            List<FpcsPurchaseOrder> detailPurchaseOrderList = this.fpcsPurchaseOrderMapper.findDetailPurchaseOrder(order.getPurchaseTime(), order.getAcceptanceNo(), order.getSkuCode());
            for (FpcsPurchaseOrder store : storeList) {
                FpcsPurchaseOrder lastOrder = null;
                for (FpcsPurchaseOrder detail : detailPurchaseOrderList) {
                    if (!store.getChannelCode().equals(detail.getChannelCode())) continue;
                    lastOrder = detail;
                }
                if (lastOrder != null) {
                    line.add(String.valueOf(lastOrder.getTotalDemand()));
                    continue;
                }
                line.add("0");
            }
            allLines.add(line);
            line.add(String.valueOf(order.getTotalDemand()));
        }
        HashMap<String, List<List<String>>> sheets = new HashMap<String, List<List<String>>>();
        sheets.put("\u5b9e\u9645\u91c7\u8d2d\u5355\u5217\u8868", allLines);
        sheets.put("\u95e8\u5e97\u660e\u7ec6", storeAllLines);
        return sheets;
    }

    @Override
    public List<FpcsPurchaseOrder> getCacheSkuOrderList(List<FpcsPurchaseOrder> fpcsPurchaseOrderList) {
        for (FpcsPurchaseOrder order : fpcsPurchaseOrderList) {
            if (order.getDemand() == null || order.getDemand() <= 0) continue;
            FpcsSkuOrder pcsSku = this.fpcsSkuServiceImpl.findSkuById(order.getId());
            order.setCategory(pcsSku.getSkuType());
            order.setSkuCode(pcsSku.getSkuCode());
            order.setSkuName(pcsSku.getSkuName());
            order.setSkuUnit(pcsSku.getSkuUnit());
            order.setPurchaseUnit(pcsSku.getPurchaseUnit());
            order.setPurchaseUnitNumber(pcsSku.getPurchaseUnitNumber());
        }
        return fpcsPurchaseOrderList;
    }
}

