/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase;

import com.thebeastshop.pegasus.service.purchase.SpringUtil;
import com.thebeastshop.pegasus.service.purchase.cond.PcsBrandCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsBuyerCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsCertificateFieldCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseOrderCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuReceiveStandardCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSupplierCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsTagCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsWatermarkCond;
import com.thebeastshop.pegasus.service.purchase.cond.PrdcJobCond;
import com.thebeastshop.pegasus.service.purchase.cond.PrdcRecipeCond;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.flower.model.FpcsOrderListForm;
import com.thebeastshop.pegasus.service.purchase.flower.model.FpcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.flower.service.FpcsActualPurchaseService;
import com.thebeastshop.pegasus.service.purchase.flower.service.FpcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsActualChannelItemVO;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsActualChannelVO;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsActualExcelVO;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsChannelQuantity;
import com.thebeastshop.pegasus.service.purchase.model.FpcsConsumableAllot;
import com.thebeastshop.pegasus.service.purchase.model.FpcsSkuOrder;
import com.thebeastshop.pegasus.service.purchase.model.PcsBrand;
import com.thebeastshop.pegasus.service.purchase.model.PcsBuyerInfo;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateField;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateSkuField;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTag;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTagField;
import com.thebeastshop.pegasus.service.purchase.model.PcsClPs;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanCost;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.model.PcsSku;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCategory;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCategoryRelation;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCategoryRelationCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCmSpl;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCustomMade;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuQcImg;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSalesPriceChange;
import com.thebeastshop.pegasus.service.purchase.model.PcsSupplier;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJob;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJobLine;
import com.thebeastshop.pegasus.service.purchase.service.FpcsSkuService;
import com.thebeastshop.pegasus.service.purchase.service.PcsBrandService;
import com.thebeastshop.pegasus.service.purchase.service.PcsBuyerInfoService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateFieldService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateSkuFieldService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateTagService;
import com.thebeastshop.pegasus.service.purchase.service.PcsClPsService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCategoryService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCmSplService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCustomMadeService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuImgService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuQcImgService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuReceiveStandardService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuSalesPriceChangeService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSupplierService;
import com.thebeastshop.pegasus.service.purchase.service.PcsTagService;
import com.thebeastshop.pegasus.service.purchase.service.PcsWatermarkService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcJobLineService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcJobService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcRecipeService;
import com.thebeastshop.pegasus.service.purchase.vo.FlowerSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.MaterailSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsBrandVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsBuyerInfoVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateSkuFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagEditVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagFieldValueVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFrontBackCategoryVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseOrderVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuBarcodeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCmSplVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCustomMadeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuInfoVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuReceiveStandardRuleVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuReceiveStandardVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuSalesPriceChangeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSupplierVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsTagVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsWatermarkVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcJobLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcJobVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrintCerVO;
import com.thebeastshop.pegasus.service.purchase.vo.ProdSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.ProductWatermarkVO;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvOccupy;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReleaseOccupationVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPrdcJobTaskVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.importExcel.AdvancedParseExcelComponent;
import com.thebeastshop.pegasus.util.lock.PegasusFacadeLock;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class PegasusPurchaseServiceFacade {
    private static final Logger log = LoggerFactory.getLogger(PegasusPurchaseServiceFacade.class);
    private static PegasusPurchaseServiceFacade instance;
    @Autowired
    private PcsSupplierService pcsSupplierService;
    @Autowired
    private PcsBrandService pcsBrandService;
    @Autowired
    private PcsSkuCategoryService pcsSkuCategoryService;
    @Autowired
    private PcsSkuService pcsSkuService;
    @Autowired
    private PcsSkuCustomMadeService pcsSkuCustomMadeService;
    @Autowired
    private PcsSkuCmSplService pcsSkuCmSplService;
    @Autowired
    private PcsClPsService pcsClPsService;
    @Autowired
    private PcsPurchaseOrderService pcsPurchaseOrderService;
    @Autowired
    private PcsPoLineService pcsPoLineService;
    @Autowired
    private PcsPoPlanService pcsPoPlanService;
    @Autowired
    private PcsPoPlanLineService pcsPoPlanLineService;
    @Autowired
    private PrdcRecipeService prdcRecipeService;
    @Autowired
    private PrdcJobService prdcJobService;
    @Autowired
    private PrdcJobLineService prdcJobLineService;
    @Autowired
    private PcsBuyerInfoService pcsBuyerInfoService;
    @Autowired
    private FpcsPurchaseOrderService fpcsPurchaseOrderService;
    @Autowired
    public PcsSkuImgService pcsSkuImgService;
    @Autowired
    public PcsSkuQcImgService pcsSkuQcImgService;
    @Autowired
    private FpcsSkuService fpcsSkuService;
    @Autowired
    private FpcsActualPurchaseService fpcsActualPurchaseService;
    @Autowired
    private PcsWatermarkService pcsWatermarkService;
    @Autowired
    private PcsTagService pcsTagService;
    @Autowired
    private PcsCertificateFieldService pcsCertificateFieldService;
    @Autowired
    private PcsCertificateSkuFieldService pcsCertificateSkuFieldService;
    private AdvancedParseExcelComponent advancedParseExcelComponent;
    @Autowired
    private PcsCertificateTagService pcsCertificateTagService;
    @Autowired
    private PcsSkuReceiveStandardService pcsSkuReceiveStandardService;
    @Autowired
    private PcsSkuSalesPriceChangeService pcsSkuSalesPriceChangeService;

    private PegasusPurchaseServiceFacade() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PegasusPurchaseServiceFacade getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<PegasusFacadeLock> clazz = PegasusFacadeLock.class;
        synchronized (PegasusFacadeLock.class) {
            if (instance == null) {
                log.warn("[fasade init start] PegasusPurchaseServiceFacade");
                new ClassPathXmlApplicationContext("pegasus-service-purchase/spring.xml");
                log.warn("[fasade init finish] PegasusPurchaseServiceFacade");
            }
            instance = (PegasusPurchaseServiceFacade)SpringUtil.getBean("pegasusPurchaseServiceFacade");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static <T> T getBean(Class<T> requiredType) {
        return SpringUtil.getBean(requiredType);
    }

    public AdvancedParseExcelComponent getAdvancedParseExcelComponent() {
        return this.advancedParseExcelComponent;
    }

    public Long createSupplier(PcsSupplierVO vo) {
        return this.pcsSupplierService.create(this.pcsSupplierService.buildFromVO(vo), vo.isSaveDraft());
    }

    public Map<String, ProductWatermarkVO> selectWaterMarkByProductCodes(List<String> productCodes) {
        return this.pcsWatermarkService.seleckWatermarkByProductCodes(productCodes);
    }

    public Boolean updateSupplier(PcsSupplierVO vo) {
        return this.pcsSupplierService.update(this.pcsSupplierService.buildFromVO(vo), vo.isSaveDraft());
    }

    public PcsSupplierVO findSupplierById(Long id) {
        PcsSupplier record = this.pcsSupplierService.findById(id);
        PcsSupplierVO vo = this.pcsSupplierService.buildFromModel(record);
        return vo;
    }

    public List<PcsSupplierVO> findSupplierByCond(PcsSupplierCond cond) {
        List<PcsSupplierVO> recordList = this.pcsSupplierService.findByCond(cond);
        return recordList;
    }

    public List<PcsSupplierVO> findSupplierByCriteria(PcsSupplierCond cond) {
        List<PcsSupplier> recordList = this.pcsSupplierService.findByCriteria(cond);
        ArrayList<PcsSupplierVO> vos = new ArrayList<PcsSupplierVO>(recordList.size());
        for (PcsSupplier record : recordList) {
            PcsSupplierVO vo = this.pcsSupplierService.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public Long createBrand(PcsBrandVO vo) {
        return this.pcsBrandService.create(this.pcsBrandService.bulidFromVO(vo), vo.isSaveDraft());
    }

    public boolean updateBrand(PcsBrandVO vo) {
        return this.pcsBrandService.update(this.pcsBrandService.bulidFromVO(vo), vo.isSaveDraft());
    }

    public PcsBrandVO findBrandById(long id) {
        PcsBrand record = this.pcsBrandService.findById(id);
        PcsBrandVO vo = this.pcsBrandService.buildFromModel(record);
        return vo;
    }

    public List<PcsBrandVO> findBrandByCond(PcsBrandCond cond) {
        List<PcsBrandVO> recordList = this.pcsBrandService.findByCond(cond);
        return recordList;
    }

    public PcsSkuCategoryVO findSkuCategoryById(long id) {
        PcsSkuCategory record = this.pcsSkuCategoryService.findById(id);
        PcsSkuCategoryVO vo = this.pcsSkuCategoryService.bulidFromModel(record);
        return vo;
    }

    public PcsSkuCategoryVO findSkuBackCategoryById(long id) {
        PcsSkuCategory record = this.pcsSkuCategoryService.findBackCategoryById(id);
        PcsSkuCategoryVO vo = this.pcsSkuCategoryService.bulidFromModel(record);
        return vo;
    }

    public List<PcsSkuCategoryVO> findFrontCategoriesBySkuCode(String skuCode) {
        List<PcsSkuCategory> categoryList = this.pcsSkuCategoryService.findFrontCategoriesBySkuCode(skuCode);
        List voList = BeanUtil.buildListFrom(categoryList, PcsSkuCategoryVO.class);
        return voList;
    }

    public List<PcsSkuCategoryVO> findFrontCategoriesBySkuCodeList(List<String> skuCodeList) {
        List<PcsSkuCategory> categoryList = this.pcsSkuCategoryService.findFrontCategoriesBySkuCodeList(skuCodeList);
        List voList = BeanUtil.buildListFrom(categoryList, PcsSkuCategoryVO.class);
        return voList;
    }

    public List<Long> findProductIdsBySkuCodes(List<String> skuCodes) {
        return this.pcsSkuCategoryService.findProductIdsBySkuCodes(skuCodes);
    }

    public List<Long> findProductIdsByCategoryFrontRelationIds(List<Long> ids) {
        return this.pcsSkuCategoryService.findProductIdListByCategoryFrontRelationIds(ids);
    }

    public List<Long> findFrontCategoryIdListByBackCategoryId(Long backCategoryRelationId) {
        return this.pcsSkuCategoryService.findFrontCategoryIdListByBackCategoryId(backCategoryRelationId);
    }

    public List<Long> findFrontCategoryIdListByBackCategoryIds(List<Long> backCategoryRelationIds) {
        return this.pcsSkuCategoryService.findFrontCategoryIdListByBackCategoryIds(backCategoryRelationIds);
    }

    public List<Long> findBackCategoryIdListByFrontCategoryId(Long frontCategoryId) {
        return this.pcsSkuCategoryService.findBackCategoryIdListByFrontCategoryId(frontCategoryId);
    }

    public Integer countOfFrontCategoryRelation(PcsSkuCategoryRelationCond cond) {
        return this.pcsSkuCategoryService.countOfFrontCategoryRelation(cond);
    }

    public List<PcsSkuCategoryVO> findBackCategoryList(Map<String, Object> params) {
        return this.pcsSkuCategoryService.findBackCategoryList(params);
    }

    public void synFrontCategoryRelation(String skuCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCode", skuCode);
        List<PcsSkuCategoryVO> backCategoryList = this.findBackCategoryList(params);
        PcsSkuVO sku = this.findSkuByCode(skuCode);
        if (sku == null) {
            return;
        }
        ArrayList<Long> backIds = new ArrayList<Long>();
        for (int i = 0; i < backCategoryList.size(); ++i) {
            PcsSkuCategoryVO backCategory = backCategoryList.get(i);
            backIds.add(backCategory.getId());
        }
        List<Long> newFrontCategoryIds = this.findFrontCategoryIdListByBackCategoryIds(backIds);
        log.info("synFrontCategoryRelation \u540c\u6b65sku[{}]\u7c7b\u76ee\u65f6\uff0c\u76f8\u5173\u7684\u524d\u53f0\u7c7b\u76ee:[{}]", (Object)skuCode, (Object)StringUtils.join(newFrontCategoryIds, (String)", "));
        PcsSkuCategoryRelationCond cond = new PcsSkuCategoryRelationCond();
        cond.setSkuCode(skuCode);
        cond.setNotCategoryIdList(newFrontCategoryIds);
        List<PcsSkuCategoryRelation> toDelBackRelationList = this.findFrontCategoryRelation(cond);
        ArrayList<Long> toDelIdList = new ArrayList<Long>();
        for (int i = 0; i < toDelBackRelationList.size(); ++i) {
            PcsSkuCategoryRelation relation = toDelBackRelationList.get(i);
            toDelIdList.add(relation.getId());
        }
        this.deleteFrontCategoryRelationList(toDelIdList);
        if (EmptyUtil.isNotEmpty(toDelIdList)) {
            log.info("synFrontCategoryRelation \u540c\u6b65sku[{}]\u7c7b\u76ee\u65f6\uff0c\u6e05\u9664\u7684\u524d\u53f0\u7c7b\u76ee:[{}]", (Object)skuCode, (Object)StringUtils.join(toDelIdList, (String)", "));
        }
        ArrayList<Long> needToAddCategoryIds = new ArrayList<Long>();
        for (int i = 0; i < newFrontCategoryIds.size(); ++i) {
            Long categoryId = newFrontCategoryIds.get(i);
            PcsSkuCategoryRelation relation = new PcsSkuCategoryRelation();
            relation.setSkuCode(skuCode);
            relation.setCategoryId(categoryId);
            PcsSkuCategoryRelationCond frontCond = new PcsSkuCategoryRelationCond();
            frontCond.setSkuCode(skuCode);
            frontCond.setCategoryId(categoryId);
            List<PcsSkuCategoryRelation> list = this.findFrontCategoryRelation(frontCond);
            if (!EmptyUtil.isEmpty(list)) continue;
            this.addFrontCategoryRelation(relation);
            needToAddCategoryIds.add(relation.getCategoryId());
        }
        if (EmptyUtil.isNotEmpty(needToAddCategoryIds)) {
            log.info("synFrontCategoryRelation \u540c\u6b65sku[{}]\u7c7b\u76ee\u65f6\uff0c\u6dfb\u52a0\u7684\u7684\u524d\u53f0\u7c7b\u76ee\uff1a[{}]", (Object)sku.getCode(), (Object)StringUtils.join(needToAddCategoryIds, (String)", "));
        }
    }

    public List<PcsSkuCategoryRelation> findBackCategoryRelationList(PcsSkuCategoryRelationCond cond) {
        return this.pcsSkuCategoryService.findBackCategoryRelationList(cond);
    }

    public void saveOrUpdateBackCategoryRelationList(List<PcsSkuCategoryRelation> relationList) {
        this.pcsSkuCategoryService.saveOrUpdateBackCategoryRelationList(relationList);
    }

    public void saveOrUpdateBackCategoryRelation(PcsSkuCategoryRelation relation) {
        this.pcsSkuCategoryService.saveOrUpdateBackCategoryRelation(relation);
    }

    public List<PcsFrontBackCategoryVO> findAllFrontBackCategoryList() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.pcsSkuCategoryService.findFrontBackCategoryList(params);
    }

    public List<PcsSkuCategoryVO> findAllFrontCategoryList() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.pcsSkuCategoryService.findFrontCategoryList(params);
    }

    public List<PcsSkuCategoryVO> findAllBackCategoryList() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<PcsSkuCategoryVO> recordList = this.pcsSkuCategoryService.findBackCategoryList(params);
        return recordList;
    }

    public void addFrontCategoryRelation(PcsSkuCategoryRelation relation) {
        this.pcsSkuCategoryService.addFrontCategoryRelation(relation);
    }

    public void addBackCategoryRelation(PcsSkuCategoryRelation relation) {
        this.pcsSkuCategoryService.addBackCategoryRelation(relation);
    }

    public List<PcsSkuCategoryRelation> findFrontCategoryRelation(PcsSkuCategoryRelationCond cond) {
        return this.pcsSkuCategoryService.findFrontCategoryRelation(cond);
    }

    public void updateSkuCategoryRelation(PcsSkuCategoryRelation relation) {
        this.pcsSkuCategoryService.updateFrontCategoryRelation(relation);
    }

    public List<PcsSkuCategoryVO> findSkuCategoryAllChildrens(long parentId) {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryService.findAllChildrens(parentId);
        ArrayList<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = this.pcsSkuCategoryService.bulidFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public List<PcsSkuCategoryVO> findSkuBackCategoryAllChildrens(long parentId) {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryService.findAllBackCategoryChildrens(parentId);
        ArrayList<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = this.pcsSkuCategoryService.bulidFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public List<PcsSkuCategoryVO> findSkuCategoryByCodeAndRightLikeCode(String code) {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryService.findByCodeAndRightLikeCode(code);
        ArrayList<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = this.pcsSkuCategoryService.bulidFromModel(record);
            vos.add(vo);
            log.info("FIND CATE CODE:{}, ID: {}", (Object)vo.getCode(), (Object)vo.getId());
        }
        return vos;
    }

    public List<PcsSkuCategoryVO> findSkuCategoryByParentIdIsNull() {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryService.findSkuCategoryByParentIdIsNull();
        ArrayList<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = this.pcsSkuCategoryService.bulidFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public List<PcsSkuCategoryVO> findCategoryAll() {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryService.findAllFrontCategories();
        ArrayList<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = this.pcsSkuCategoryService.bulidFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public List<PcsSkuCategoryVO> findSkuCategoryAll() {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryService.findAll();
        ArrayList<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = this.pcsSkuCategoryService.bulidFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public Long createSkuCategory(PcsSkuCategoryVO vo) {
        return this.pcsSkuCategoryService.create(this.pcsSkuCategoryService.bulidFromVO(vo));
    }

    public Long createSkuBackCategory(PcsSkuCategoryVO vo) {
        return this.pcsSkuCategoryService.createBackCategory(this.pcsSkuCategoryService.bulidFromVO(vo));
    }

    public boolean updateSkuCategory(PcsSkuCategoryVO vo) {
        return this.pcsSkuCategoryService.update(this.pcsSkuCategoryService.bulidFromVO(vo));
    }

    public boolean updateSkuBackCategory(PcsSkuCategoryVO vo) {
        return this.pcsSkuCategoryService.updateBackCategory(this.pcsSkuCategoryService.bulidFromVO(vo));
    }

    public PcsSkuCategoryVO findSkuCategoryByCode(String code) {
        PcsSkuCategory record = this.pcsSkuCategoryService.findByCode(code);
        PcsSkuCategoryVO vo = this.pcsSkuCategoryService.bulidFromModel(record);
        return vo;
    }

    public PcsSkuCategory findPcsSkuCategoryById(Long ParentId) {
        return this.pcsSkuCategoryService.findByParentID(ParentId);
    }

    public long createSku(PcsSkuVO vo) {
        return this.pcsSkuService.create(this.pcsSkuService.bulidFromVO(vo));
    }

    public List<Long> createSkus(List<PcsSkuVO> list) {
        ArrayList<PcsSku> skuList = new ArrayList<PcsSku>();
        for (PcsSkuVO pcsSkuVO : list) {
            pcsSkuVO.setSkuStatus(PcsSku.SKU_STATUS_DRAFT);
            skuList.add(this.pcsSkuService.bulidFromVO(pcsSkuVO));
        }
        return this.pcsSkuService.createSkus(skuList);
    }

    public List<Long> createFlowerSkus(List<FlowerSkuVO> list) {
        ArrayList<FpcsSkuOrder> skuList = new ArrayList<FpcsSkuOrder>();
        for (FlowerSkuVO pcsSkuVO : list) {
            skuList.add(this.fpcsSkuService.bulidFromVO(pcsSkuVO));
        }
        return this.fpcsSkuService.createSkus(skuList);
    }

    public List<Long> createConsumableSkus(List<FlowerSkuVO> list) {
        ArrayList<FpcsSkuOrder> skuList = new ArrayList<FpcsSkuOrder>();
        for (FlowerSkuVO pcsSkuVO : list) {
            skuList.add(this.fpcsSkuService.bulidFromVO(pcsSkuVO));
        }
        return this.fpcsSkuService.createSkus(skuList);
    }

    public Boolean updateSku(PcsSkuVO vo) {
        return this.pcsSkuService.update(this.pcsSkuService.bulidFromVO(vo));
    }

    public PcsSkuVO findSkuById(long id) {
        PcsSku record = this.pcsSkuService.findById(id);
        PcsSkuVO vo = this.pcsSkuService.buildFromModel(record);
        return vo;
    }

    public PcsSkuVO findSkuByCode(String code) {
        return this.pcsSkuService.findByCode(code);
    }

    public PcsSkuVO findSkuByCode(String code, boolean withFrontCategories, boolean withBackCategories) {
        return this.pcsSkuService.findByCode(code, withFrontCategories, withBackCategories);
    }

    public List<PcsSkuVO> findSkuByNameOrCode(String arg0) {
        return this.pcsSkuService.findByNameOrCode(arg0);
    }

    public List<PcsSkuVO> findSkuByCond(PcsSkuCond cond) {
        return this.pcsSkuService.findByCond(cond);
    }

    public List<PcsSkuVO> findSkuByCondForExport(PcsSkuCond cond) {
        return this.pcsSkuService.findByCondForExport(cond);
    }

    public List<Map<String, Object>> findSkuCanSaleAndCanSeeByChannelCode(String channelCode) {
        return this.pcsSkuService.findSkuCanSaleAndCanSeeByChannelCode(channelCode);
    }

    public Map<String, Object> findSkuCanSaleAndCanSeeInfo(String channelCode, String skuCode) {
        return this.pcsSkuService.findSkuCanSaleAndCanSeeInfo(channelCode, skuCode);
    }

    public List<PcsSkuVO> findSkuTagByCond(PcsSkuCond cond) {
        return this.pcsSkuService.findSkuTagByCond(cond);
    }

    public List<PcsSupplierVO> findSupplierByName(String name) {
        List<PcsSupplier> recordList = this.pcsSupplierService.findByName(name);
        ArrayList<PcsSupplierVO> vos = new ArrayList<PcsSupplierVO>(recordList.size());
        for (PcsSupplier record : recordList) {
            PcsSupplierVO vo = this.pcsSupplierService.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public List<PcsBrandVO> findBrandByName(String name) {
        List<PcsBrand> recordList = this.pcsBrandService.findByName(name);
        ArrayList<PcsBrandVO> vos = new ArrayList<PcsBrandVO>(recordList.size());
        for (PcsBrand record : recordList) {
            PcsBrandVO vo = this.pcsBrandService.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public List<PcsSkuCategoryVO> findSkuCategoryByName(String name) {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryService.findByName(name);
        ArrayList<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = this.pcsSkuCategoryService.bulidFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public List<PcsSkuCategoryVO> findSkuBackCategoryByName(String name) {
        List<PcsSkuCategory> recordList = this.pcsSkuCategoryService.findBackCategoryByName(name);
        ArrayList<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = this.pcsSkuCategoryService.bulidFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public Integer addFrontBackCategoryRelation(PcsFrontBackCategoryVO frontBackCategoryVO) {
        return this.pcsSkuCategoryService.addFrontBackCategoryRelation(frontBackCategoryVO);
    }

    public Boolean canUpdateSkuSalesPrice(String code) {
        PcsSkuVO vo = this.pcsSkuService.findByCode(code);
        if (EmptyUtil.isNotEmpty((Object)vo)) {
            return this.pcsSkuService.canUpdateSalesPrice(code);
        }
        throw new PurchaseException("PC0008", "\u65e0\u6548\u7684code");
    }

    public Boolean canUpdateSkuCostPrice(String code) {
        PcsSkuVO vo = this.pcsSkuService.findByCode(code);
        if (EmptyUtil.isNotEmpty((Object)vo)) {
            return this.pcsSkuService.canUpdateCostPrice(code);
        }
        throw new PurchaseException("PC0008", "\u65e0\u6548\u7684code");
    }

    public Boolean canUpdateSkuSupplier(String code) {
        PcsSkuVO vo = this.pcsSkuService.findByCode(code);
        if (EmptyUtil.isNotEmpty((Object)vo)) {
            return this.pcsSkuService.canUpdateSupplier(code);
        }
        throw new PurchaseException("PC0008", "\u65e0\u6548\u7684code");
    }

    public Boolean auditSkuSalesPriceChange(String code, Boolean isPass) {
        return this.pcsSkuService.auditSkuSalesPriceChange(code, isPass);
    }

    public PcsSkuSalesPriceChangeVO findSkuSalesPriceChangeByCodeAndProcessing(String code) {
        return this.pcsSkuService.findSkuSalesPriceChangeByCodeAndProcessing(code);
    }

    public Boolean createCustomMadeAndLine(PcsSkuCustomMadeVO pcsSkuCustomMadeVO) {
        PcsSkuCustomMade pcsSkuCustomMade = this.pcsSkuCustomMadeService.bulidFromVO(pcsSkuCustomMadeVO);
        ArrayList<PcsSkuCmSpl> pcsSkuCmSplList = new ArrayList();
        if (CollectionUtils.isEmpty(pcsSkuCustomMadeVO.getSupplierList())) {
            pcsSkuCmSplList = Collections.emptyList();
        } else {
            for (PcsSkuCmSplVO pcsSkuCmSplVO : pcsSkuCustomMadeVO.getSupplierList()) {
                PcsSkuCmSpl pcsSkuCmSpl = this.pcsSkuCmSplService.bulidFromVO(pcsSkuCmSplVO);
                pcsSkuCmSplList.add(pcsSkuCmSpl);
            }
        }
        return this.pcsSkuCustomMadeService.createCustomMadeAndLine(pcsSkuCustomMade, pcsSkuCmSplList);
    }

    public Boolean updateCustomMadeAndLine(PcsSkuCustomMadeVO pcsSkuCustomMadeVO) {
        PcsSkuCustomMade pcsSkuCustomMade = this.pcsSkuCustomMadeService.bulidFromVO(pcsSkuCustomMadeVO);
        ArrayList<PcsSkuCmSpl> pcsSkuCmSplList = new ArrayList();
        if (CollectionUtils.isEmpty(pcsSkuCustomMadeVO.getSupplierList())) {
            pcsSkuCmSplList = Collections.emptyList();
        } else {
            for (PcsSkuCmSplVO pcsSkuCmSplVO : pcsSkuCustomMadeVO.getSupplierList()) {
                PcsSkuCmSpl pcsSkuCmSpl = this.pcsSkuCmSplService.bulidFromVO(pcsSkuCmSplVO);
                pcsSkuCmSplList.add(pcsSkuCmSpl);
            }
        }
        return this.pcsSkuCustomMadeService.updateCustomMadeAndLine(pcsSkuCustomMade, pcsSkuCmSplList);
    }

    public List<PcsSkuCustomMadeVO> findSkuCustomMadeByCond(PcsSkuCond cond) {
        return this.pcsSkuCustomMadeService.findSkuCustomMadeByCond(cond);
    }

    public PcsSkuCustomMadeVO findSkuCustomMadeById(long id) {
        return this.pcsSkuCustomMadeService.findSkuCustomMadeById(id);
    }

    public List<PcsSkuCmSplVO> findSkuCmSplBySkuCustomMadeId(long skuCustomMadeId) {
        return this.pcsSkuCmSplService.findBySkuCustomMadeId(skuCustomMadeId);
    }

    public Boolean deletePcsCmSpl(long skuCustomMadeId, long skuCmSplId) {
        return this.pcsSkuCustomMadeService.deletePcsCmSpl(skuCustomMadeId, skuCmSplId);
    }

    public Boolean convertCustomMadeAndLine(long skuCustomMadeId, long skuCmSplId) {
        return this.pcsSkuCustomMadeService.convertCustomMadeAndLine(skuCustomMadeId, skuCmSplId);
    }

    public Boolean rejectCustomMade(long skuCustomMadeId) {
        return this.pcsSkuCustomMadeService.rejectCustomMade(skuCustomMadeId);
    }

    public List<PcsSupplier> findSupplerByIds(List<Long> ids) {
        return this.pcsSupplierService.findByIds(ids);
    }

    public List<PcsBrand> findBrandByIds(List<Long> ids) {
        return this.pcsBrandService.findByIds(ids);
    }

    public List<PcsSkuCategory> findSkuCategoryByIds(List<Long> ids) {
        return this.pcsSkuCategoryService.findByIds(ids);
    }

    public List<PcsSkuCategory> findSkuBackCategoryByIds(List<Long> ids) {
        return this.pcsSkuCategoryService.findBackCategoriesByIds(ids);
    }

    public List<PcsSkuVO> findSkuByCodes(List<String> codes) {
        return this.pcsSkuService.findByCodes(codes);
    }

    public List<PcsSkuVO> findSkuByCodes(List<String> codes, boolean withCategories) {
        return this.pcsSkuService.findByCodes(codes, withCategories);
    }

    public Long findPcsClPsMaxId() {
        return this.pcsClPsService.findMaxId();
    }

    public int addClPs(PcsClPs pcsClPs) {
        return this.pcsClPsService.add(pcsClPs);
    }

    public List<PcsClPs> findPcsClPsByMaxId(Long maxId) {
        return this.pcsClPsService.findByMaxId(maxId);
    }

    public boolean deletePcsClPsByMaxId(Long maxId) {
        return this.pcsClPsService.deleteByMaxId(maxId);
    }

    public Boolean convertSku(PcsSkuVO skuVO, long skuCustomMadeId) {
        PcsSku pcsSku = this.pcsSkuService.bulidFromVO(skuVO);
        return this.pcsSkuService.convertSku(pcsSku, skuCustomMadeId);
    }

    public Long createPurchaseOrderAndLine(PcsPurchaseOrderVO pcsPurchaseOrderVO) {
        PcsPurchaseOrder pcsPurchaseOrder = this.pcsPurchaseOrderService.buildFromVO(pcsPurchaseOrderVO);
        ArrayList<PcsPoLine> pcsPoLineList = new ArrayList();
        if (CollectionUtils.isEmpty(pcsPurchaseOrderVO.getPcsPoLineVOList())) {
            pcsPoLineList = Collections.emptyList();
        } else {
            for (PcsPoLineVO pcsPoLineVO : pcsPurchaseOrderVO.getPcsPoLineVOList()) {
                PcsPoLine pcsPoLine = this.pcsPoLineService.buildFromVO(pcsPoLineVO);
                pcsPoLineList.add(pcsPoLine);
            }
        }
        return this.pcsPurchaseOrderService.createPurchaseOrderAndLine(pcsPurchaseOrder, pcsPoLineList, pcsPurchaseOrderVO.isSaveDraft());
    }

    public Boolean updatePurchaseOrderAndLine(PcsPurchaseOrderVO pcsPurchaseOrderVO) {
        PcsPurchaseOrder pcsPurchaseOrder = this.pcsPurchaseOrderService.buildFromVO(pcsPurchaseOrderVO);
        ArrayList<PcsPoLine> pcsPoLineList = new ArrayList();
        if (CollectionUtils.isEmpty(pcsPurchaseOrderVO.getPcsPoLineVOList())) {
            pcsPoLineList = Collections.emptyList();
        } else {
            for (PcsPoLineVO pcsPoLineVO : pcsPurchaseOrderVO.getPcsPoLineVOList()) {
                PcsPoLine pcsPoLine = this.pcsPoLineService.buildFromVO(pcsPoLineVO);
                pcsPoLineList.add(pcsPoLine);
            }
        }
        return this.pcsPurchaseOrderService.updatePurchaseOrderAndLine(pcsPurchaseOrder, pcsPoLineList, pcsPurchaseOrderVO.isSaveDraft());
    }

    public Boolean updatePurchaseOrder(PcsPurchaseOrderVO pcsPurchaseOrderVO) {
        PcsPurchaseOrder pcsPurchaseOrder = new PcsPurchaseOrder();
        BeanUtils.copyProperties((Object)pcsPurchaseOrderVO, (Object)pcsPurchaseOrder);
        return this.pcsPurchaseOrderService.updatePurchaseOrder(pcsPurchaseOrder);
    }

    public PcsPurchaseOrderVO findPoVOById(long id) {
        return this.pcsPurchaseOrderService.findPoVOById(id);
    }

    public PcsPurchaseOrderVO findPurchaseOrderByCommandCode(String commandCode) {
        return this.pcsPurchaseOrderService.findPurchaseOrderByCommandCode(commandCode);
    }

    public List<PcsPoLineVO> findPoLineVOByPoId(long poId) {
        return this.pcsPoLineService.findPoLineVOByPoId(poId);
    }

    public List<PcsPoLineVO> findPoSkuByPoId(long poId) {
        return this.pcsPoLineService.findPoSkuByPoId(poId);
    }

    public List<PcsPurchaseOrderVO> findPOVOByCond(PcsPurchaseOrderCond cond) {
        return this.pcsPurchaseOrderService.findPOVOByCond(cond);
    }

    public Boolean closePurchaseOrder(long id) {
        return this.pcsPurchaseOrderService.closePurchaseOrder(id);
    }

    public List<String> findWarehouseCodeGroupFromPurchaseOrder() {
        return this.pcsPurchaseOrderService.findWarehouseCodeGroup();
    }

    public Boolean auditPurchaseOrder(long id, Boolean isPass, Integer type) {
        return this.pcsPurchaseOrderService.auditPurchaseOrder(id, isPass, type);
    }

    public Boolean audiSupplier(Long userId, long id, Boolean isPass, Integer type) {
        return this.pcsSupplierService.audiSupplier(userId, id, isPass, type);
    }

    public Boolean audiBrand(Long userId, long id, Boolean isPass, Integer type) {
        return this.pcsBrandService.auditBrand(userId, id, isPass, type);
    }

    public Boolean createPoPlanAndLine(PcsPoPlanVO pcsPoPlanVO) throws Exception {
        PcsPoPlan pcsPoPlan = this.pcsPoPlanService.buildFromVO(pcsPoPlanVO);
        ArrayList<PcsPoPlanLine> pcsPoPlanLineList = new ArrayList();
        if (CollectionUtils.isEmpty(pcsPoPlanVO.getPcsPoPlanLineVOList())) {
            pcsPoPlanLineList = Collections.emptyList();
        } else {
            for (PcsPoPlanLineVO pcsPoPlanLineVO : pcsPoPlanVO.getPcsPoPlanLineVOList()) {
                PcsPoPlanLine pcsPoPlanLine = this.pcsPoPlanLineService.buildFromVO(pcsPoPlanLineVO);
                pcsPoPlanLineList.add(pcsPoPlanLine);
            }
        }
        return this.pcsPoPlanService.createPoPlanAndLine(pcsPoPlan, pcsPoPlanLineList);
    }

    public Boolean createPoPlanAndLineThenFinish(PcsPoPlanVO pcsPoPlanVO) throws Exception {
        PcsPoPlan pcsPoPlan = this.pcsPoPlanService.buildFromVO(pcsPoPlanVO);
        ArrayList<PcsPoPlanLine> pcsPoPlanLineList = new ArrayList();
        if (CollectionUtils.isEmpty(pcsPoPlanVO.getPcsPoPlanLineVOList())) {
            pcsPoPlanLineList = Collections.emptyList();
        } else {
            for (PcsPoPlanLineVO pcsPoPlanLineVO : pcsPoPlanVO.getPcsPoPlanLineVOList()) {
                PcsPoPlanLine pcsPoPlanLine = this.pcsPoPlanLineService.buildFromVO(pcsPoPlanLineVO);
                pcsPoPlanLineList.add(pcsPoPlanLine);
            }
        }
        return this.pcsPoPlanService.createPoPlanAndLineThenFinish(pcsPoPlan, pcsPoPlanLineList);
    }

    public List<PcsPoPlanVO> findPcsPoPlanVOByPoId(long poId) {
        List<PcsPoPlan> recordList = this.pcsPoPlanService.findPcsPoPlanByPoId(poId);
        ArrayList<PcsPoPlanVO> vos = new ArrayList<PcsPoPlanVO>(recordList.size());
        for (PcsPoPlan record : recordList) {
            PcsPoPlanVO vo = this.pcsPoPlanService.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public boolean updatePcsPoPlanById(long id, String date) {
        return this.pcsPoPlanService.updatePcsPoPlanById(id, date);
    }

    public Boolean deletePcsPoLine(long poId, long pcsPoLineId) {
        return this.pcsPurchaseOrderService.deletePcsPoLine(poId, pcsPoLineId);
    }

    public List<PcsPoPlanLineVO> findPoPlanLineVOByPoPlanId(long poPlanId) {
        return this.pcsPoPlanLineService.findPoPlanLineVOByPoPlanId(poPlanId);
    }

    public List<PcsSkuInfoVO> allSkuInfo() {
        return this.pcsSkuService.allSkuInfo();
    }

    public PcsSkuInfoVO findStockByCode(String skuCode) {
        return this.pcsSkuService.findStockByCode(skuCode);
    }

    public Long createRecipe(PrdcRecipeVO vo) {
        return this.prdcRecipeService.create(vo);
    }

    public Boolean updateRecipe(PrdcRecipeVO vo) {
        return this.prdcRecipeService.update(vo);
    }

    public PrdcRecipeVO findRecipeVOById(Long id) {
        return this.prdcRecipeService.findRecipeVOById(id);
    }

    public List<PrdcRecipeVO> findRecipeVOByCond(PrdcRecipeCond cond, Boolean cascade) {
        return this.prdcRecipeService.findRecipeVOByCond(cond, cascade);
    }

    public Boolean deleteRecipeMaterial(Long recipeId, Long recipeMaterialId) {
        return this.prdcRecipeService.deleteRecipeMaterial(recipeId, recipeMaterialId);
    }

    public Long createJob(PrdcJobVO vo) {
        return this.prdcJobService.create(vo);
    }

    public List<Long> batchCreate(List<PrdcJobVO> list) {
        return this.prdcJobService.batchCreate(list);
    }

    public Boolean returnModifyJob(PrdcJobVO vo) {
        return this.prdcJobService.returnModify(vo);
    }

    public PrdcJobVO findJobVOById(Long id) {
        return this.prdcJobService.findJobVOById(id);
    }

    public PrdcJobVO findJobVOByCode(String code) {
        return this.prdcJobService.findJobVOByCode(code);
    }

    public List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond, Boolean cascade) {
        return this.prdcJobService.findJobVOByCond(cond, cascade);
    }

    public List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond) {
        return this.prdcJobService.findJobVOByCond(cond);
    }

    public Boolean deleteJobLine(Long jobId, Long jobLineId) {
        return this.prdcJobService.deleteJobLine(jobId, jobLineId);
    }

    public Boolean cancelJobForStatusReturnModify(Long jobId) {
        return this.prdcJobService.cancelJobForStatusReturnModify(jobId);
    }

    public List<PcsSkuCategory> findAllSkuCateChildrens(long parentId) {
        if (NumberUtil.isNullOrZero((Number)parentId)) {
            return Collections.emptyList();
        }
        return this.pcsSkuCategoryService.findAllChildrens(parentId);
    }

    public List<PrdcJobLine> getPrdcJobLine(Long id) {
        return this.prdcJobLineService.getPrdcJobLineByJobId(id);
    }

    public Boolean startProduction(PrdcJobVO jobVO) {
        return this.prdcJobService.startProduction(jobVO);
    }

    public Boolean updateJobVO(PrdcJobVO jobVO) {
        return this.prdcJobService.updateJobVO(jobVO);
    }

    public Boolean releaseJobLineOccupyAndUpdate(PrdcJobVO jobVO, List<WhReleaseOccupationVO> whReleaseOccupationVOList) {
        return this.prdcJobService.releaseJobLineOccupyAndUpdate(jobVO, whReleaseOccupationVOList);
    }

    public Boolean createCommandsAfterReleaseThenFinishAndUpdate(PrdcJobVO jobVO, List<WhCommand> whCommands, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        return this.prdcJobService.createCommandsAfterReleaseThenFinishAndUpdate(jobVO, whCommands, whReleaseOccupationVOList);
    }

    public String getWarehouseName(String warehouseCode) {
        return this.prdcJobService.getWarehouseName(warehouseCode);
    }

    public List<Map<String, String>> getWarehouseList(List<String> warehouseCodeList) {
        return this.prdcJobService.getWarehouseList(warehouseCodeList);
    }

    public List<WhInvOccupy> buildWhOccupy(PrdcJob prdcJob, List<PrdcJobLine> prdcJobLineList, String warehouseCode, Integer occupyType) {
        return this.prdcJobService.buildWhOccupy(prdcJob, prdcJobLineList, warehouseCode, occupyType);
    }

    public List<WhReleaseOccupationVO> buildWhRelease(PrdcJob prdcJob, List<PrdcJobLine> prdcJobLineList, Integer occupyType) {
        return this.prdcJobService.buildWhRelease(prdcJob, prdcJobLineList, occupyType);
    }

    public List<WhCommand> buildPrdcCommands(PrdcJobVO jobVO) {
        return this.prdcJobService.buildPrdcCommands(jobVO);
    }

    public byte[] exportPoPlanStatusWaitingIn() {
        return this.pcsPoPlanService.exportPoPlanStatusWaitingIn();
    }

    public byte[] exportPoInfomation() {
        return this.pcsPoPlanService.exportPoInfomation();
    }

    public PcsBuyerInfoVO getBuyerInfoById(Long id) {
        return this.pcsBuyerInfoService.getBuyerInfoById(id);
    }

    public List<PcsBuyerInfoVO> getAllBuyers() {
        return this.pcsBuyerInfoService.getAllBuyers();
    }

    public List<Map<String, String>> getAllBuyerInfos() {
        return this.pcsBuyerInfoService.getAllBuyerInfos();
    }

    public List<PcsBuyerInfoVO> getBuyerByCond(PcsBuyerCond cond) {
        return this.pcsBuyerInfoService.getBuyerByCond(cond);
    }

    public Boolean newBuyer(PcsBuyerInfo buyerInfo) {
        return this.pcsBuyerInfoService.newBuyer(buyerInfo);
    }

    public Boolean updateBuyerInfo(PcsBuyerInfo buyer) {
        return this.pcsBuyerInfoService.updateBuyerInfo(buyer);
    }

    public int deleteSkuQcImgBySkuCode(String skuCode) {
        return this.pcsSkuQcImgService.deleteQcImgBySkuCode(skuCode);
    }

    public int createSkuQcImg(PcsSkuQcImg pcsSkuQcImg) {
        return this.pcsSkuQcImgService.createQcImg(pcsSkuQcImg);
    }

    public List<PcsSkuQcImg> findPcsSkuQcImgListBySkuCode(String skuCode) {
        return this.pcsSkuQcImgService.findPcsSkuQcImgBySkuCode(skuCode);
    }

    public List<FpcsPurchaseOrder> selectFpcsPurchaseOrder(FpcsPurchaseOrder example) {
        return this.fpcsPurchaseOrderService.select(example);
    }

    public List<FpcsSkuOrder> getAllFlowerSkuInfo() throws Exception {
        return this.fpcsSkuService.getAllFlowerSkuInfo();
    }

    public List<FpcsSkuOrder> getFlowerSkuInfo(Map<String, Object> params) {
        return this.fpcsSkuService.getFlowerSkuInfo(params);
    }

    public List<FpcsSkuOrder> getFlowerSkuByCondition(Date time, String code) throws Exception {
        return this.fpcsSkuService.getFlowerSkuByCondition(time, code);
    }

    public int sumitOrder(FpcsOrderListForm example) {
        return this.fpcsPurchaseOrderService.sumitOrder(example);
    }

    public List<FpcsPurchaseOrder> findPurchaseOrderList(FpcsPurchaseOrder cond) {
        return this.fpcsPurchaseOrderService.getPurchaseOrderList(cond);
    }

    public List<FpcsPurchaseOrder> getCacheSkuOrderList(List<FpcsPurchaseOrder> fpcsPurchaseOrderList) {
        return this.fpcsPurchaseOrderService.getCacheSkuOrderList(fpcsPurchaseOrderList);
    }

    public Map<String, Object> detailPurchaseOrder(long id) {
        return this.fpcsPurchaseOrderService.getDetailPurchaseOrder(id);
    }

    public void acceptOrder(FpcsPurchaseOrder cond) {
        this.fpcsPurchaseOrderService.acceptOrder(cond);
    }

    public Map<String, List<List<String>>> exportPurchaseOrder(FpcsPurchaseOrder example) {
        return this.fpcsPurchaseOrderService.exportPurchaseOrder(example);
    }

    public List<FpcsActualExcelVO> queryActualPurchaseList(Map<String, Object> params) {
        return this.fpcsActualPurchaseService.queryActualPurchaseList(params);
    }

    public List<FpcsChannelQuantity> queryActualPruchaseChannelList(Map<String, Object> params) {
        return this.fpcsActualPurchaseService.queryActualPruchaseChannelList(params);
    }

    public Long addActualPurchaseLog(FpcsActualExcelVO actualExcelVO) {
        Long ret = this.fpcsActualPurchaseService.addActualPurchaseLog(actualExcelVO);
        if (ret > 0L) {
            List<FpcsChannelQuantity> channelQuantityList = actualExcelVO.getChannelQuantitiyList();
            int len = channelQuantityList.size();
            for (int i = 0; i < len; ++i) {
                FpcsChannelQuantity channelQuantity = channelQuantityList.get(i);
                if (channelQuantity.getQuantity() == null || channelQuantity.getQuantity() == 0 || channelQuantity.getSkuCode() == null) continue;
                channelQuantity.setActualPurchaseId(actualExcelVO.getId());
                this.fpcsActualPurchaseService.addActualPurhcaseChannel(channelQuantity);
            }
        }
        return ret;
    }

    public List<FpcsActualChannelVO> queryActualChannelList(Map<String, Object> params) {
        return this.fpcsActualPurchaseService.queryActualChannelList(params);
    }

    public List<FpcsActualChannelItemVO> queryActualChannelItemList(Map<String, Object> params) {
        return this.fpcsActualPurchaseService.queryActualChannelItemList(params);
    }

    public int saveConsumableAllot(List<PcsSkuVO> skuList, List<MaterailSkuVO> codeCategory) {
        int i = 0;
        if (skuList != null) {
            ArrayList<FpcsConsumableAllot> consumableAllotList = new ArrayList<FpcsConsumableAllot>();
            for (PcsSkuVO pcsSkuVO : skuList) {
                FpcsConsumableAllot fpcsConsumableAllot = new FpcsConsumableAllot();
                fpcsConsumableAllot.setCreatTime(new Date());
                fpcsConsumableAllot.setSkuCode(pcsSkuVO.getCode());
                fpcsConsumableAllot.setSkuName(pcsSkuVO.getName());
                fpcsConsumableAllot.setMaterial(pcsSkuVO.getMaterial());
                fpcsConsumableAllot.setSpecification(pcsSkuVO.getSpecification());
                fpcsConsumableAllot.setSize(pcsSkuVO.getSize());
                fpcsConsumableAllot.setMaxApplyNumber(pcsSkuVO.getStock());
                fpcsConsumableAllot.setApplyNumber(0);
                if (!CollectionUtils.isEmpty(codeCategory)) {
                    for (MaterailSkuVO materailSkuVO : codeCategory) {
                        if (!pcsSkuVO.getCode().endsWith(materailSkuVO.getSkuCode())) continue;
                        fpcsConsumableAllot.setCategory(materailSkuVO.getCategory());
                    }
                }
                consumableAllotList.add(fpcsConsumableAllot);
            }
            i = this.fpcsSkuService.saveConsumableAllot(consumableAllotList);
        }
        return i;
    }

    public List<FpcsConsumableAllot> getAllConsumableList() {
        return this.fpcsSkuService.getAllConsumableList();
    }

    public List<PcsSkuVO> findChannelSkuForNoDistribute(PcsSkuCond cond) {
        return this.pcsSkuService.findChannelSkuForNoDistribute(cond);
    }

    public void setSkuChannel(List<String> skuCodeList, List<String> channelCodeList, Long operatorId) {
        this.pcsSkuService.setSkuChannel(skuCodeList, channelCodeList, operatorId);
    }

    public int addWatermark(PcsWatermarkVO iconVO) {
        return this.pcsWatermarkService.addIcon(iconVO);
    }

    public int updateWatermark(PcsWatermarkVO watermarkVO) {
        return this.pcsWatermarkService.updateIcon(watermarkVO);
    }

    public PcsWatermarkVO findWatermarkById(Long id) {
        return this.pcsWatermarkService.findWatermarkById(id);
    }

    public int deleteProdWatermark(List<String> idList) {
        return this.pcsWatermarkService.deleteProdWatermarkByIds(idList);
    }

    public List<PcsWatermarkVO> queryWatermarkList(Map<String, Object> params) {
        return this.pcsWatermarkService.queryWatermarkList(params);
    }

    public List<ProdSkuVO> queryProdWatermarkList(PcsWatermarkCond cond) {
        return this.pcsWatermarkService.queryProdWatermarkList(cond);
    }

    public List<ProdSkuVO> querySkuListByProd(Long prodId) {
        return this.pcsWatermarkService.querySkuListByProd(prodId);
    }

    public List<ProdSkuVO> queryProdListBySkuCode(String code) {
        return this.pcsWatermarkService.queryProdListBySkuCode(code);
    }

    public List<ProdSkuVO> queryProdTagListByTagCode(PcsTagCond cond) {
        return this.pcsTagService.queryProdTagListByTagCode(cond);
    }

    public PcsTagVO findTagById(Long id) {
        return this.pcsTagService.findTagById(id);
    }

    public List<PcsTagVO> queryTagList(Map<String, Object> params) {
        return this.pcsTagService.queryTagList(params);
    }

    public int addTag(PcsTagVO tagVO) {
        return this.pcsTagService.addTag(tagVO);
    }

    public int updateTag(PcsTagVO tagVO) {
        return this.pcsTagService.updateTag(tagVO);
    }

    public List<ProdSkuVO> queryProdSkuListByTagParams(List<String> params) {
        return this.pcsTagService.queryProdSkuListByTagParams(params);
    }

    public int updateSkuWatrmarkByCodeList(String skuCode, List<String> codeList) {
        return this.pcsWatermarkService.updateSkuWatrmarkByCodeList(skuCode, codeList);
    }

    public int updateProdWatrmarkByCodeList(ProdSkuVO prod, List<String> watermarkCodeList, boolean isEmptyBeforeUpdate) {
        return this.pcsWatermarkService.updateProdWatrmarkByCodeList(prod, watermarkCodeList, isEmptyBeforeUpdate);
    }

    public int updateProdTagByCodeList(ProdSkuVO prod, List<String> tagCodeList, boolean isEmptyBeforeUpdate) {
        return this.pcsTagService.updateProdTagByCodeList(prod, tagCodeList, isEmptyBeforeUpdate);
    }

    public boolean updatePoPlan(PcsPoPlan po) {
        return this.pcsPoPlanService.updatePoPlan(po);
    }

    public boolean updatePoPlanLine(PcsPoPlanLine line) {
        return this.pcsPoPlanService.updatePoPlanLine(line);
    }

    public Integer getJobLineRealConsumeAmount(Long id, String skuCode) {
        return this.prdcJobLineService.getJobLineRealConsumeAmount(id, skuCode);
    }

    public int getPrdcJobMaxTask(WhWmsPrdcJobTaskVO vo) {
        return this.prdcJobService.getPrdcJobMaxTask(vo);
    }

    public boolean updatePrdcJobWhenTaskFinish(WhWmsPrdcJobTaskVO vo) {
        return this.prdcJobService.updatePrdcJobWhenTaskFinish(vo);
    }

    public void updatePrdcJobWhenTaskFinish() {
        CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("prdcJobFinishCheck");
        if (config == null) {
            return;
        }
        String value = config.getConfigValue();
        if (!org.springframework.util.StringUtils.isEmpty((Object)value) && "1".equals(value)) {
            this.prdcJobService.updatePrdcJobWhenTaskFinish(null);
        }
    }

    public List<PcsPoPlanLine> findPoPlanLineByPoPlanId(Long poPlandId) {
        return this.pcsPoPlanLineService.findPoPlanLineByPoPlanId(poPlandId);
    }

    public boolean isAllPoPlanFinished(Long poId) {
        return this.pcsPoPlanService.isAllPoPlanFinished(poId);
    }

    public boolean isAllReceivePo(Long poId) {
        return this.pcsPoPlanService.isAllReceivePo(poId);
    }

    public PcsPoPlan findPcsPoPlanByKey(Long id) {
        return this.pcsPoPlanService.findPoPlanById(id);
    }

    public boolean updatePcsPurchaseOrderById(PcsPurchaseOrder pcsPurchaseOrder) {
        return this.pcsPurchaseOrderService.update(pcsPurchaseOrder);
    }

    public PcsPurchaseOrder findPcsPurchaseOrderById(Long id) {
        PcsPurchaseOrder pcsPurchaseOrder = this.pcsPurchaseOrderService.findPoById(id);
        return pcsPurchaseOrder;
    }

    public Boolean closePoPlanByPlanId(Long poPlandId) {
        return this.pcsPoPlanService.closePoPlanByPlanId(poPlandId);
    }

    public PcsPoPlan findPcsPoPlanByCode(String code) {
        return this.pcsPoPlanService.findPoPlanByCode(code);
    }

    public void processReceicePlan(String poPlanCode, Map<String, Integer> liangpinMap, Map<String, Integer> canciMap) {
        this.pcsPurchaseOrderService.processReceicePlan(poPlanCode, liangpinMap, canciMap);
    }

    public boolean createPcsCertificateField(PcsCertificateField field) {
        return this.pcsCertificateFieldService.create(field);
    }

    public boolean updatePcsCertificateField(PcsCertificateField field) {
        return this.pcsCertificateFieldService.update(field);
    }

    public boolean deletePcsCertificateFieldById(int id) {
        return this.pcsCertificateFieldService.deleteById(id);
    }

    public List<PcsCertificateFieldVO> findPcsCertificateField(PcsCertificateFieldCond cond) {
        return this.pcsCertificateFieldService.findPcsCertificateField(cond);
    }

    public List<PcsCertificateFieldVO> findPcsCertificateField(PcsCertificateFieldCond cond, boolean cascade) {
        return this.pcsCertificateFieldService.findPcsCertificateField(cond, cascade);
    }

    public PcsCertificateFieldVO findPcsCertificateFieldById(int id) {
        return this.pcsCertificateFieldService.findPcsCertificateFieldById(id);
    }

    public List<PcsCertificateSkuField> findAllPcsCertificateSkuField() {
        return this.pcsCertificateSkuFieldService.findAll();
    }

    public List<PcsCertificateSkuField> findAllPcsCertificateSkuFieldSku() {
        return this.pcsCertificateSkuFieldService.findAllSkuField();
    }

    public List<PcsCertificateSkuField> findAllPcsCertificateSkuFieldSys() {
        return this.pcsCertificateSkuFieldService.findAllSysField();
    }

    public String getFieldValueBySkuCode(PcsCertificateSkuFieldVO field, String skuCode) {
        return this.pcsCertificateSkuFieldService.getFieldValueBySkuCode(field, skuCode);
    }

    public boolean addPcsCertificateTag(PcsCertificateTagVO vo) {
        return this.pcsCertificateTagService.addPcsCertificateTag(vo);
    }

    public boolean addPcsCertificateTag(List<PcsCertificateTagVO> vos) {
        return this.pcsCertificateTagService.addPcsCertificateTag(vos);
    }

    public List<WhReleaseOccupationVO> buildWhRelease(List<PrdcJobLineVO> prdcJobLineVOList, Integer occupyType) {
        return this.prdcJobService.buildWhRelease(prdcJobLineVOList, occupyType);
    }

    public List<WhInvOccupy> buildWhOccupy(List<PrdcJobLineVO> prdcJobLineVOList, String warehouseCode, Integer occupyType) {
        return this.prdcJobService.buildWhOccupy(prdcJobLineVOList, warehouseCode, occupyType);
    }

    public Boolean checkOccupyAndUpdate(PrdcJobVO jobVO, List<WhInvOccupy> whInvOccupyList) {
        return this.prdcJobService.checkOccupyAndUpdate(jobVO, whInvOccupyList);
    }

    public PcsCertificateTagEditVO getTagAndSkuBySkuCode(String skuCode) {
        return this.pcsCertificateTagService.getTagAndSkuBySkuCode(skuCode);
    }

    public List<PcsCertificateTagFieldValueVO> getTagFieldsSkuBySkuCode(String skuCode) {
        return this.pcsCertificateTagService.getTagFieldsSkuBySkuCode(skuCode);
    }

    public int saveCertificateTagBySkuCode(PcsCertificateTag pcsCertificateTag) {
        return this.pcsCertificateTagService.saveCertificateTagBySkuCode(pcsCertificateTag);
    }

    public void updateCertificateTagBySkuCode(PcsCertificateTag pcsCertificateTag) {
        this.pcsCertificateTagService.updateCertificateTagBySkuCode(pcsCertificateTag);
    }

    public List<PcsCertificateTagVO> getCertificateTagBySkuCodes(List<String> skuCodes) {
        return this.pcsCertificateTagService.getCertificateTagBySkuCodes(skuCodes);
    }

    public List<PcsCertificateTagVO> getTagBySkuCodeBarCode(PrintCerVO cond) {
        return this.pcsCertificateTagService.getTagBySkuCodeBarCode(cond);
    }

    public void saveCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField) {
        this.pcsCertificateTagService.saveCertificateTagFieldBySkuCode(pcsCertificateTagField);
    }

    public void updateCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField) {
        this.pcsCertificateTagService.updateCertificateTagFieldBySkuCode(pcsCertificateTagField);
    }

    public void deleteCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField) {
        this.pcsCertificateTagService.deleteCertificateTagFieldBySkuCode(pcsCertificateTagField);
    }

    public List<PcsCertificateFieldVO> getTagFieldsSkuByIds(List<Integer> ids) {
        return this.pcsCertificateTagService.getTagFieldsSkuByIds(ids);
    }

    public PcsCertificateTagVO searchTagBySkuCode(PcsCertificateTag pcsCertificateTag) {
        return this.pcsCertificateTagService.searchTagBySkuCode(pcsCertificateTag);
    }

    public void deleteFrontCategoryRelationList(List<Long> idList) {
        this.pcsSkuCategoryService.deleteFrontCategoryRelationList(idList);
    }

    public void deleteBackCategoryRelationList(List<Long> idList) {
        this.pcsSkuCategoryService.deleteBackCategoryRelationList(idList);
    }

    public List<PcsSkuReceiveStandardVO> listSkuByCond(PcsSkuReceiveStandardCond cond) {
        return this.pcsSkuReceiveStandardService.listSkuByCond(cond);
    }

    public PcsSkuReceiveStandardVO findPcsSkuReceiveStandardBySkuCode(String skuCode) {
        return this.pcsSkuReceiveStandardService.findPcsSkuReceiveStandardBySkuCode(skuCode);
    }

    public boolean createOrEditSkuReceiveStandard(PcsSkuReceiveStandardVO vo) {
        return this.pcsSkuReceiveStandardService.createOrEditSkuReceiveStandard(vo);
    }

    public List<PcsSkuReceiveStandardRuleVO> findAllReceiveStandardRule() {
        return this.pcsSkuReceiveStandardService.findAllReceiveStandardRule();
    }

    public List<PcsSkuReceiveStandardRuleVO> findSkuReceiveStandardRule(String skuCode) {
        return this.pcsSkuReceiveStandardService.findSkuReceiveStandardRule(skuCode);
    }

    public PcsSkuReceiveStandardRuleVO findReceiveStandardRuleVOById(Long id) {
        return this.pcsSkuReceiveStandardService.findReceiveStandardRuleVOById(id);
    }

    public boolean createReceiveStandardRule(PcsSkuReceiveStandardRuleVO vo) {
        return this.pcsSkuReceiveStandardService.createReceiveStandardRule(vo);
    }

    public boolean updateReceiveStandardRule(PcsSkuReceiveStandardRuleVO vo) {
        return this.pcsSkuReceiveStandardService.updateReceiveStandardRule(vo);
    }

    public boolean deleteReceiveStandardRule(Long id) {
        return this.pcsSkuReceiveStandardService.deleteReceiveStandardRule(id);
    }

    public List<PcsSkuVO> findSkuByIds(List<Long> ids) {
        return this.pcsSkuService.findSkuByIds(ids);
    }

    public List<PcsSkuVO> findSkuAuditByIds(List<Long> ids) {
        return this.pcsSkuService.findSkuAuditByIds(ids);
    }

    public List<PcsSkuSalesPriceChange> findByCodeAndStatus(String code, Integer status) {
        return this.pcsSkuSalesPriceChangeService.findByCodeAndStatus(code, status);
    }

    public List<ProdSkuVO> queryProdWatermarkListByParams(List<String> params) {
        return this.pcsWatermarkService.queryProdWatermarkListByParams(params);
    }

    public ProdSkuVO queryProductByProdId(Long prodId) {
        return this.pcsWatermarkService.queryProductByProdId(prodId);
    }

    public List<PrdcJob> findSkuReportJobVO() {
        return this.prdcJobService.findSkuReportJobVO();
    }

    public int deleteProdTagByIds(List<String> idList) {
        return this.pcsTagService.deleteProdTagByIds(idList);
    }

    public List<PcsCertificateTagFieldValueVO> getTagsBySkuCode(List<String> skuCodes) {
        List<PcsCertificateTagFieldValueVO> list = this.pcsCertificateFieldService.getTagsBySkuCode(skuCodes);
        return list;
    }

    public int createPoPlanFee(PcsPoPlanCost pcsPoPlanCost) {
        return this.pcsPoPlanService.createPoPlanFee(pcsPoPlanCost);
    }

    public List<PcsPoPlanCost> selectCostByPoPlanId(Integer poPlanId) {
        return this.pcsPoPlanService.selectCostByPoPlanId(poPlanId);
    }

    public Long insertIntoCategoryFrontEntity(Map<String, Object> map) {
        return this.pcsSkuCategoryService.insertIntoCategoryFrontEntity(map);
    }

    public Long updateCategoryFrontEntity(Map<String, Object> map) {
        return this.pcsSkuCategoryService.updateCategoryFrontEntity(map);
    }

    public List<PcsSkuBarcodeVO> selectByBarCode(String barCode) {
        return this.pcsSkuService.selectByBarCode(barCode);
    }

    public int updatePoPlanFee(PcsPoPlanCost pcsPoPlanCost, int optType) {
        return this.pcsPoPlanService.updatePoPlanFee(pcsPoPlanCost, optType);
    }
}

