package com.thebeastshop.pegasus.service.purchase.vo;

import java.io.Serializable;
import java.util.List;

import javax.validation.constraints.NotNull;

import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

/**
 * watermark,sku,product 关联VO类
 * @author xuwei
 * @since 2016-07-12
 */
@ExcelTemplate
@ExcelSheet(value = "SKUCODE")
public class ProdSkuVO implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Long id;
	
	@ExcelColumn(name="PRODCODE")
    private String prodCode;
	
	private Long prodId;
	
    private String prodName;
	
    private String prodNameCN;
    
	@ExcelColumn(name="SKUCODE")
	@NotNull
    private String skuCode;
	
    private String skuName;
	
    private String skuNameCN;
    
    private List<ProdSkuVO> pcsSkuList;

    public ProdSkuVO(String skuCode, String skuName, String skuNameCN) {
		super();
		this.skuCode = skuCode;
		this.skuName = skuName;
		this.skuNameCN = skuNameCN;
	}
    
	public ProdSkuVO(String prodCode, Long prodId) {
		super();
		this.prodCode = prodCode;
		this.prodId = prodId;
	}



	public ProdSkuVO() {
		super();
		// TODO Auto-generated constructor stub
	}


	public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

	public String getProdCode() {
		return prodCode;
	}

	public void setProdCode(String prodCode) {
		this.prodCode = prodCode;
	}
	
	public Long getProdId() {
		return prodId;
	}

	public void setProdId(Long prodId) {
		this.prodId = prodId;
	}

	public String getProdName() {
		return prodName;
	}

	public void setProdName(String prodName) {
		this.prodName = prodName;
	}

	public String getProdNameCN() {
		return prodNameCN;
	}

	public void setProdNameCN(String prodNameCN) {
		this.prodNameCN = prodNameCN;
	}

	public String getSkuCode() {
		return skuCode;
	}

	public void setSkuCode(String skuCode) {
		this.skuCode = skuCode;
	}

	public String getSkuName() {
		return skuName;
	}

	public void setSkuName(String skuName) {
		this.skuName = skuName;
	}

	public String getSkuNameCN() {
		return skuNameCN;
	}

	public void setSkuNameCN(String skuNameCN) {
		this.skuNameCN = skuNameCN;
	}

	public List<ProdSkuVO> getPcsSkuList() {
		return pcsSkuList;
	}

	public void setPcsSkuList(List<ProdSkuVO> pcsSkuList) {
		this.pcsSkuList = pcsSkuList;
	}
}
