/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.model.PrdcJob;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipe;
import com.thebeastshop.pegasus.service.purchase.service.PrdcJobLineService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcJobService;
import com.thebeastshop.pegasus.service.warehouse.PegasusWarehouseServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsPrdcJobTaskDetail;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotNull;

/**
 * @author Eric.Lou
 * @version $Id: PrdcJobVO.java, v 0.1 2016-01-04 上午10:34
 */
@ExcelTemplate
@ExcelSheet("生产任务管理")
public class PrdcJobVO extends PrdcJob implements Serializable {

    @Autowired
    private PrdcJobService prdcJobService;

    //base
    private Long id;
    // constructor
    public PrdcJobVO(){

    }

    // original
    private Integer planStatus;
    private String warehouseCode;
    //仓库名称
    @ExcelColumn(name="生产加工仓")
    @NotNull
    private String warehouseName;
    
    //加工类型中文描述
    @ExcelColumn(name="加工类型")
    @NotNull
    private String jobTypeCN;
    // self
    private String recipeName;
    private String skuName;
    private List<PrdcJobLineVO> prdcJobLineVOList;

    
    
    public PrdcJobService getPrdcJobService() {
		return prdcJobService;
	}

	public void setPrdcJobService(PrdcJobService prdcJobService) {
		this.prdcJobService = prdcJobService;
	}

	public String getJobTypeCN() {
		return jobTypeCN;
	}

	public void setJobTypeCN(String jobTypeCN) {
		this.jobTypeCN = jobTypeCN;
	}

	public void setWarehouseName(String warehouseName) {
		this.warehouseName = warehouseName;
	}

	// manual generate
    /**
     * 状态名称
     * @return
     */
    public String getPlanStatusName(){
        return planStatus==null?"error":
                planStatus.equals(PrdcJob.PLAN_STATUS_CANCEL)?"取消":
                        planStatus.equals(PrdcJob.PLAN_STATUS_CONFIRM)?"待确认":
                                planStatus.equals(PrdcJob.PLAN_STATUS_RETURN_MODIFY)?"待修改":
                                        planStatus.equals(PrdcJob.PLAN_STATUS_PROCESSING)?"执行中":
                        planStatus.equals(PrdcJob.PLAN_STATUS_FINISHED)?"完成":
                                planStatus.equals(PrdcJob.PLAN_STATUS_CANCEL)?"取消":
                                        planStatus.equals(PrdcJob.PLAN_STATUS_FINISHED)?"完成":
                                                planStatus.equals(PrdcJob.WMS_STATUS_RETURN_MODIFY)?"待加工":
                                                        planStatus.equals(PrdcJob.WMS_PLAN_STATUS_PROCESSING)?"加工中":
                                                                planStatus.equals(PrdcJob.WMS_PLAN_STATUS_PARTFINISHED)?"部分完成":
                                                                        planStatus.equals(PrdcJob.WMS_PLAN_STATUS_FINISHED)?"加工完成":"";
    }

    /**
     * 状态名称
     * @return
     */
    public String getWmsPlanStatusName(){
        return planStatus==null?"error":
                planStatus.equals(PrdcJob.PLAN_STATUS_CANCEL)?"取消":
                                                planStatus.equals(PrdcJob.PLAN_STATUS_FINISHED)?"完成":
                                                        planStatus.equals(PrdcJob.WMS_STATUS_RETURN_MODIFY)?"待加工":
                                                                planStatus.equals(PrdcJob.WMS_PLAN_STATUS_PROCESSING)?"加工中":
                                                                        planStatus.equals(PrdcJob.WMS_PLAN_STATUS_PARTFINISHED)?"部分完成":
                                                                                planStatus.equals(PrdcJob.WMS_PLAN_STATUS_FINISHED)?"加工完成":"";
    }

    /**
     * 配送仓库名称
     *
     * @return
     */
    public String getWarehouseName() {
        String name = "";
        if (NullUtil.isNotNull(warehouseCode)) {
            WhWarehouse wh = PegasusWarehouseServiceFacade.getInstance().findWarehouseByCode(warehouseCode);
            if (NullUtil.isNotNull(wh) && EmptyUtil.isNotEmpty(wh.getName())) {
                name = wh.getName();
            }
        }
        return name;
    }



    /**
     * 物理仓名称
     *
     * @return
     */
    public String getPhysicalWarehouseName() {
        String name = "";
        if (NullUtil.isNotNull(warehouseCode)) {
            WhPhysicalWarehouse wh = PegasusWarehouseServiceFacade.getInstance().findPhysicalWarehouseByWarehouse(warehouseCode);
            if (NullUtil.isNotNull(wh) && EmptyUtil.isNotEmpty(wh.getName())) {
                name = wh.getName();
            }
        }
        return name;
    }



    // auto generate


    @Override
    public Integer getPlanStatus() {
        return planStatus;
    }

    @Override
    public void setPlanStatus(Integer planStatus) {
        this.planStatus = planStatus;
    }

    @Override
    public String getWarehouseCode() {
        return warehouseCode;
    }

    @Override
    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getRecipeName() {
        return recipeName;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public void setRecipeName(String recipeName) {
        this.recipeName = recipeName;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public List<PrdcJobLineVO> getPrdcJobLineVOList() {
        return prdcJobLineVOList;
    }

    public void setPrdcJobLineVOList(List<PrdcJobLineVO> prdcJobLineVOList) {
        this.prdcJobLineVOList = prdcJobLineVOList;
    }
}
