/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsChannelQuantity;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumnList;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @author 郭锋
 * @模板下载vo
 */
@ExcelTemplate
public class PcsPurchaseTemplate implements Serializable {

    // constructor
    public PcsPurchaseTemplate() {

    }

    @ExcelColumn(name="供应商编码")
    @Min(value = 0)
    @NotNull
    private Long supplierId;

    @ExcelColumn(name="目标仓库编码")
    @NotNull
    private String warehouseCode;

    @ExcelColumn(name="其他费用")
    @NotNull
    private BigDecimal otherFee;

    @ExcelColumn(name="增值税百分比（填整数）%")
    @NotNull
    private BigDecimal otherFeeTaxRate;

    @ExcelColumn(name="要求交货日期")
    private Date askDeliveryDate;

    @ExcelColumn(name="币种")
    @NotNull
    private String purchaseCurrencyCode;

    @ExcelColumn(name="skucode")
    @NotNull
    private String skuCode;
    
    @ExcelColumn(name="数量")
    @NotNull
    private Integer quantity;

    @ExcelColumn(name="单价")
    @NotNull
    private BigDecimal unitPrice;
    
    @ExcelColumn(name="税率")
    @NotNull
    private BigDecimal taxRate;

	public Long getSupplierId() {
		return supplierId;
	}

	public void setSupplierId(Long supplierId) {
		this.supplierId = supplierId;
	}

	public String getWarehouseCode() {
		return warehouseCode;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}

	public BigDecimal getOtherFee() {
		return otherFee;
	}

	public void setOtherFee(BigDecimal otherFee) {
		this.otherFee = otherFee;
	}

	public BigDecimal getOtherFeeTaxRate() {
		return otherFeeTaxRate;
	}

	public void setOtherFeeTaxRate(BigDecimal otherFeeTaxRate) {
		this.otherFeeTaxRate = otherFeeTaxRate;
	}

	public Date getAskDeliveryDate() {
		return askDeliveryDate;
	}

	public void setAskDeliveryDate(Date askDeliveryDate) {
		this.askDeliveryDate = askDeliveryDate;
	}

	public String getPurchaseCurrencyCode() {
		return purchaseCurrencyCode;
	}

	public void setPurchaseCurrencyCode(String purchaseCurrencyCode) {
		this.purchaseCurrencyCode = purchaseCurrencyCode;
	}

	public String getSkuCode() {
		return skuCode;
	}

	public void setSkuCode(String skuCode) {
		this.skuCode = skuCode;
	}

	public Integer getQuantity() {
		return quantity;
	}

	public void setQuantity(Integer quantity) {
		this.quantity = quantity;
	}

	public BigDecimal getUnitPrice() {
		return unitPrice;
	}

	public void setUnitPrice(BigDecimal unitPrice) {
		this.unitPrice = unitPrice;
	}

	public BigDecimal getTaxRate() {
		return taxRate;
	}

	public void setTaxRate(BigDecimal taxRate) {
		this.taxRate = taxRate;
	}


}
