/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

/**
 * @author Eric.Lou
 * @version $Id: PcsPurchaseOrderVO.java, v 0.1 2015-08-10 09:50
 */
@ExcelTemplate
@ExcelSheet(value = "sheet1")
public class PcsPurchaseOrderVO implements Serializable {

    // constructor
    public PcsPurchaseOrderVO() {

    }

    // original
    private Long id;

    @ExcelColumn(name="供应商编码")
    @Min(value = 0)
    @NotNull
    private Long supplierId;

    private String code;

    @ExcelColumn(name="目标仓库编码")
    @NotNull
    private String warehouseCode;

    private Integer purchaseOrderStatus;

    private Date createTime;

    private Long createOperatorId;

    private String createOperatorName;

    private Date auditTime;

    private Date finishedTime;

    @ExcelColumn(name="其他费用")
    @NotNull
    private BigDecimal otherFee;

    @ExcelColumn(name="增值税百分比（填整数）%")
    @NotNull
    private BigDecimal otherFeeTaxRate;

    @ExcelColumn(name="要求交货日期")
    private Date askDeliveryDate;

   
    private String purchaseCurrencyCode;

    @ExcelColumn(name="币种")
    @NotNull
    private String purchaseCurrencyDesc;

    private BigDecimal totalAmount;

    private BigDecimal totalAmountAfterTax;

    private Integer isReceivedAll;

    private String remark;

    // self
    private String supplierName;

    private String supplierNameCn;

    private String warehouseName;


    //@ExcelColumnList(from = 5, to = -1, type = PcsPoLineVO.class, columnFiled = "skuCode", valueField = "quantity")
    private List<PcsPoLineVO> pcsPoLineVOList;

    private boolean saveDraft;
    
    //收货计划列表
    private List<PcsPoPlanVO> pcsPoPlanVOList;
    
    private BigDecimal taxes;
    
    private Integer crossBorderFlag;
    
    private Integer includeShipment;
    
    private BigDecimal logisticsCost;
    

    
    public BigDecimal getTaxes() {
		return taxes;
	}

	public void setTaxes(BigDecimal taxes) {
		this.taxes = taxes;
	}

	public Integer getCrossBorderFlag() {
		return crossBorderFlag;
	}

	public void setCrossBorderFlag(Integer crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}

	public Integer getIncludeShipment() {
		return includeShipment;
	}

	public void setIncludeShipment(Integer includeShipment) {
		this.includeShipment = includeShipment;
	}

	public BigDecimal getLogisticsCost() {
		return logisticsCost;
	}

	public void setLogisticsCost(BigDecimal logisticsCost) {
		this.logisticsCost = logisticsCost;
	}

	public List<PcsPoPlanVO> getPcsPoPlanVOList() {
		return pcsPoPlanVOList;
	}

	public void setPcsPoPlanVOList(List<PcsPoPlanVO> pcsPoPlanVOList) {
		this.pcsPoPlanVOList = pcsPoPlanVOList;
	}

	// manual generate
    public String getPurchaseOrderStatusName(){
        return purchaseOrderStatus == null ? "" :
                purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT) ? "草稿" :
                        purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT) ? "待审核" :
                                purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_REJECT) ? "已驳回" :
                                        purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE) ? "收货中" :
                                                purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH) ? "已完成" : "";
    }

    // auto generate
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public Integer getPurchaseOrderStatus() {
        return purchaseOrderStatus;
    }

    public void setPurchaseOrderStatus(Integer purchaseOrderStatus) {
        this.purchaseOrderStatus = purchaseOrderStatus;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getCreateOperatorId() {
        return createOperatorId;
    }

    public void setCreateOperatorId(Long createOperatorId) {
        this.createOperatorId = createOperatorId;
    }

    public String getCreateOperatorName() {
        return createOperatorName;
    }

    public void setCreateOperatorName(String createOperatorName) {
        this.createOperatorName = createOperatorName;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Date getFinishedTime() {
        return finishedTime;
    }

    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    public BigDecimal getOtherFee() {
        return otherFee;
    }

    public void setOtherFee(BigDecimal otherFee) {
        this.otherFee = otherFee;
    }

    public BigDecimal getOtherFeeTaxRate() {
        return otherFeeTaxRate;
    }

    public void setOtherFeeTaxRate(BigDecimal otherFeeTaxRate) {
        this.otherFeeTaxRate = otherFeeTaxRate;
    }

    public Date getAskDeliveryDate() {
        return askDeliveryDate;
    }

    public void setAskDeliveryDate(Date askDeliveryDate) {
        this.askDeliveryDate = askDeliveryDate;
    }

    public String getPurchaseCurrencyCode() {
        return purchaseCurrencyCode;
    }

    public void setPurchaseCurrencyCode(String purchaseCurrencyCode) {
        this.purchaseCurrencyCode = purchaseCurrencyCode;
    }

    public String getPurchaseCurrencyDesc() {
        return purchaseCurrencyDesc;
    }

    public void setPurchaseCurrencyDesc(String purchaseCurrencyDesc) {
        this.purchaseCurrencyDesc = purchaseCurrencyDesc;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getTotalAmountAfterTax() {
        return totalAmountAfterTax;
    }

    public void setTotalAmountAfterTax(BigDecimal totalAmountAfterTax) {
        this.totalAmountAfterTax = totalAmountAfterTax;
    }

    public Integer getIsReceivedAll() {
        return isReceivedAll;
    }

    public void setIsReceivedAll(Integer isReceivedAll) {
        this.isReceivedAll = isReceivedAll;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSupplierNameCn() {
        return supplierNameCn;
    }

    public void setSupplierNameCn(String supplierNameCn) {
        this.supplierNameCn = supplierNameCn;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public List<PcsPoLineVO> getPcsPoLineVOList() {
        return pcsPoLineVOList;
    }

    public void setPcsPoLineVOList(List<PcsPoLineVO> pcsPoLineVOList) {
        this.pcsPoLineVOList = pcsPoLineVOList;
    }

    public boolean isSaveDraft() {
        return saveDraft;
    }

    public void setSaveDraft(boolean saveDraft) {
        this.saveDraft = saveDraft;
    }

}
