/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.vo;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PcsPoPlanVO.java, v 0.1 2015-08-10 09:58
 */
public class PcsPoPlanVO implements Serializable {

    // constructor
    public PcsPoPlanVO() {

    }

    // original
    private Long id;

    private Long poId;

    private Integer planStatus;

    private String code;

    private String whCommandCode;

    private Date planedReceiveDate;

    private Date receiveDate;

    private Date planedSendDate;
    // self
    private List<PcsPoPlanLineVO> pcsPoPlanLineVOList;
    
    private Boolean hasFillFee = false;// 是否已填费用
    
    

    public Boolean getHasFillFee() {
		return hasFillFee;
	}

	public void setHasFillFee(Boolean hasFillFee) {
		this.hasFillFee = hasFillFee;
	}

	// manual generate
    public String getPlanStatusName() {
        String name = "";
        switch (planStatus){
            case 0 :name="待收货";break;
            case 1 :name="待入库";break;
            case 2 :name="已入库";break;
            case 3 :name="已完成";break;
            case 4 :name="已关闭";break;
            case 5 :name="入库中";
        }

        return name;
    }

    // auto generate
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPoId() {
        return poId;
    }

    public void setPoId(Long poId) {
        this.poId = poId;
    }

    public Integer getPlanStatus() {
        return planStatus;
    }

    public void setPlanStatus(Integer planStatus) {
        this.planStatus = planStatus;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getWhCommandCode() {
        return whCommandCode;
    }

    public void setWhCommandCode(String whCommandCode) {
        this.whCommandCode = whCommandCode;
    }

    public Date getPlanedReceiveDate() {
        return planedReceiveDate;
    }

    public void setPlanedReceiveDate(Date planedReceiveDate) {
        this.planedReceiveDate = planedReceiveDate;
    }

    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }

    public Date getPlanedSendDate() {
        return planedSendDate;
    }

    public void setPlanedSendDate(Date planedSendDate) {
        this.planedSendDate = planedSendDate;
    }

    public List<PcsPoPlanLineVO> getPcsPoPlanLineVOList() {
        return pcsPoPlanLineVOList;
    }

    public void setPcsPoPlanLineVOList(List<PcsPoPlanLineVO> pcsPoPlanLineVOList) {
        this.pcsPoPlanLineVOList = pcsPoPlanLineVOList;
    }

}
