/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.vo;

import java.io.Serializable;
import java.math.BigDecimal;

import javax.validation.constraints.NotNull;

import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

/**
 * @author Eric.Lou
 * @version $Id: PcsPoLineVO.java, v 0.1 2015-08-10 09:54
 */
@ExcelTemplate
@ExcelSheet(value = "sheet1")
public class PcsPoLineVO implements Serializable {

    // constructor
    public PcsPoLineVO() {

    }

    // original
    private Long id;

    private Long poId;

    @ExcelColumn(name="skucode")
    @NotNull
    private String skuCode;

    @ExcelColumn(name="数量")
    @NotNull
    private Integer quantity;

    @ExcelColumn(name="单价")
    @NotNull
    private BigDecimal unitPrice;

    private BigDecimal totalPrice;

    @ExcelColumn(name="税率")
    @NotNull
    private BigDecimal taxRate;


    private String taxRateDesc;

    private BigDecimal unitPriceAfterTax;

    private BigDecimal totalPriceAfterTax;
    // self
    private String skuName;

    private String skuNameCn;

    private BigDecimal skuCostPrice;

    private String skuPicFileId;

    private Integer skuQuantity;

    private Integer skuWasteQuantity;
    
    private Integer maxPlanReceiveNum;
    
    /*待入库数量*/
    private Integer toStorageQuantity;
    // manual generate
    
    //首次售价审核是否通过
    private Boolean firstAuditPass;
    
    private Integer planStatus;
    
    
    

    public Integer getPlanStatus() {
		return planStatus;
	}

	public void setPlanStatus(Integer planStatus) {
		this.planStatus = planStatus;
	}

	public Boolean getFirstAuditPass() {
		return firstAuditPass;
	}

	public void setFirstAuditPass(Boolean firstAuditPass) {
		this.firstAuditPass = firstAuditPass;
	}

	public Integer getToStorageQuantity() {
		return toStorageQuantity;
	}

	public void setToStorageQuantity(Integer toStorageQuantity) {
		this.toStorageQuantity = toStorageQuantity;
	}

	public Integer getMaxPlanReceiveNum() {
		return maxPlanReceiveNum;
	}

	public void setMaxPlanReceiveNum(Integer maxPlanReceiveNum) {
		this.maxPlanReceiveNum = maxPlanReceiveNum;
	}

	// auto generate
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPoId() {
        return poId;
    }

    public void setPoId(Long poId) {
        this.poId = poId;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getTaxRateDesc() {
        return taxRateDesc;
    }

    public void setTaxRateDesc(String taxRateDesc) {
        this.taxRateDesc = taxRateDesc;
    }

    public BigDecimal getUnitPriceAfterTax() {
        return unitPriceAfterTax;
    }

    public void setUnitPriceAfterTax(BigDecimal unitPriceAfterTax) {
        this.unitPriceAfterTax = unitPriceAfterTax;
    }

    public BigDecimal getTotalPriceAfterTax() {
        return totalPriceAfterTax;
    }

    public void setTotalPriceAfterTax(BigDecimal totalPriceAfterTax) {
        this.totalPriceAfterTax = totalPriceAfterTax;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public BigDecimal getSkuCostPrice() {
        return skuCostPrice;
    }

    public void setSkuCostPrice(BigDecimal skuCostPrice) {
        this.skuCostPrice = skuCostPrice;
    }

    public String getSkuPicFileId() {
        return skuPicFileId;
    }

    public void setSkuPicFileId(String skuPicFileId) {
        this.skuPicFileId = skuPicFileId;
    }

    public String getSkuNameCn() {
        return skuNameCn;
    }

    public void setSkuNameCn(String skuNameCn) {
        this.skuNameCn = skuNameCn;
    }

    public Integer getSkuQuantity() {
        return skuQuantity;
    }

    public void setSkuQuantity(Integer skuQuantity) {
        this.skuQuantity = skuQuantity;
    }

    public Integer getSkuWasteQuantity() {
        return skuWasteQuantity;
    }

    public void setSkuWasteQuantity(Integer skuWasteQuantity) {
        this.skuWasteQuantity = skuWasteQuantity;
    }

}
